import React, { Component } from 'react';

import {Button,ChoiceList, Checkbox, Card, Form, FormLayout, Layout, Page, Stack, TextField, Select, FooterHelp, Link, Toast, Tabs} from '@shopify/polaris';

class PaymentPolicyForm extends Component{
  _isMounted = false;

  state = {
    trim_title:false,
    name: "Ebay Payment Profile",
    paypal_email: "",
    immediate_payment: "",
    payment_methods: [],
    payment_instructions: "",
    selected_tab:0,
    fields_type:'required',
    payment_method_options: []
  };

  errors_data = {};

  ebay_profile = {};

  yes_no_options = [
    {label:"Select a Option",value:""},
    {value:"1",label:'Yes'},
    {value:"0",label:'No'}
  ];

  tabs = [
    {
      id: 'required',
      content: 'Required Fields',
      accessibilityLabel: 'Required Fields',
      panelID: 'required-fields',
    }
  ];

  constructor(props){
    super(props);
    this.handleChange = this.handleChange.bind(this);
    this.addProfile = this.addProfile.bind(this);
    this.hideToast = this.hideToast.bind(this);
  }

  componentWillUnmount(){
    this._isMounted = false;
  }

  componentDidMount(){
    this._isMounted = true;
    //console.log(this.props.store_data);
    this.ebay_profile = this.props.store_data.ebay_profile || {};

    fetch(this.props.api_url+'/ebayspecificdata'+'?shopify_url='+this.props.store_data.shopify_url+'&api_token='+this.props.store_data.user.api_token)
    .then(res => res.json())
    .then((data) => {
      if(data){
        var ckey;

        var payment_method_options = [];
        for(ckey in data.payment_methods){
          payment_method_options.push({label: data.payment_methods[ckey].value, value: (data.payment_methods[ckey].id).toString()});
        }
        this.setState(() => {
          return {
            payment_method_options:payment_method_options
          };
        });
      }
    })
    .catch(console.log);

    this.setState({page_title: "New Payment Profile",sub_title: "Add Ebay Payment Profile",sub_description: "Enter profile data and click on Save."});
  }

  handleTabChange = (value) => {
    let tab = this.tabs[value];
    this.setState(() => { return {fields_type:tab.id,selected_tab:value} });
  };

  addProfile(){    
    console.log(this.props.store_data);
    var hasError = false;
    this.errors_data = {};
    if(this.state.name.length <= 0){
      hasError = true;
      this.errors_data.name_error = "name is required";
    }
    
    if(this.state.payment_methods.length <= 0){
      hasError = true;
      this.errors_data.payment_methods_error = "payment method is required";
    }

    if(hasError === false){
      this.setState({button_loading:true});
      
      var request_data = {
        name: this.state.name,
        paypal_email: this.state.paypal_email,
        immediate_payment: this.state.immediate_payment,
        payment_methods: this.state.payment_methods,
        payment_instructions: this.state.payment_instructions,
        shopify_url:this.props.store_data.shopify_url,
        profile_type:"PAYMENT"
      };
      

      var requestOptions = {
        method: 'POST',
        headers: {'Content-Type': 'application/json'},
        body: JSON.stringify(request_data)
      };
    //  console.log("aaaaaaaaa".this.props.store_data.shopify_url);
    
      var fetch_url = this.props.api_url+'/policies?shopify_url='+this.props.store_data.shopify_url+'&api_token='+this.props.store_data.user.api_token;

      fetch(fetch_url,requestOptions)
      .then(response => response.json())
      .then((data) => {
        console.log(data);
        if(data && data.status && data.status === "success"){
          this.setState(() => { return {button_loading:false,success_message:data.msg}; });
        }
        else{
          var error_message = "there was something wrong, please try again.";
          if(data && data.status && data.status === "error"){
            if(data.errors){
              for(var key in data.errors){
                error_message += key + " : ";
                for(var fkey in data.errors[key]){error_message += data.errors[key][fkey] + "\n";}
                error_message += "\n";
              }
            }
            else if(data.msg){error_message = data.msg;}
          }
        }
        this.setState(() => { return {button_loading:false,error_message:error_message}; } );
      })
      .catch(error => {
        console.error(error);
      });
    }
    else{
      this.setState(() => { return {button_loading:false}; });
    }
  }

  hideToast(){
    this.setState({success_message: null,error_message: null});
  }

  handleChange = (field) => {
    return (value) => {
      console.log(value);
      var ckey;      
      this.setState(() => { return { [field]: value.toString() } });
    }
  };

  handleChoiceListChange = (field) => {
    return (value) => {
      this.setState({ [field]: value });
    }
  };

  render(){
    return (
      <Page title={this.state.page_title}>

        {this.state.success_message &&
          <Toast content={this.state.success_message} onDismiss={this.hideToast} duration="6000" />
        }
        {this.state.error_message &&
          <Toast content={this.state.error_message} error onDismiss={this.hideToast} duration="6000" />
        }

        <Layout>
          <Layout.AnnotatedSection title={this.state.sub_title} description={this.state.sub_description}>
            <Card sectioned>
              <Form onSubmit={this.addProfile} method="post" encType="multipart/form-data" preventDefault="true">

                <Tabs tabs={this.tabs} selected={this.state.selected_tab} onSelect={this.handleTabChange}>

                  {this.state.fields_type === "required" &&

                  <FormLayout>

                    <TextField type="text" label="Profile Name" error={this.errors_data.name_error} value={this.state.name} onChange={this.handleChange('name')} />
                    
                    {this.state.payment_method_options.length > 0 &&
                      <ChoiceList
                        allowMultiple
                        title="Payment Methods"
                        choices={this.state.payment_method_options}
                        error={this.errors_data.payment_methods_error}
                        onChange={this.handleChoiceListChange('payment_methods')}
                        selected={this.state.payment_methods}
                      />
                    }

                    {this.state.payment_methods.indexOf('PayPal') > -1 &&
                    <TextField type="text" label="Paypal Email" error={this.errors_data.paypal_email_error} value={this.state.paypal_email} onChange={this.handleChange('paypal_email')} />
                    }

                    <Select label="Immediate Payment" options={this.yes_no_options} error={this.errors_data.immediate_payment_error} onChange={this.handleChange('immediate_payment')} value={this.state.immediate_payment} />


                    <TextField type="text" label="Payment Instructions" multiline={2} error={this.errors_data.payment_instructions_error} value={this.state.payment_instructions} onChange={this.handleChange('payment_instructions')} />
                    
                  </FormLayout>
                  }
                  
                </Tabs>

                <FormLayout>
                  <Stack distribution="trailing">
                    <Button primary submit loading={this.state.button_loading}>Save</Button>
                  </Stack>
                </FormLayout>
              </Form>
            </Card>
          </Layout.AnnotatedSection>
          <Layout.Section>
            
          </Layout.Section>
        </Layout>
      </Page>
    );
  }
}


export default PaymentPolicyForm;