import React, {Component} from 'react';
//import ReactDOM from 'react-dom';
import {Page, Button, Layout, Card, List, Stack,Loading, Toast} from '@shopify/polaris';

class Plans extends Component
{
  state = {
    plans:{},
    plan_active_loading:false,
    active_disabled:false,
    error_message:null
  };

  constructor(props){
    super(props);
    this.getPlansData = this.getPlansData.bind(this);
    this.activatePlan = this.activatePlan.bind(this);
    this.hideToast = this.hideToast.bind(this);
  }

  componentDidMount() {
    document.title = 'Plans & Pricing - ' + document.title;

    var queryData = [];
    queryData.push("shopify_url=" + this.props.store_data.shopify_url);
    queryData.push("api_token=" + this.props.store_data.user.api_token);
    var queryStr = queryData.join("&");
    fetch(this.props.api_url+'/plans?'+queryStr)
    .then(res => res.json())
    .then((data) => {
      this.setState({ plans: data });
    })
    .catch(console.log);
  }

  hideToast(){
    this.setState({error_message: null});
  }

  activatePlan(plan_id){
   // var confirm = window.confirm("Are you sure, you want to continue?");
   // if(confirm){
      this.setState({plan_active_loading:true,active_disabled:true});

      var request_data = {
        plan_id:plan_id,
        shopify_url:this.props.store_data.shopify_url
      };

      var fetch_url = this.props.api_url+'/app_charges?api_token='+this.props.store_data.user.api_token;
      var requestOptions = {
        method: 'POST',
        headers: {'Content-Type': 'application/json'},
        body: JSON.stringify(request_data)
      };
      fetch(fetch_url,requestOptions)
      .then(response => response.json())
      .then((data) => {
        console.error(data);
        if(data && data.status && data.status === "success"){
          window.location.href = data.redirect_url;
        }
        else if(data && data.msg == "[API] Invalid API key or access token (unrecognized login or wrong password)"){
          var error_message = "Your shopify access token is expired";
          if(data.msg){error_message = data.msg;}
        }
        else{
          var error_message = "there was something wrong, please try again.";
          if(data.msg){error_message = data.msg;}
        }
        if(this._isMounted){
          this.setState({error_message:error_message,plan_active_loading:false,active_disabled:false});
        }
      })
      .catch(error => {
        console.error(error);
      });
   // }
  }
  
  getPlansData(){
    var plans = [];
    if(this.state.plans && this.state.plans.length > 0){
      for(var key in this.state.plans){
        var plan = this.state.plans[key];
        var features = [];
        if(plan.features_list.length > 0){
          for(var fkey in plan.features_list){
            features.push(<List.Item key={"feature_"+fkey}>{plan.features_list[fkey]}</List.Item>);
          }
        }        
        plans.push(<Layout.Section oneThird key={"lsection_"+key}>
          <Card title={plan.name}>
            <Card.Section>
              {plan.price > 0 &&
              <p>$ {plan.price} / month</p>
              }
              {plan.price === 0 &&
              <p>Free</p>
              }

              {plan.trial_days > 0 &&
              <p>{plan.trial_days} days trial</p>
              }
              
            </Card.Section>
            <Card.Section>
              <List type="bullet">
                {features}
              </List>
            </Card.Section>

            <Card.Section>
              <Stack distribution="fill" alignment="center">
                {this.props.store_data.plan.id === plan.id &&
                <Button disabled>Current Plan</Button>
                }
                {this.props.store_data.plan.id !== plan.id &&
                <Button primary onClick={this.activatePlan.bind(this,plan.id)} disabled={this.state.active_disabled}>Activate</Button>
                }
              </Stack>
            </Card.Section>

          </Card>
        </Layout.Section>);
      }
    }
    
    return plans;
  }

  render(){
    return(
      <Page fullWidth  title="Plans & Pricing">
        <Layout>
          {this.state.plan_active_loading === true &&
          <Loading />
          }

          {this.state.error_message &&
            <Toast content={this.state.error_message} error onDismiss={this.hideToast} duration="5000" />
          }

          {this.getPlansData()}
        </Layout>
      </Page>
    );
  }
}

export default Plans;