import React, { Component } from 'react';

import {
  Button,
  Card, 
  Form, 
  FormLayout, 
  Layout, 
  Page, 
  Stack, 
  TextField, 
  Select, 
  FooterHelp, 
  Link, 
  Toast, 
  Tabs
} from '@shopify/polaris';


class ProductForm extends Component{
  _isMounted = false;

  state = {
    title: "",
    item_sub_title: "",
    condition: "",
    condition_note:"",
    item_specific_values:{},
    product:{},
    fields_type:"required",
    selected_tab:0,
    profile_id:""
  };

  errors_data = {};

  item_condition_options = [
    {label:"Select a Option",value:""},
    {value:"New",label:'New'},
    {value:"New other (see details)",label:'New other (see details)'},
    {value:"New with defects",label:'New with defects'},
    {value:"Certified refurbished",label:'Certified refurbished'},
    {value:"Seller refurbished",label:'Seller refurbished'},
    {value:"Like New",label:'Like New'},
    {value:"Used",label:'Used'},
    {value:"Very Good",label:'Very Good'},
    {value:"Good",label:'Good'},
    {value:"Acceptable",label:'Acceptable'},
    {value:"For parts or not working",label:'For parts or not working'}
  ];
  

  tabs = [
    {
      id: 'required',
      content: 'Product Data',
      accessibilityLabel: 'Product Data',
      panelID: 'required-fields',
    }
  ];

  constructor(props){
    super(props);
    this.handleChange = this.handleChange.bind(this);
    this.updateProduct = this.updateProduct.bind(this);
    this.hideToast = this.hideToast.bind(this);
  }

  componentWillUnmount(){
    this._isMounted = false;
  }

  componentDidMount(){
    this._isMounted = true;

    this.ebay_account = this.props.store_data.ebay_account || {};

    this.setState(() => {
      return {
        page_title: "Update Product Data",
        sub_title: "Update Product Data",
        sub_description: "Enter product data and click on Save."
      };
    });
   
    
    fetch(this.props.api_url+'/product/'+this.props.product_id+'?shopify_url='+this.props.store_data.shopify_url+'&api_token='+this.props.store_data.user.api_token)
    .then(res => res.json())
    .then((data) => {

      var title = data.title.substring(0,80);
      var item_sub_title = "";
      var condition = "";
      var condition_note = "";
      var item_specific_values = {};

      if(data.product_data && data.product_data.length > 0){
        if(data.product_data[0].title && data.product_data[0].title !== "" && data.product_data[0].title !== null){
          title = data.product_data[0].title;
        }

        item_sub_title = data.product_data[0].sub_title;
        condition = data.product_data[0].condition;
        condition_note = data.product_data[0].condition_note;
        item_specific_values = data.product_data[0].item_specific_values;
      }
      
      this.setState(() => {
        return {
          product:data,
          title: title,
          item_sub_title: item_sub_title,
          condition: condition,
          condition_note: condition_note,
          item_specific_values: item_specific_values,
        };
      });
    })
    .catch(console.log);
    
  }

  handleTabChange = (value) => {
    let tab = this.tabs[value];
    this.setState(() => { return {fields_type:tab.id,selected_tab:value} });
  };

  updateProduct(){    
    var hasError = false;
    this.errors_data = {};

    /*
    if(this.state.title.length <= 0 || this.state.title.length > 80){
      hasError = true;
      this.errors_data.title_error = "title length must be between 1-80 characters";
    }
    */    

    if(hasError === false){
      this.setState({button_loading:true});

      var request_data = {
        title: this.state.title,
        sub_title: this.state.item_sub_title,
        condition: this.state.condition,
        condition_note: this.state.condition_note,
        item_specific_values: this.state.item_specific_values,
        profile_id: this.state.profile_id,
        shopify_url:this.props.store_data.shopify_url,
        product_id:this.props.product_id
      };
      
      var fetch_url = this.props.api_url+'/product/'+this.props.product_id+'?api_token='+this.props.store_data.user.api_token;
      var requestOptions = {
        method: 'PUT',
        headers: {'Content-Type': 'application/json'},
        body: JSON.stringify(request_data)
      };

      fetch(fetch_url,requestOptions)
      .then(response => response.json())
      .then((data) => {
        if(data && data.status && data.status === "success"){
          this.setState({button_loading:false,success_message:data.msg});
        }
        else{
          var error_message = "there was something wrong, please try again.";
          if(data && data.status && data.status === "error"){
            if(data.errors){
              for(var key in data.errors){
                error_message += key + " : ";
                for(var fkey in data.errors[key]){error_message += data.errors[key][fkey] + "\n";}
                error_message += "\n";
              }
            }
            else if(data.msg){error_message = data.msg;}
          }
        }

        if(this._isMounted){
          this.setState({button_loading:false,error_message:error_message});
        }
      })
      .catch(error => {
        console.error(error);
      });
    }
    else{
      this.setState({button_loading:false});
    }
  }

  hideToast(){
    this.setState({success_message: null,error_message: null});
  }

  handleChange = (field) => {
    return (value) => {
      this.setState(() => { return { [field]: value.toString() } });
    }
  };

  handleItemSpecificFieldChange = (field) => {
    return (value) => {
      let item_specific_values = this.state.item_specific_values;
      item_specific_values[field] = value.toString();
      this.setState(() => {
        return { item_specific_values: item_specific_values };
      });
    }
  };
  
  render(){
    return (
      <Page title={this.state.page_title}>

        {this.state.success_message &&
          <Toast content={this.state.success_message} onDismiss={this.hideToast} duration="6000" />
        }
        {this.state.error_message &&
          <Toast content={this.state.error_message} error onDismiss={this.hideToast} duration="6000" />
        }

        <Layout>
          <Layout.AnnotatedSection title={this.state.sub_title} description={this.state.sub_description}>
            <Card sectioned>
              <Form onSubmit={this.updateProduct} method="post" encType="multipart/form-data" preventDefault="true">

                <Tabs tabs={this.tabs} selected={this.state.selected_tab} onSelect={this.handleTabChange}>

                  {this.state.fields_type === "required" &&

                  <FormLayout>

                    <TextField type="text" label="Item Title" error={this.errors_data.title_error} value={this.state.title} onChange={this.handleChange('title')} />
                    
                    <TextField type="text" label="Sub Title" error={this.errors_data.item_sub_title_error} value={this.state.item_sub_title} onChange={this.handleChange('item_sub_title')} />
                    

                    <Select label="Item Condition" options={this.item_condition_options} error={this.errors_data.condition_error} onChange={this.handleChange('condition')} value={this.state.condition} />

                    <TextField type="text" label="Item Condition Note" multiline={2} error={this.errors_data.condition_note_error} value={this.state.condition_note} onChange={this.handleChange('condition_note')} />
                    

                    <TextField name="brand" type="text" label="Brand" error={this.errors_data.brand_error} value={this.state.item_specific_values["brand"]} onChange={this.handleItemSpecificFieldChange("brand")} />

                    <TextField name="mpn" type="text" label="MPN" error={this.errors_data.mpn_error} value={this.state.item_specific_values["mpn"]} onChange={this.handleItemSpecificFieldChange("mpn")} />

                  
                  </FormLayout>

                  }

                </Tabs>

                <FormLayout>
                  <Stack distribution="trailing">
                    <Button primary submit loading={this.state.button_loading}>Save</Button>
                  </Stack>
                </FormLayout>
              </Form>
            </Card>
          </Layout.AnnotatedSection>
          <Layout.Section>
            <FooterHelp>
               For more details on App, visit our {' '}
              <Link url="https://app1.ecomshore.com/manage_products.pdf" external="true">documentation</Link>.
            </FooterHelp>
          </Layout.Section>
        </Layout>
      </Page>
    );
  }
}


export default ProductForm;