import React, {Component} from 'react';

import {Page, Button, Layout, Card, DataTable, Banner, Icon, FooterHelp, Link, Pagination} from '@shopify/polaris';
import {EditMajorMonotone,DeleteMajorMonotone, DuplicateMinor} from '@shopify/polaris-icons';

class Profiles extends Component
{
  _isMounted = false;

  state = {
    profiles:{}
  };

  constructor(props){
    super(props);
    this.getProfilesData = this.getProfilesData.bind(this);
    this.confirmDelete = this.confirmDelete.bind(this);
    this.getProfiles = this.getProfiles.bind(this);
  }

  componentWillUnmount(){
    this._isMounted = false;
  }

  getProfiles(pageno=1){
    var queryData = [];
    queryData.push("page=" + pageno);
    queryData.push("shopify_url=" + this.props.store_data.shopify_url);
    queryData.push("api_token=" + this.props.store_data.user.api_token);

    var queryStr = queryData.join("&");

    fetch(this.props.api_url+'/profile?'+queryStr)
    .then(res => res.json())
    .then((data) => {
      console.log(data);
      this.setState({ profiles: data });
     
    })
    .catch(console.log);
  }

  componentDidMount(){
    this._isMounted = true;
    document.title = 'Profiles - ' + document.title;
    this.getProfiles();
  }

  handleSort(){
    console.log("sorting...");
  }

  handleAvailabilityChange(value){
    console.log(value);
  }
  handleProductTypeChange(value){
    console.log(value);
  }
  handleTaggedWithChange(value){
    console.log(value);
  }
  handleFiltersQueryChange(value){
    console.log(value);
  }

  handleQueryValueRemove(value){
    console.log(value);
  }
  handleFiltersClearAll(value){
    console.log(value);
  }

  confirmDelete(profile_id){
    this.setState({error_message:null});
    this.setState({success_message:null});

    var confirm = window.confirm("Are you sure, you want to delete?");
    if(confirm){
      var fetch_url = this.props.api_url+'/profile/'+profile_id+'?shopify_url='+this.props.store_data.shopify_url+'&api_token='+this.props.store_data.user.api_token;
      var requestOptions = {
        method: 'DELETE'
      };
      fetch(fetch_url,requestOptions)
      .then(response => response.json())
      .then((data) => {
        console.log(data);
        if(data && data.status && data.status === "success"){
          if(this._isMounted){
            this.setState({success_message:data.msg});
            this.getProfiles();
          }
        }
        else{
          var error_message = "there was something wrong, please try again.";
          if(data.msg){error_message = data.msg;}
        }
        if(this._isMounted){
          this.setState({error_message:error_message});
        }
      })
      .catch(error => {
        console.error(error);
      });
    }
  }

  duplicateProfile = (profile_id) => {
    this.setState({error_message:null});
    this.setState({success_message:null});
    var confirm = window.confirm("Are you sure, you want to duplicate?");
    if(confirm){
      var fetch_url = this.props.api_url+'/profile/'+profile_id+'/duplicate?shopify_url='+this.props.store_data.shopify_url+'&api_token='+this.props.store_data.user.api_token;
      var requestOptions = {
        method: 'POST'
      };
      fetch(fetch_url,requestOptions)
      .then(response => response.json())
      .then((data) => {
        console.log(data);
        if(data && data.status && data.status === "success"){
          if(this._isMounted){
            this.setState({success_message:data.msg});
            this.getProfiles();
          }
        }
        else{
          var error_message = "there was something wrong, please try again.";
          if(data.msg){error_message = data.msg;}
        }
        if(this._isMounted){
          this.setState({error_message:error_message});
        }
      })
      .catch(error => {
        console.error(error);
        this.setState({error_message:"there was something wrong, please try again"});
      });
    }
  }

  getProfilesData(){
    const rows = [];
    if(this.state.profiles && this.state.profiles.total > 0){
      for(var key in this.state.profiles.data){
        var profile = this.state.profiles.data[key];
        if(profile.is_default_profile === 1){
          rows.push([
            profile.name + " ( default )",
            <div>
              {profile.category_id &&
                <Button url={this.props.base_url + "/profile/"+profile.id+"/attributes"}>Attributes</Button>
              }
            </div>,
            <div>
              <Button url={this.props.base_url + "/profiles/edit/"+profile.id}>
                <Icon source={EditMajorMonotone} />
              </Button>
              &nbsp;&nbsp;
              <Button id={"del_profile_"+profile.id} onClick={this.confirmDelete.bind(this,profile.id)} destructive>
                <Icon source={DeleteMajorMonotone} />
              </Button>

              &nbsp;&nbsp;
              <Button id={"dup_profile_"+profile.id} onClick={this.duplicateProfile.bind(this,profile.id)} primary>
                <Icon source={DuplicateMinor} />
              </Button>
              
            </div>
          ]);
        }
        else{
          rows.push([
            profile.name,
            <div>
              {profile.category_id &&
                <Button url={this.props.base_url + "/profile/"+profile.id+"/attributes"}>Attributes</Button>
              }
            </div>,
            <div>
              <Button url={this.props.base_url + "/profiles/edit/"+profile.id}>
                <Icon source={EditMajorMonotone} />
              </Button>
              &nbsp;&nbsp;
              <Button id={"del_profile_"+profile.id} onClick={this.confirmDelete.bind(this,profile.id)} destructive>
                <Icon source={DeleteMajorMonotone} />
              </Button>
              &nbsp;&nbsp;
              <Button id={"dup_profile_"+profile.id} onClick={this.duplicateProfile.bind(this,profile.id)} primary>
                <Icon source={DuplicateMinor} />
              </Button>
            </div>
          ]);
        }
      }
    }

    var currentPage = 1;
    var hasNext = false;
    var nextPage = 0;
    var hasPrevious = false;
    var previousPage = 0;
    if(this.state.profiles){
      currentPage = this.state.profiles.current_page;
      if(this.state.profiles.next_page_url){
        hasNext = true;
        nextPage = currentPage + 1;
      }
      if(this.state.profiles.prev_page_url){
        hasPrevious = true;
        previousPage = currentPage - 1;
      }      
    }
    

    return (
      <Page fullWidth="true" title="Profiles" primaryAction={{content: 'Add Profile', disabled: false,url:this.props.base_url + '/profiles/new'}}>
        <Card>
          <DataTable
            columnContentTypes={[
              'text',
              'text',
              'text'
            ]}
            headings={[
              'Name',
              '',
              'Action'
            ]}
            rows={rows}
            sortable={[true,false]}
            defaultSortDirection="ascending"
            initialSortColumnIndex={1}
            onSort={this.handleSort}
          />


          {rows && rows.length > 0 &&
          <Card.Section align="center">
            <Pagination
              hasPrevious={hasPrevious}
              previousKeys={[74]}
              previousTooltip={previousPage}
              onPrevious={() => {
                console.log('Previous');
                this.getProfiles(previousPage);
              }}
              hasNext={hasNext}
              nextKeys={[75]}
              nextTooltip={nextPage}
              onNext={() => {
                console.log('Next');
                this.getProfiles(nextPage);
              }}
            />
          </Card.Section>
          }

        </Card>
      </Page>
    );
  }

  render(){
    return(
      <Layout>
        <Layout.Section>
          <Page title="" fullWidth="true">
            {this.state.error_message &&
            <Banner title="Error" status="critical"><p>{this.state.error_message}</p></Banner>
            }
            {this.state.success_message &&
            <Banner title="Success" status="success"><p>{this.state.success_message}</p></Banner>
            }
          </Page>
        </Layout.Section>
        <Layout.Section>
          {this.getProfilesData()}
            
          <FooterHelp>
               For more details on App, visit our {' '}
               <Link url="https://app1.ecomshore.com/profiles_new.pdf" external="true">documentation</Link>.
            </FooterHelp>
        </Layout.Section>
        
      </Layout>
    );
  }
}

export default Profiles;