import React, { Component } from 'react';

import {Button,ChoiceList, Checkbox, Card, Form, FormLayout, Layout, Page, Stack, TextField, Select, FooterHelp, Link, Toast, Tabs} from '@shopify/polaris';

import AutoCompleteField from './AutoCompleteField';

class ReturnPolicyForm extends Component{
  _isMounted = false;

  state = {
    name: "Ebay Return Profile",
    domestic_returns_accepted: "ReturnsAccepted",
    domestic_returned_within: "Days_30",
    domestic_returns_paid_by: "Buyer",
    domestic_refund_given_as:"MoneyBack",
    international_returns_accepted:"ReturnsNotAccepted",
    international_returned_within:"Days_30",
    international_returns_paid_by:"Buyer",
    international_refund_given_as:"MoneyBack",
    selected_tab:0,
    fields_type:'required'
  };

  errors_data = {};
  
  ebay_profile = {};

  yes_no_options = [
    {label:"Select a Option",value:""},
    {value:"1",label:'Yes'},
    {value:"0",label:'No'}
  ];

  returns_accepted_options = [
    {label:"Select a Option",value:""},
    {value:"ReturnsAccepted",label:'Returns Accepted'},
    {value:"ReturnsNotAccepted",label:'Returns Not Accepted'}
  ];

  returned_within_options = [
    {label:"Select a Option",value:""},
    {value:"Days_30",label:'30 Days'},
    {value:"Days_60",label:'60 Days'}
  ];

  returns_paid_by_options = [
    {label:"Select a Option",value:""},
    {value:"Buyer",label:'Buyer'},
    {value:"Seller",label:'Seller'}
  ];

  refund_given_as_options = [
    {label:"Select a Option",value:""},
    {value:"MoneyBack",label:'Money Back'},
    {value:"MoneyBackOrReplacement",label:'Money Back or Replacement'}
  ];


  tabs = [
    {
      id: 'required',
      content: 'Required Fields',
      accessibilityLabel: 'Required Fields',
      panelID: 'required-fields',
    }
  ];

  constructor(props){
    super(props);
    this.handleChange = this.handleChange.bind(this);
    this.addProfile = this.addProfile.bind(this);
    this.hideToast = this.hideToast.bind(this);
   
    this.searchOptions = this.searchOptions.bind(this);
    
  }

  componentWillUnmount(){
    this._isMounted = false;
  }

  componentDidMount(){
    this._isMounted = true;

    this.ebay_profile = this.props.store_data.ebay_profile || {};

    

    fetch(this.props.api_url+'/ebayspecificdata'+'?shopify_url='+this.props.store_data.shopify_url+'&api_token='+this.props.store_data.user.api_token)
    .then(res => res.json())
    .then((data) => {
      if(data){
      }
    })
    .catch(console.log);

    this.setState({page_title: "New Return Profile",sub_title: "Add Ebay Return Profile",sub_description: "Enter profile data and click on Save."});
  }

  async searchOptions(query){
    query = query.toLowerCase();
    let ebay_category_options = [];
    try{
      if(this.state.ebay_categories && this.state.ebay_categories.length > 0){
        let ebay_categories = this.state.ebay_categories.filter((category) => {
          var category_tree_name = category.category_tree_name.toLowerCase();
          return category_tree_name.includes(query);
        });
        console.log(ebay_categories);
        if(ebay_categories.length > 0){
          for(var ckey in ebay_categories){
            ebay_category_options.push({label: ebay_categories[ckey].category_tree_name, value: (ebay_categories[ckey].id).toString()});
          }
        }
      }
    }
    catch(e){
      console.log(e);
    }
    return ebay_category_options;
  }

  handleTabChange = (value) => {
    let tab = this.tabs[value];
    this.setState(() => { return {fields_type:tab.id,selected_tab:value} });
  };

  addProfile(){    
    var hasError = false;
    this.errors_data = {};
    if(this.state.name.length <= 0){
      hasError = true;
      this.errors_data.name_error = "name is required";
    }
    
    // if(this.state.payment_methods.length <= 0){
    //   hasError = true;
    //   this.errors_data.payment_methods_error = "payment method is required";
    // }

    if(hasError === false){
      this.setState({button_loading:true});
      
      var request_data = {
        name: this.state.name,
        domestic_returns_accepted: this.state.domestic_returns_accepted,
        domestic_returned_within: this.state.domestic_returned_within,
        domestic_returns_paid_by: this.state.domestic_returns_paid_by,
        domestic_refund_given_as: this.state.domestic_refund_given_as,
        international_returns_accepted: this.state.international_returns_accepted,
        international_returned_within: this.state.international_returned_within,
        international_returns_paid_by: this.state.international_returns_paid_by,
        international_refund_given_as: this.state.international_refund_given_as,
        return_policy_details: this.state.return_policy_details,
        shopify_url:this.props.store_data.shopify_url,
        profile_type: "RETURN_POLICY"
      };
      


      var requestOptions = {
        method: 'POST',
        headers: {'Content-Type': 'application/json'},
        body: JSON.stringify(request_data)
      };
      var fetch_url = this.props.api_url+'/policies?api_token='+this.props.store_data.user.api_token;
      fetch(fetch_url,requestOptions)
      .then(response => response.json())
      .then((data) => {
        if(data && data.status && data.status === "success"){
          this.setState(() => { return {button_loading:false,success_message:data.msg}; });
        }
        else{
          var error_message = "there was something wrong, please try again.";
          if(data && data.status && data.status === "error"){
            if(data.errors){
              for(var key in data.errors){
                error_message += key + " : ";
                for(var fkey in data.errors[key]){error_message += data.errors[key][fkey] + "\n";}
                error_message += "\n";
              }
            }
            else if(data.msg){error_message = data.msg;}
          }
        }
        this.setState(() => { return {button_loading:false,error_message:error_message}; } );
      })
      .catch(error => {
        console.error(error);
      });
    }
    else{
      this.setState({button_loading:false});
    }
  }

  hideToast(){
    this.setState({success_message: null,error_message: null});
  }

  handleChange = (field) => {
    return (value) => {
      console.log(value);
      this.setState(() => { return { [field]: value.toString() } });
    }
  };

  handleChoiceListChange = (field) => {
    return (value) => {
      this.setState({ [field]: value });
    }
  };

  render(){
    return (
      <Page title={this.state.page_title}>

        {this.state.success_message &&
          <Toast content={this.state.success_message} onDismiss={this.hideToast} duration="6000" />
        }
        {this.state.error_message &&
          <Toast content={this.state.error_message} error onDismiss={this.hideToast} duration="6000" />
        }

        <Layout>
          <Layout.AnnotatedSection title={this.state.sub_title} description={this.state.sub_description}>
            <Card sectioned>
              <Form onSubmit={this.addProfile} method="post" encType="multipart/form-data" preventDefault="true">

                <Tabs tabs={this.tabs} selected={this.state.selected_tab} onSelect={this.handleTabChange}>

                  {this.state.fields_type === "required" &&

                  <FormLayout>

                    <TextField type="text" label="Profile Name" error={this.errors_data.name_error} value={this.state.name} onChange={this.handleChange('name')} />

                    <Select label="Domestic Returns Accepted" options={this.returns_accepted_options} error={this.errors_data.domestic_returns_accepted_error} onChange={this.handleChange('domestic_returns_accepted')} value={this.state.domestic_returns_accepted} />
                      
                    {this.state.domestic_returns_accepted === "ReturnsAccepted" &&
                    <Select label="Item must be returned within" options={this.returned_within_options} error={this.errors_data.domestic_returned_within_error} onChange={this.handleChange('domestic_returned_within')} value={this.state.domestic_returned_within} />
                    }

                    {this.state.domestic_returns_accepted === "ReturnsAccepted" &&
                    <Select label="Return shipping paid by" options={this.returns_paid_by_options} error={this.errors_data.domestic_returns_paid_by_error} onChange={this.handleChange('domestic_returns_paid_by')} value={this.state.domestic_returns_paid_by} />
                    }

                    {this.state.domestic_returns_accepted === "ReturnsAccepted" &&
                    <Select label="Refund given as" options={this.refund_given_as_options} error={this.errors_data.domestic_refund_given_as_error} onChange={this.handleChange('domestic_refund_given_as')} value={this.state.domestic_refund_given_as} />
                    }

                    <Select label="International Returns Accepted" options={this.returns_accepted_options} error={this.errors_data.international_returns_accepted_error} onChange={this.handleChange('international_returns_accepted')} value={this.state.international_returns_accepted} />
                    
                    {this.state.international_returns_accepted === "ReturnsAccepted" &&
                    <Select label="Item must be returned within" options={this.returned_within_options} error={this.errors_data.international_returned_within_error} onChange={this.handleChange('international_returned_within')} value={this.state.international_returned_within} />
                    }

                    {this.state.international_returns_accepted === "ReturnsAccepted" &&
                    <Select label="Return shipping paid by" options={this.returns_paid_by_options} error={this.errors_data.international_returns_paid_by_error} onChange={this.handleChange('international_returns_paid_by')} value={this.state.international_returns_paid_by} />
                    }

                    {this.state.international_returns_accepted === "ReturnsAccepted" &&
                    <Select label="Refund given as" options={this.refund_given_as_options} error={this.errors_data.international_refund_given_as_error} onChange={this.handleChange('international_refund_given_as')} value={this.state.international_refund_given_as} />
                    }

                    {(this.state.domestic_returns_accepted === "ReturnsAccepted" || this.state.international_returns_accepted === "ReturnsAccepted" ) &&
                    <TextField type="text" label="Return Policy Details" multiline={2} error={this.errors_data.return_policy_details_error} value={this.state.return_policy_details} onChange={this.handleChange('return_policy_details')} />
                    }
                    
                  </FormLayout>

                  }
                  
                </Tabs>

                <FormLayout>
                  <Stack distribution="trailing">
                    <Button primary submit loading={this.state.button_loading}>Save</Button>
                  </Stack>
                </FormLayout>
              </Form>
            </Card>
          </Layout.AnnotatedSection>
          <Layout.Section>
            
          </Layout.Section>
        </Layout>
      </Page>
    );
  }
}


export default ReturnPolicyForm;