import React, { useCallback, useContext, useState } from "react";

import {
  Button,
  ProgressBar,
  Card,
  Toast,
  Form,
  FormLayout,
  Layout,
  Page,
  Stack,
  TextField,
  Select,
  FooterHelp,
  Link,
  Checkbox,
  Banner,
} from "@shopify/polaris";

import Setup3 from '../components/Setup3';

function Setup2(props) {
  const [shopify_url, setShopify_url] = useState(props.store_data.shopify_url);
  const [error_message, setError_message] = useState(null);
  const [error_message2, setError_message2] = useState(null);
  const [error_message3, setError_message3] = useState(null);
  const [buttonloading, setButtonloading] = useState(false);
  const [buttonloading2, setButtonloading2] = useState(false);
  const [buttonName, setButtonName] = useState("Connect");
  const [name, setName] = useState("Ebay");
  const [postalcode, setPostalcode] = useState("");
  const [siteid, setSiteid] = useState("0");
  const [contry, setContry] = useState("Australia");
  const [listingformat, setListingformat] = useState("fixed_price");
  const [fixedListing, setFixedListing] = useState("Days_14");
  const [auctionListing, setAuctionListing] = useState("Days_1");
  const [location, setLocation] = useState("");
  const [connected, setConnected] = useState(false);
  const [submitProductSuccMsg, setSubmitProductSuccMsg] = useState(null);
  const [submitProductSuccMsg2, setSubmitProductSuccMsg2] = useState(null);
  const [errors_data, setErrors_data] = useState({});

  const [profileData, setProfileData] = useState({});
  const [selectedTab, setSelectedTab] = useState(0);
  const [profileId, setProfileID] = useState("");
  const [profilename, setProfilename] = useState("");
  
  const ebaySiteList = [
    { value: "0", label: "eBay United States" },
    { value: "2", label: "eBay Canada (English)" },
    { value: "3", label: "eBay UK" },
    { value: "15", label: "eBay Australia" },
    { value: "16", label: "eBay Austria" },
    { value: "23", label: "eBay Belgium (French)" },
    { value: "71", label: "eBay France" },
    { value: "77", label: "eBay Germany" },
    { value: "100", label: "eBay Motors" },
    { value: "101", label: "eBay Italy" },
    { value: "123", label: "eBay Belgium (Dutch)" },
    { value: "146", label: "eBay Netherlands" },
    { value: "186", label: "eBay Spain" },
    { value: "193", label: "eBay Switzerland" },
    { value: "201", label: "eBay Hong Kong" },
    { value: "203", label: "eBay India" },
    { value: "205", label: "eBay Ireland" },
    { value: "207", label: "eBay Malaysia" },
    { value: "210", label: "eBay Canada (French)" },
    { value: "211", label: "eBay Philippines" },
    { value: "212", label: "eBay Poland" },
    { value: "216", label: "eBay Singapore" },
  ];

  const listingFormats = [
    { value: "fixed_price", label: "Fixed Price" },
    { value: "auction", label: "Auction" },
  ];
  const fixedListingDuration = [
    { value: "Days_14", label: "Days_14" },
    { value: "Days_21", label: "Days_21" },
    { value: "Days_30", label: "Days_30" },
    { value: "Days_60", label: "Days_60" },
    { value: "Days_90", label: "Days_90" },
    { value: "Days_120", label: "Days_120" },
    { value: "GTC", label: "GTC" },
  ];
  const auctionListingDuration = [
    { value: "Days_1", label: "Days_1" },
    { value: "Days_3", label: "Days_3" },
    { value: "Days_5", label: "Days_5" },
    { value: "Days_7", label: "Days_7" },
    { value: "Days_10", label: "Days_10" },
  ];

  const country = [
    { value: "Australia", label: "Australia" },
    { value: "Austria", label: "Austria" },
    { value: "Belgium", label: "Belgium" },
    { value: "Canada", label: "Canada" },
    { value: "France", label: "France" },
    { value: "Germany", label: "Germany" },
    { value: "India", label: "India" },
    { value: "Ireland", label: "Ireland" },
    { value: "Italy", label: "Italy" },
    { value: "Malaysia", label: "Malaysia" },
    { value: "Netherlands", label: "Netherlands" },
    { value: "Philippines", label: "Philippines" },
    { value: "Poland", label: "Poland" },
    { value: "Singapore", label: "Singapore" },
    { value: "Spain", label: "Spain" },
    { value: "Switzerland", label: "Switzerland" },
    { value: "UK", label: "UK" },
    { value: "United States", label: "United States" },
  ];

  const addEbayAccount = () => {
    if (buttonName == "Connected") {
      setSubmitProductSuccMsg2("Ebay Account Already connected");

      setTimeout(() => {
        setSubmitProductSuccMsg2(null);
      }, 1000);
      return;
    }

    setButtonloading(true);
    setError_message(null);

    var hasError = false;

    if (name.length <= 0) {
      hasError = true;
      setError_message("name is required");
      setButtonloading(false);
    }

    if (hasError === false) {
      var request_data = {
        name: name,
        siteid: siteid,
        update_install_step: false,
        shopify_url: props.store_data.shopify_url,
      };

      const requestOptions = {
        method: "POST",
        headers: { "Content-Type": "application/json" },
        body: JSON.stringify(request_data),
      };
      fetch(
        props.api_url +
        "/ebay_account?api_token=" +
        props.store_data.user.api_token,
        requestOptions
      )
        .then((response) => response.json())
        .then((data) => {
          if (data && data.status && data.status === "success") {
           
            //window.location.href = data.install_link;
            //return null;

            //props.updateInstallStep(3);
            setConnected(true);
            setButtonloading(false);
            setButtonName("Connected");
            setSubmitProductSuccMsg2(
              "Ebay Account successfully connected"
            );

            setTimeout(() => {
              setSubmitProductSuccMsg2(null);
            }, 1000);
          } else {
            var error_message =
              "there was something wrong, please try again.";
            if (data && data.status && data.status === "error") {
              if (data.errors) {
                for (var key in data.errors) {
                  error_message += key + " : ";
                  for (var fkey in data.errors[key]) {
                    error_message +=
                      data.errors[key][fkey] + "\n";
                  }
                  error_message += "\n";
                }
              } else if (data.msg) {
                error_message = data.msg;
              }
            }
          }

        })
        .catch((error) => {
          console.error(error);
        });
    } else {
      //   this.setState({
      //     button_loading:false
      //   });
    }
  };

  const addlocation = async () => {
    setButtonloading2(true);
    setError_message2(null);
    setError_message3(null);
    var hasError = false;

    if (postalcode.length <= 0) {
       // console.log(buttonName);
        if (buttonName == "Connect") {
            setSubmitProductSuccMsg("Please connect ebay account first");
            setTimeout(() => {
                setSubmitProductSuccMsg(null);
            }, 1000);
            setButtonloading2(false);
            return;
        } else {
            // alert('error');
            hasError = true;
            setSubmitProductSuccMsg("Please enter Postal code");
            setError_message2("Postal code is required");
            setError_message3("Location is required");
            setButtonloading2(false);
            return;
        }
    }
    if(location.length == 0){
      hasError = true;
      setSubmitProductSuccMsg("Please Enter Location")
      setError_message3("Location code is required");
      setButtonloading2(false)
      return
    }

    // alert(3);
    const formData = {
        name: name,
        contry: contry,
        postal_code: postalcode,
        item_location: location,
        listing_format: listingformat,
        listing_duration: fixedListing,
        update_install_step: false,
        shopify_url: shopify_url,
    };

    try {
        const fetch_url = `${props.api_url}/profile?api_token=${props.store_data.user.api_token}`;
        const response = await fetch(fetch_url, {
            method: "POST",
            headers: { "Content-Type": "application/json" },
            body: JSON.stringify(formData),
        });

        if (!response.ok) {
            const errorData = await response.json();
            if (errorData.errors) {
                const fieldErrors = {};
                Object.keys(errorData.errors).forEach((field) => {
                    fieldErrors[field] = errorData.errors[field][0];
                });
                // setErrors(fieldErrors);
                return;
            } else {
                throw new Error("Failed to save profile data");
            }
        }

        const data = await response.json();
        //console.log('aaaaaaaaaaaaaaaaaaaaaa', data.msg);
        const profileId = data.profile.id;
        const profilename = data.profile.name;
        localStorage.setItem('profileID', profileId);
        localStorage.setItem('profileName', profilename);
        // alert('Profile saved to local storage');
    } catch (error) {
        console.error('Error:', error);
        // setSuccessMessage(error.message);
    }

    props.updateInstallStep(3);
};

  
  const hideToast = () => {
    setSubmitProductSuccMsg(null);
    setSubmitProductSuccMsg2(null);
  };

  const handleNameChange = useCallback((value) => setName(value), []);

  const handleSelectChange = useCallback((value) => setSiteid(value), []);

  const handleCountryChange = useCallback((value) => setContry(value), []);

  const handleListinformatChange = useCallback(
    (value) => setListingformat(value),
    []
  );

  const handleFixedlisting = useCallback(
    (value) => setFixedListing(value),
    []
  );

  const handleAuctionListing = useCallback(
    (value) => setAuctionListing(value),
    []
  );

  const handleCodeChange = useCallback((value) => setPostalcode(value), []);

  const handleLocationChange = useCallback((value) => setLocation(value), []);

  return (
    <div>
      <>
        {submitProductSuccMsg && (
          <Toast
            error
            content={submitProductSuccMsg}
            onDismiss={hideToast}
            duration="2000"
          />
        )}

        {submitProductSuccMsg2 && (
          <Toast
            content={submitProductSuccMsg2}
            onDismiss={hideToast}
            duration="2000"
          />
        )}

        <ProgressBar progress={33} />

        <h1 style={{ margin: "0px 0px 30px 0px", fontSize: "13px" }}>
          App Setup - Step 2 of 3
        </h1>
        <div style={{ margin: "0px 0px 30px 0px" }}>
          <h3 style={{ fontWeight: "bolder", fontSize: "15px" }}>
            connect eBay account
          </h3>
          <p>
            Connect your eBay seller account to effortlessly manage
            products and orders through the app.Once onboarded ,you
            can seamlessly link additional eBay account to your
            shopify store using this integration.
          </p>
        </div>
        <div style={{ marginBottom: "20px" }}>
          <Banner title="Important notice" status="info">
            <p>
              Sellers in the united states looking to sell on eBay
              Motors must link their eBay Motors account, while
              our international partners are encouraged to link
              their accounts through their respective
              country-specific websites for a seamless experience.
            </p>
          </Banner>
        </div>

        <Form
          onSubmit={addEbayAccount}
          method="post"
          encType="multipart/form-data"
          preventDefault="true"
        >
          <FormLayout>
            <FormLayout.Group>
              <TextField
                type="text"
                label="Store name"
                error={error_message}
                value={name}
                onChange={handleNameChange}
              />

              <Select
                label="Ebay Site"
                options={ebaySiteList}
                error={errors_data.siteid_error}
                value={siteid}
                onChange={handleSelectChange}
              />
            </FormLayout.Group>
            <Stack distribution="trailing">
              <Button primary submit loading={buttonloading}>
                {buttonName}
              </Button>
            </Stack>
          </FormLayout>
        </Form>

      </>

      <div style={{ marginTop: "40px" }}>
        <Form
          onSubmit={addlocation}
          method="post"
          encType="multipart/form-data"
          preventDefault="true"
        >
          <FormLayout>
            <h1
              style={{
                fontWeight: "bold",
                fontSize: "15px",
                margin: "50px 0px 5px",
              }}
            >
              Item Location
            </h1>

            <FormLayout.Group>
              <Select
                label="Country"
                options={country}
                value={contry}
                onChange={handleCountryChange}
              />

              <TextField
                type="text"
                label="Postal code"
                error={error_message2}
                value={postalcode}
                onChange={handleCodeChange}
              />
            </FormLayout.Group>
            <TextField
              type="text"
              label="Location"
              error={error_message3}
              value={location}
              onChange={handleLocationChange}
            />

            <h1
              style={{
                fontWeight: "bold",
                fontSize: "15px",
                margin: "40px 0px 5px",
              }}
            >
              Listing Type
            </h1>

            <FormLayout.Group>
              <Select
                label="Listing Format"
                options={listingFormats}
                value={listingformat}
                onChange={handleListinformatChange}
              />

              {listingformat == "fixed_price" ? (
                <Select
                  label="Listing Duration"
                  options={fixedListingDuration}
                  value={fixedListing}
                  onChange={handleFixedlisting}
                />
              ) : (
                <Select
                  label="Listing Duration"
                  options={auctionListingDuration}
                  value={auctionListing}
                  onChange={handleAuctionListing}
                />
              )}
            </FormLayout.Group>
            <Stack distribution="trailing">
              <Button primary submit loading={buttonloading2}>
                Next
              </Button>
            </Stack>
          </FormLayout>
        </Form>

      </div>

     
    </div>
  );
}

export default Setup2;
