import React, { Component } from 'react';

import {Button,ChoiceList, Card, Form, FormLayout, Layout, Page, Stack, TextField, Select, FooterHelp, Link, Toast, Tabs} from '@shopify/polaris';

import AutoCompleteField from './AutoCompleteField';

import { Editor } from '@tinymce/tinymce-react';

class TemplateForm extends Component{
  _isMounted = false;

  state = {
    name: "Template",
    template_data: "",
    selected_tab:0,
    fields_type:'required',
    editorRef:{}
  };

  errors_data = {};

  tabs = [
    {
      id: 'required',
      content: 'Template Data',
      accessibilityLabel: 'Template',
      panelID: 'required-fields',
    }
  ];

  constructor(props){
    super(props);
    this.handleChange = this.handleChange.bind(this);
    this.addTemplate = this.addTemplate.bind(this);
    this.hideToast = this.hideToast.bind(this);    
  }

  componentWillUnmount(){
    this._isMounted = false;
  }

  componentDidMount(){
    this._isMounted = true;

    this.ebay_account = this.props.store_data.ebay_account || {};

    if(this.props.form_type === "edit_template"){
      this.setState({page_title: "Update Template",sub_title: "Edit Template",sub_description: "Enter Template data and click on Save."});
      fetch(this.props.api_url+'/template/'+this.props.template_id+'?shopify_url='+this.props.store_data.shopify_url+'&api_token='+this.props.store_data.user.api_token)
      .then(res => res.json())
      .then((data) => {
        if(data && data.id){
          this.setState(() => {
            return {
              name:data.name,
              template_data:data.template_data
            };
          });
        }
      })
      .catch(console.log);
    }
    else{
      this.setState({page_title: "New Template",sub_title: "Add Template",sub_description: "Enter Template data and click on Save."});
    }
  }

  
  handleTabChange = (value) => {
    let tab = this.tabs[value];
    this.setState(() => { return {fields_type:tab.id,selected_tab:value} });
  };

  addTemplate(){    
    var hasError = false;
    this.errors_data = {};
    if(this.state.name.length <= 0){
      hasError = true;
      this.errors_data.name_error = "name is required";
    }

    var template_data = null;
    if(this.state.editorRef && this.state.editorRef.current){
      template_data = this.state.editorRef.current.getContent();
    }    
    
    // if(template_data.length <= 0){
    //   hasError = true;
    //   this.errors_data.template_data_error = "template data is required";
    // }
    // else if(template_data.indexOf("{{description}}") === -1){
    //   hasError = true;
    //   this.errors_data.template_data_error = 'template data must contain the string : "{{description}}"';
    // }

   
    if(hasError === false){
      this.setState(() => { return {button_loading:true,template_data,template_data}; });

      //var request_data = this.state;
            
      var request_data = {
        name: this.state.name,
        template_data:template_data,
        shopify_url:this.props.store_data.shopify_url
      };
      

      if(this.props.form_type === "edit_template"){
        request_data["template_id"] = this.props.template_id;
      }

      var requestOptions = {
        method: 'POST',
        headers: {'Content-Type': 'application/json'},
        body: JSON.stringify(request_data)
      };
      var fetch_url = this.props.api_url+'/templates?api_token='+this.props.store_data.user.api_token;
      if(this.props.form_type === "edit_template"){
        fetch_url = this.props.api_url+'/template/'+this.props.template_id+'?api_token='+this.props.store_data.user.api_token;
        requestOptions = {
          method: 'PUT',
          headers: {'Content-Type': 'application/json'},
          body: JSON.stringify(request_data)
        };
      }

      fetch(fetch_url,requestOptions)
      .then(response => response.json())
      .then((data) => {
        if(data && data.status && data.status === "success"){
          this.setState(() => {
            return {
              button_loading:false,
              success_message:data.msg
            };
          });
        }
        else{
          var error_message = "there was something wrong, please try again.";
          if(data && data.status && data.status === "error"){
            if(data.errors){
              for(var key in data.errors){
                error_message += key + " : ";
                for(var fkey in data.errors[key]){error_message += data.errors[key][fkey] + "\n";}
                error_message += "\n";
              }
            }
            else if(data.msg){error_message = data.msg;}
          }
        }

        this.setState(() => {
          return {button_loading:false,error_message:error_message};
        });
      })
      .catch(error => {
        console.error(error);
      });
    }
    else{
      this.setState(() => { return {button_loading:false}; });
    }
  }

  hideToast(){
    this.setState(() => { return {success_message: null,error_message: null}; });
  }

  handleChange = (field) => {
    return (value) => {
      this.setState(() => { return { [field]: value.toString() } });
    }
  };
  
  render(){
    return (
      <Page title={this.state.page_title}>

        {this.state.success_message &&
          <Toast content={this.state.success_message} onDismiss={this.hideToast} duration="6000" />
        }
        {this.state.error_message &&
          <Toast content={this.state.error_message} error onDismiss={this.hideToast} duration="6000" />
        }

        <Layout>
          <Layout.Section title={this.state.sub_title} description={this.state.sub_description}>
            <Card sectioned>
              <Form onSubmit={this.addTemplate} method="post" encType="multipart/form-data" preventDefault="true">

                <Tabs tabs={this.tabs} selected={this.state.selected_tab} onSelect={this.handleTabChange}>

                  {this.state.fields_type === "required" &&

                  <FormLayout>

                    <TextField type="text" label="Template Name" error={this.errors_data.name_error} value={this.state.name} onChange={this.handleChange('name')} />
                    
                    <Editor
                      onInit={(evt, editor) => this.state.editorRef.current = editor}
                      initialValue={this.state.template_data}
                      apiKey='eut5y3ol7jipclgc718s9kdsf9bjwvg0lucso9kd8xhtp4pw'
                      init={{
                        height: 400,
                        menubar: false,
                        plugins: [
                          'advlist autolink lists link image charmap print preview anchor',
                          'searchreplace visualblocks code fullscreen',
                          'insertdatetime media table paste code help wordcount'
                        ],
                        toolbar: 'undo redo | formatselect | ' +
                        'bold italic backcolor | alignleft aligncenter ' +
                        'alignright alignjustify | bullist numlist outdent indent | ' +
                        'removeformat | table | media | image | code | help',
                        content_style: 'body { font-family:Helvetica,Arial,sans-serif; font-size:14px }'
                      }}
                    />
                    <p>{`Add {{description}} were you want to add shopify description`}</p>
                    <p style={ {color:"red"} }>{this.errors_data.template_data_error}</p>
                  
                  </FormLayout>

                  }

                </Tabs>

                <FormLayout>
                  <Stack distribution="trailing">
                    <Button primary submit loading={this.state.button_loading}>Save</Button>
                  </Stack>
                </FormLayout>
              </Form>
            </Card>
          </Layout.Section>
          <Layout.Section>
            
          </Layout.Section>
        </Layout>
      </Page>
    );
  }
}


export default TemplateForm;