import React, {Component} from 'react';

import {Page, Button, Layout, Card, DataTable, Banner, Icon, EmptyState} from '@shopify/polaris';
import {EditMajorMonotone,DeleteMajorMonotone} from '@shopify/polaris-icons';

class Templates extends Component
{
  _isMounted = false;

  state = {
    templates:{}
  };

  constructor(props){
    super(props);
    this.getTemplatesData = this.getTemplatesData.bind(this);
    this.confirmDelete = this.confirmDelete.bind(this);
    this.getTemplates = this.getTemplates.bind(this);
  }

  componentWillUnmount(){
    this._isMounted = false;
  }

  getTemplates(){
    fetch(this.props.api_url+'/templates?shopify_url='+this.props.store_data.shopify_url+'&api_token='+this.props.store_data.user.api_token)
    .then(res => res.json())
    .then((data) => {
      this.setState(() => { return { templates: data }; });
    })
    .catch(console.log);
  }

  componentDidMount(){
    this._isMounted = true;
    document.title = 'Templates - ' + document.title;
    this.getTemplates();
  }

  handleSort(){
    console.log("sorting...");
  }

  handleAvailabilityChange(value){
    console.log(value);
  }
  handleProductTypeChange(value){
    console.log(value);
  }
  handleTaggedWithChange(value){
    console.log(value);
  }
  handleFiltersQueryChange(value){
    console.log(value);
  }

  handleQueryValueRemove(value){
    console.log(value);
  }
  handleFiltersClearAll(value){
    console.log(value);
  }

  confirmDelete(template_id){
    this.setState({error_message:null});
    this.setState({success_message:null});

    var confirm = window.confirm("Are you sure, you want to delete?");
    if(confirm){
      var fetch_url = this.props.api_url+'/template/'+template_id+'?shopify_url='+this.props.store_data.shopify_url+'&api_token='+this.props.store_data.user.api_token;
      var requestOptions = {
        method: 'DELETE'
      };
      fetch(fetch_url,requestOptions)
      .then(response => response.json())
      .then((data) => {
        console.log(data);
        if(data && data.status && data.status === "success"){
          if(this._isMounted){
            this.setState({success_message:data.msg});
            this.getTemplates();
          }
        }
        else{
          var error_message = "there was something wrong, please try again.";
          if(data.msg){error_message = data.msg;}
        }
        if(this._isMounted){
          this.setState({error_message:error_message});
        }
      })
      .catch(error => {
        console.error(error);
      });
    }
  }

  getTemplatesData(){
    const rows = [];
    if(this.state.templates && this.state.templates.total > 0){
      for(var key in this.state.templates.data){
        var template = this.state.templates.data[key];
        rows.push([
          template.name,
          <div>
            <Button url={this.props.base_url + "/templates/edit/"+template.id}>
              <Icon source={EditMajorMonotone} />
            </Button>
            &nbsp;&nbsp;
            <Button id={"del_template_"+template.id} onClick={this.confirmDelete.bind(this,template.id)} destructive>
              <Icon source={DeleteMajorMonotone} />
            </Button>
          </div>
        ]);
      }
    }
    return (
        <>

        <Page fullWidth="true" title="Templates" primaryAction={{content: 'Add Template', disabled: false,url:this.props.base_url + '/templates/new'}}>
        
            <Card>
                {this.state.templates && this.state.templates.total > 0 && (
                <DataTable
                    columnContentTypes={[
                    'text',
                    'text'
                    ]}
                    headings={[
                    'Name',
                    'Action'
                    ]}
                    rows={rows}
                    sortable={[true,false]}
                    defaultSortDirection="ascending"
                    initialSortColumnIndex={1}
                    onSort={this.handleSort}
                />
                )}

                {this.state.templates && this.state.templates.total <= 0 && (
                <>
                <Card.Section>
					<EmptyState heading="" image="https://cdn.shopify.com/s/files/1/0262/4071/2726/files/emptystate-files.png">
						<p>
							No Template Found , Please Add Template .
						</p>
					</EmptyState>
				</Card.Section>
                </>
                )}


            </Card>
        </Page>

        </>
      
    );
  }
  render(){
    return(
      <Layout>
        <Layout.Section>
          <Page title="" fullWidth="true">
            {this.state.error_message &&
            <Banner title="Error" status="critical"><p>{this.state.error_message}</p></Banner>
            }
            {this.state.success_message &&
            <Banner title="Success" status="success"><p>{this.state.success_message}</p></Banner>
            }
          </Page>
        </Layout.Section>
        <Layout.Section>
          {this.getTemplatesData()}
        </Layout.Section>
      </Layout>
    );
  }
}

export default Templates;