<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Nicolaslopezj\Searchable\SearchableTrait;

class Order extends Model
{
	protected $table = 'orders';
	protected $connection = 'tenants';

	public function store(){
		return $this->belongsTo('App\ShopifyStore','store_id','id');
	}

	public function linkedOrder(){
		return $this->belongsTo('App\Order','linked_order_id','order_id');
	}

	public function account(){
		return $this->belongsTo('App\AmazonAccount','account_id','id');
	}

  	public function user(){
		return $this->belongsTo('App\User','user_id','id');
	}

	protected $fillable = [
		'order_id','linked_order_id','order_date_str','order_date','status','items','order_data','order_sync','inventory_sync','shipment_sync','cancel_sync','data_removed','type','source','account_id','store_id','user_id'
  	];
}
