<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreatePendingProductPublishTable extends Migration
{
    public function up(){
        Schema::create('pending_product_publish',function(Blueprint $table){
            $table->bigIncrements('id');
            $table->unsignedBigInteger('product_id');
            $table->unsignedInteger('profile_id');
            $table->tinyInteger('processing')->nullable()->default(NULL);
            $table->unsignedInteger('account_id');
            $table->foreign('account_id')->references('id')->on('ebay_accounts')->onDelete('cascade');
            $table->unsignedBigInteger('store_id');
            $table->foreign('store_id')->references('id')->on('shopify_stores')->onDelete('cascade');
            $table->unsignedBigInteger('user_id');
            $table->foreign('user_id')->references('id')->on('users')->onDelete('cascade');
            $table->timestamps();
        });
    }
    
    public function down(){
        Schema::dropIfExists('pending_product_publish');
    }
}
