<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Schema;

class CreateProfilesTable extends Migration
{
    public function up()
    {
        if(!Schema::connection('tenants')->hasTable('profiles')){
            Schema::connection('tenants')->create('profiles',function(Blueprint $table){
                $table->increments('id');
                $table->string('name');
                $table->boolean('trim_title')->nullable()->default(NULL);
                $table->tinyInteger('is_default_profile')->nullable()->default(NULL);
                $table->string('listing_title',255)->nullable()->default(NULL);
                $table->string('product_id_type',50)->nullable()->default('UPC');
                $table->string('item_condition',100)->nullable()->default(NULL);
                $table->string('ebay_category_1',255)->nullable()->default(NULL);
                $table->string('ebay_category_2',255)->nullable()->default(NULL);
                $table->string('store_category',255)->nullable()->default(NULL);
                $table->enum('listing_format',['fixed_price','auction'])->default('fixed_price');
                $table->string('listing_duration',100)->nullable()->default(NULL);
                $table->string('item_location',255)->nullable()->default(NULL);
                $table->string('paypal_email',255)->nullable()->default(NULL);
                $table->boolean('immediate_payment')->nullable()->default(NULL);
                $table->string('payment_methods',255)->nullable()->default(NULL);
                $table->text('payment_instructions')->nullable()->default(NULL);
                $table->string('sales_tax_region',255)->nullable()->default(NULL);
                $table->float('sales_tax_rate')->nullable()->default(NULL);
                $table->boolean('apply_tax_to_shipping')->nullable()->default(NULL);
                $table->enum('domestic_returns_accepted',['ReturnsAccepted','ReturnsNotAccepted'])->nullable()->default('ReturnsAccepted');
                $table->enum('domestic_returned_within',['Days_30','Days_60'])->nullable()->default('Days_30');
                $table->enum('domestic_returns_paid_by',['Buyer','Seller'])->nullable()->default('Buyer');
                $table->enum('domestic_refund_given_as',['MoneyBack','MoneyBackOrReplacement'])->nullable()->default('MoneyBack');
                $table->enum('international_returns_accepted',['ReturnsAccepted','ReturnsNotAccepted'])->nullable()->default('ReturnsNotAccepted');
                $table->enum('international_returned_within',['Days_30','Days_60'])->nullable()->default('Days_30');
                $table->enum('international_returns_paid_by',['Buyer','Seller'])->nullable()->default('Buyer');
                $table->enum('international_refund_given_as',['MoneyBack','MoneyBackOrReplacement'])->nullable()->default('MoneyBack');
                $table->text('return_policy_details')->nullable()->default(NULL);
                $table->longText('item_specifics')->nullable()->default(NULL);
                $table->longText('item_specifics2')->nullable()->default(NULL);
                $table->string('domestic_shipping',255)->nullable()->default('NotSpecified');
                $table->string('domestic_ship_service1',255)->nullable()->default(NULL);
                $table->float('ship_fee1')->nullable()->default(0);
                $table->float('x_ship_fee1')->nullable()->default(0);
                $table->boolean('domestic_free_shipping')->nullable()->default(0);
                $table->boolean('domestic_local_pickup')->nullable()->default(0);
                $table->enum('domestic_ships_within_handling_days',[-1,0,1,2,3,4,5,10,15,20,30])->nullable()->default(-1);
                $table->float('domestic_pkg_handling_fee')->nullable()->default(0);
                $table->string('intl_shipping',255)->nullable()->default('NotSpecified');
                $table->enum('intl_ship_options1',[0,1,2,3])->nullable()->default(0);
                $table->text('intl_locations1')->nullable()->default(NULL);
                $table->string('intl_ship_service1',255)->nullable()->default(NULL);
                $table->float('intl_ship_fee1')->nullable()->default(0);
                $table->float('intl_x_ship_fee1')->nullable()->default(0);
                $table->float('intl_pkg_handling_fee')->nullable()->default(0);
                $table->enum('ship_options',[1,2])->nullable()->default(1);
                $table->text('ship_global_locations')->nullable()->default(NULL);
                $table->integer('postal_code')->nullable()->default(0);
                $table->text('domestic_ship_additional_services')->nullable()->default(NULL);
                $table->text('intl_ship_additional_services')->nullable()->default(NULL);

                $table->unsignedInteger('shipping_profile')->nullable()->default(NULL);
                $table->foreign('shipping_profile')->references('id')->on('ebay_seller_profiles')->onDelete('set null');
                
                $table->unsignedInteger('payment_profile')->nullable()->default(NULL);
                $table->foreign('payment_profile')->references('id')->on('ebay_seller_profiles')->onDelete('set null');
                
                $table->unsignedInteger('return_profile')->nullable()->default(NULL);
                $table->foreign('return_profile')->references('id')->on('ebay_seller_profiles')->onDelete('set null');

                $table->unsignedInteger('template_id')->nullable()->default(NULL);
                $table->foreign('template_id')->references('id')->on('templates')->onDelete('set null');


                $table->unsignedBigInteger('store_id');
                $table->foreign('store_id')->references('id')->on(config('config.default_database').'.shopify_stores')->onDelete('cascade');
                $table->unsignedBigInteger('user_id');
                $table->foreign('user_id')->references('id')->on(config('config.default_database').'.users')->onDelete('cascade');
                $table->timestamps();
            });
        }
    }
    
    public function down(){
        Schema::connection('tenants')->dropIfExists('profiles');
    }
}
