<?php

use Illuminate\Http\Request;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/


Route::put('/users/{id}','ProfileController@updateuser');
Route::put('/shopify_stores/{id}','ProfileController@getShopifyStoreData');

Route::middleware('auth:api')->get('/user',function(Request $request){
    return $request->user();
});

Route::get('/storedata','ShopifyController@getStoreData');
Route::get('/fetch_profiles','EbayDataController@fetchEbayProfiles');

Route::group(['middleware' => 'auth:api'],function(){

    Route::post('/accept_tos','ShopifyController@acceptTos');

   
    Route::get('/Ebayaccountssss','EbayAccountController@Ebayaccountset');
 
    Route::post('/ebayappinstall','EbayAccountController@ebayAppInstall');

    Route::get('/ebay_account','EbayAccountController@index');
    Route::get('/ebay_account/{id}','EbayAccountController@show');
    Route::post('/ebay_account','EbayAccountController@save');
    Route::put('/ebay_account/{id}','EbayAccountController@update');
    Route::delete('/ebay_account/{id}','EbayAccountController@destory');

    Route::get('/profile','ProfileController@index');
    Route::get('/profiles','ProfileController@index');
    Route::get('/profile/{id}','ProfileController@show');
    Route::post('/profile','ProfileController@save');
    Route::put('/profile/{id}','ProfileController@update');
    Route::delete('/profile/{id}','ProfileController@destroy');
    Route::post('/profile/{id}/duplicate','ProfileController@duplicate');

    Route::get('/profile/{id}/attributemapping','ProfileController@attributeMapping');
    Route::post('/profile/{id}/attributemapping','ProfileController@updateAttributeMapping');


    Route::get('/policies','PolicyController@index');
    //Route::get('/policy/{id}','PolicyController@show');
    Route::post('/policies','PolicyController@save');
    //Route::put('/policy/{id}','PolicyController@update');
    Route::delete('/policies/{id}','PolicyController@destroy');


    Route::get('/templates','TemplateController@index');
    Route::get('/template/{id}','TemplateController@show');
    Route::post('/templates','TemplateController@save');
    Route::put('/template/{id}','TemplateController@update');
    Route::delete('/template/{id}','TemplateController@destroy');

    Route::get('/products','ProductController@index');
    Route::get('/allproducts','ProductController@allProducts');
    Route::delete('/products','ProductController@destroy');

    Route::get('/product/{id}','ProductController@show');
    Route::put('/product/{id}','ProductController@update');

    Route::get('/listings','ListingController@index');
    Route::get('/orders','OrderController@index');
    Route::get('/order/{id}','OrderController@show');
    Route::get('/logs','ShopifyController@getActivityLogs');
    Route::get('/summarydata','ShopifyController@getSummaryData');

    Route::get('/plans','ShopifyController@plans');

    Route::post('/submitpublishrequest','ProductController@submitPublishRequest');
    
     Route::post('/Updateallpublish','ProductController@Updateallpublish');
     Route::post('/BulkPublishunpublishedproduct','ProductController@BulkPublishUnpublished');
     Route::post('/BulkPublishAll','ProductController@BulkPublishAll');
    
    Route::post('/linkproduct','ListingController@linkProduct');
    Route::post('/unlinkproduct','ListingController@unLinkProducts');
    Route::post('/createproducts','ListingController@createProducts');

    Route::post('/createproductsbulk','ListingController@createProductsBulk');

    Route::delete('/listings','ListingController@destroy');

    Route::get('/searchamazonproducts','ListingController@searchAmazonProducts');
    Route::get('/listingvariants','ListingController@getAmazonListingVariants');
    Route::post('/addoffertolisting','ListingController@addOfferToListing');


    Route::post('/app_charges','ShopifyController@addAppCharge');

    Route::post('/importproducts','ProductController@submitProductsImportRequest');
    Route::post('/importlistings','ListingController@submitListingsImportRequest');
    Route::post('/synclistinginventory','ListingController@submitInventorySyncRequest');
    Route::post('/synclistingprice','ListingController@submitPriceSyncRequest');
    
    Route::get('/ebaycategory','EbayDataController@ebayCategory');
    
    Route::get('/ebayspecificdata','EbayDataController@ebaySpecificData');
    Route::get('/searchebaycategories','EbayDataController@searchEbayCategory');

    Route::get('/ebayshippingservice','EbayDataController@ebayShippingService');


});



Route::group(['middleware' => 'auth:api'],function(){
    
});