"use strict";

var app = angular.module('ng-laravel', ['ui.select']);
app.controller('AmzConfigCreateCtrl', function($scope, AmzConfigService, resolvedItems, $http, $rootScope, $translatePartialLoader, Notification, trans, $state, $timeout){
		
	/*
     * Define initial value
     */
	$scope.tmp = {};
    $scope.amzconfig = resolvedItems; //{'marketplace_id':'ATVPDKIKX0DER'};
	//$scope.marketplaceList = [{key:'ATVPDKIKX0DER', value:'Amazon US'},{key:'A2EUQ1WTGCTBG2', value:'Amazon CA'}, {key:'A1F83G8C2ARO7P', value:'Amazon UK'}, {key:'A21TJRUUN4KGV', value:'Amazon IN'}, {key:'A1AM78C64UM0Y8', value:'Amazon MX'}, {key:'A1PA6795UKMFR9', value:'Amazon DE'}, {key:'A1RKKUPIHCS9HS', value:'Amazon ES'}, {key:'A13V1IB3VIYZZH', value:'Amazon FR'}, {key:'APJ6JRA9NG5V4', value:'Amazon IT'}, {key:'A1VC38T7YXB528', value:'Amazon JP'}, {key:'AAHKV2X7AFYLW', value:'Amazon CN'}, {key:'A39IBJ37TRP1C6', value:'Amazon AU'}];
	$scope.marketplaceList = [{key:'ATVPDKIKX0DER', value:'amazon.com'},{key:'A2EUQ1WTGCTBG2', value:'amazon.ca'}, {key:'A1AM78C64UM0Y8', value:'amazon.com.mx'}, {key:'A1F83G8C2ARO7P', value:'amazon.co.uk'}, {key:'A21TJRUUN4KGV', value:'amazon.in'}, {key:'A1PA6795UKMFR9', value:'amazon.de'}, {key:'A1RKKUPIHCS9HS', value:'amazon.es'}, {key:'A13V1IB3VIYZZH', value:'amazon.fr'}, {key:'APJ6JRA9NG5V4', value:'amazon.it'},
    {key:'ARBP9OOSHTCHU', value:'amazon.eg'},{key:'A2VIGQ35RCS4UG', value:'amazon.ae'}];

	AmzConfigService.list().then(function(data){
		if(data != ''){
			$scope.amzconfig = data;
			$scope.isDisabled = true;
			
		}
    });
	
	//https://shopify.infoshore.biz/xpert/authorize.php?key=11693&marketplace_id=ATVPDKIKX0DER
    /*
     * Create a task
     */
    $scope.create = function(amzconfig) {
        var key = $scope.profile.id;
        window.location.href = 'https://shopify.infoshore.biz/xpert/authorize.php?key='+key+'&marketplace_id='+amzconfig.marketplace_id;

        //$scope.isDisabled = true;
		//$scope.tmp = angular.isObject(amzconfig) ? angular.toJson(amzconfig) : amzconfig;
        //AmzConfigService.create($scope.tmp);
    };  
	
	$scope.fetch = function(amzconfig) {
        $scope.loader = true;		
        AmzConfigService.fetch();
    };

    /********************************************************
     * Event Listeners
     * Task event listener related to TaskCreateCtrl
     ********************************************************/
    // Create task event listener
    $scope.$on('amzconfig.create', function() {
       // $scope.amzconfig = {};
     Notification({message: 'amzconfig.form.amzconfigAddSuccess' ,templateUrl:'app/vendors/angular-ui-notification/tpl/success.tpl.html'},'success');
       //$scope.isDisabled = false;
	    $timeout(function() {
      $state.go('admin');
      }, 2000);

    });
	
	$scope.$on('amzconfig.fetch', function() {
		$scope.loader = false;
		Notification({message: 'amzconfig.form.amzFetchSuccess' ,templateUrl:'app/vendors/angular-ui-notification/tpl/success.tpl.html'},'success');
    });

	//Validation error in create task event listener
    $scope.$on('amzconfig.fetchError', function(event,errorData) {
		$scope.loader = false;
        Notification({message: errorData ,templateUrl:'app/vendors/angular-ui-notification/tpl/validation.tpl.html'},'warning');
    });

    //Validation error in create task event listener
    $scope.$on('amzconfig.validationError', function(event,errorData) {
        Notification({message: errorData ,templateUrl:'app/vendors/angular-ui-notification/tpl/validation.tpl.html'},'warning');
        $scope.isDisabled = false;
    });

});