'use strict';

angular.module('ng-laravel').service('EBCategoryMappingService', function($rootScope, Restangular, CacheFactory) {
    
    var _ebCategoryMappingService = Restangular.all('ebcategorymapping');
    
	if (!CacheFactory.get('ebCategoryMappingsCache')) {
		var ebCategoryMappingsCache = CacheFactory('ebCategoryMappingsCache');
    }

    this.cachedList = function() {
        // GET /api/ebcategorymapping
		if (!ebCategoryMappingsCache.get('list')) {
			return this.list();
        } else{
			return ebCategoryMappingsCache.get('list');
        }
    };

    this.list = function() {
		// GET /api/ebcategorymapping
        var data = _ebCategoryMappingService.getList();
        ebCategoryMappingsCache.put('list', data);
        return data;
    };
	
	this.show = function(id) {
        // GET /api/ebcategorymapping/:id
        var data = _ebCategoryMappingService.get(id);        
        return data;
    };

    this.pageChange = function(pageNumber, per_page, end, pagination) {
        // GET /api/ebcategorymapping?page=2		
		if(end == pagination) {
			pageNumber = 1;
			return _ebCategoryMappingService.getList({page:pageNumber, per_page:per_page});
		} else {
			return _ebCategoryMappingService.getList({page:pageNumber,per_page:per_page});
		}
    };

    this.updateMapping = function(mappingObj) {
        // POST /api/ebcategorymapping/
        var products = mappingObj.product;
        if(Array.isArray(products)){
            products = products.join();
        }        
		var data = {"product_id":products, "eb_category_id":mappingObj.new_eb_category_id};        
        _ebCategoryMappingService.post(data).then(function(resp) {
            $rootScope.$broadcast('mapping.update', data, resp);
        },function(response) {
            alert(JSON.stringify(response));
          //  $rootScope.$broadcast('mapping.validationError', response.data.error);
        });
    };

    this.search = function(query, per_page, pageNumber, end, pagination) {
		if(query !=''){
			if(end == pagination) {
				pageNumber = 1;
				return _ebCategoryMappingService.customGETLIST("search", {page:pageNumber, query:query, per_page:per_page});
			} else {
				return _ebCategoryMappingService.customGETLIST("search", {page:pageNumber, query:query, per_page:per_page});	
			}
        } else {
		//	return _ebCategoryMappingService.getList({page:pageNumber,per_page:per_page});
        }
    }
});