"use strict";

var app = angular.module('ng-laravel');
app.controller('SubscriptionCtrl', function($scope, $http, $rootScope, PlansService, $translatePartialLoader, Notification, trans, $state, $timeout){
	
	$scope.msg = "Fetching plan details...";
	$scope.planType = -1; 
	$scope.planName = ""; 
	$scope.count = -1; 

	PlansService.fetchSuggestedPlan().then(function(data) {
		$scope.planType = data.suggestedPlanType;
		$scope.planName = data.suggestedPlanName;
		$scope.count = data.count;
		if($scope.planType == 4){
			$scope.msg = "Your amazon seller central account has "+$scope.count+" In-Stock SKUs. Please send an email to shopifyapps@infoshore.biz for a quotation.";
		} else if($scope.planType != -1){
			$scope.msg = "Your amazon seller central account has "+$scope.count+" In-Stock SKUs. Please click the button below to subscribe to our "+$scope.planName+" plan.";
		} else {
			$scope.msg = "There was some error processing request. Please try after sometime or contact customer support at: shopifyapps@infoshore.biz";
		}
	}, function(response) {
		$scope.msg = "There was some error processing request. Please try after sometime or contact customer support at: shopifyapps@infoshore.biz";
	});

	$scope.upgrade = function() {
		var key = $scope.profile.tempcode;
		var plantype = $scope.planType;
        window.location.href = 'https://shopify.infoshore.biz/xpert/renew.php?key='+key+'&type='+plantype;
    };
});