"use strict";

var app = angular.module('ng-laravel', ['ui.bootstrap']);

app.controller('ProductListCtrl', function ($scope, ProductService, EBCategoryMappingService, EBCategoryService, $stateParams, $http, resolvedItems, $translatePartialLoader,$rootScope,trans,Notification) {
	/*
     * Define initial value
     */
    $scope.query = '';
	$scope.status = 'Checking status...';
	//$scope.radioValue = 1; // TODO: What is the user of this variable

    /*
     * Get all Products
     * Get from resolvedItems function in this page route (config.router.js)
     */

    $scope.products = resolvedItems;
    $scope.pagination = $scope.products.metadata;
    $scope.maxSize = 2;
	$scope.upcobj = {};

	// For eBay category mapping
	$scope.mappingObj = {};

	$scope.categorylist1 = [];
	$scope.categorylist2 = [];
	$scope.categorylist3 = [];
	$scope.categorylist4 = [];
	$scope.categorylist5 = [];
	$scope.categorylist6 = [];

    /*
     * Get all Product and refresh cache.
     * At first check cache, if exist, we return data from cache and if don't exist return from API
     */
    ProductService.list().then(function (data) {		
		$scope.products = data;
		$scope.pagination = $scope.products.metadata;		
		if($scope.pagination.total == 0) {
			$scope.fetchStatus();
		}
	});

	$scope.popupvariants = function (product_id) {
		for(var i=0; i < $scope.products.length; i++) {
			if($scope.products[i].product_id == product_id.id) {
				$scope.popupvariant = $scope.products[i].variants;
				$scope.popupoption1 = $scope.products[i].option1name;
				$scope.popupoption2 = $scope.products[i].option2name;
				$scope.popupoption3 = $scope.products[i].option3name;
			}
		}
	};
	
	$scope.popupUPC = function (variant_id) {
		$scope.upcobj.variant_id = variant_id;
		$scope.upcobj.upc = "";
	};

	$scope.updateUPC = function (upcobj) {
		$scope.loader = true;
		$scope.isDisabled = true;
		ProductService.updateUPC(upcobj.variant_id, upcobj.upc);
	};
	
	$scope.popupMapping = function (product) {
		$scope.mappingObj.product = product;
		$scope.mappingObj.eb_category_id = "";
		$scope.mappingObj.eb_category_name = "";
		$scope.mappingObj.new_eb_category_id = "";
		$scope.mappingObj.category1 = "";
		$scope.mappingObj.category2 = "";
		$scope.mappingObj.category3 = "";
		$scope.mappingObj.category4 = "";
		$scope.mappingObj.category5 = "";
		$scope.mappingObj.category6 = "";		
		var errmsg = {"msg": ["Please choose a product."]};
		if(Array.isArray(product)){
			if(product.length > 0){
				$scope.isDisabled1 = true;
				$scope.loader = true;		
				EBCategoryService.list().then(function(data){
					$scope.categorylist1 = data;			
					$scope.categorylist2 = [];
					$scope.categorylist3 = [];
					$scope.categorylist4 = [];
					$scope.categorylist5 = [];
					$scope.categorylist6 = [];
					$scope.mappingObj.category1 = "";
					$scope.mappingObj.category2 = "";
					$scope.mappingObj.category3 = "";
					$scope.mappingObj.category4 = "";
					$scope.mappingObj.category5 = "";
					$scope.mappingObj.category6 = "";
					$scope.loader = false;
					$scope.isDisabled1 = false;
				});
			} else {				
				Notification({message: errmsg, templateUrl:'app/vendors/angular-ui-notification/tpl/validation.tpl.html'}, 'warning');
				setTimeout(function() {
					$("#updateMappingModal").modal("hide");
				}, 1000);
			}				
		} else {
			if(product){
				$scope.isDisabled1 = true;
				$scope.loader = true;		
				EBCategoryMappingService.show(product).then(function(data){
					if(data.eb_category_id){									
						$scope.mappingObj.eb_category_id = data.eb_category_id;
						$scope.mappingObj.eb_category_name = data.eb_category_name;
					} else {
						$scope.mappingObj.eb_category_id = "";
						$scope.mappingObj.eb_category_name = "";
					}			
				});
				EBCategoryService.list().then(function(data){
					$scope.categorylist1 = data;			
					$scope.categorylist2 = [];
					$scope.categorylist3 = [];
					$scope.categorylist4 = [];
					$scope.categorylist5 = [];
					$scope.categorylist6 = [];
					$scope.mappingObj.category1 = "";
					$scope.mappingObj.category2 = "";
					$scope.mappingObj.category3 = "";
					$scope.mappingObj.category4 = "";
					$scope.mappingObj.category5 = "";
					$scope.mappingObj.category6 = "";
					$scope.loader = false;
					$scope.isDisabled1 = false;
				});
			} else {				
				Notification({message: errmsg, templateUrl:'app/vendors/angular-ui-notification/tpl/validation.tpl.html'}, 'warning');
				setTimeout(function() {
					$("#updateMappingModal").modal("hide");
				}, 1000);
			}
		}
	};
	
	$scope.updateMapping = function (mappingObj) {
		$scope.loader = true;
		$scope.isDisabled1 = true;
		if($scope.mappingObj.new_eb_category_id == ""){
			$scope.loader = false;			
			Notification({message: [["Please choose a valid category."]], templateUrl:'app/vendors/angular-ui-notification/tpl/validation.tpl.html'}, 'warning');
			$scope.isDisabled = false;
		} else {
			EBCategoryMappingService.updateMapping(mappingObj);
		}
	};

	$scope.categoryDropDownChanged = function(type, eb_category_id){
		$scope.isDisabled1 = true;
		$scope.loader = true;
		$scope.mappingObj.new_eb_category_id = "";
		if(type == 1){
			EBCategoryService.subCategory(eb_category_id).then(function(data){
				$scope.categorylist2 = data;
				if(!$scope.categorylist2.length){
					$scope.isDisabled1 = false;
					$scope.mappingObj.new_eb_category_id = eb_category_id;
				}
				$scope.categorylist3 = [];
				$scope.categorylist4 = [];
				$scope.categorylist5 = [];
				$scope.categorylist6 = [];
				$scope.mappingObj.category2 = "";
				$scope.mappingObj.category3 = "";
				$scope.mappingObj.category4 = "";
				$scope.mappingObj.category5 = "";
				$scope.mappingObj.category6 = "";
				$scope.loader = false;
				$scope.isDisabled1 = false;
			});
		} else if(type == 2){
			EBCategoryService.subCategory(eb_category_id).then(function(data){
				$scope.categorylist3 = data;
				if(!$scope.categorylist3.length){
					$scope.isDisabled1 = false;
					$scope.mappingObj.new_eb_category_id = eb_category_id;
				}
				$scope.categorylist4 = [];
				$scope.categorylist5 = [];
				$scope.categorylist6 = [];
				$scope.mappingObj.category3 = "";
				$scope.mappingObj.category4 = "";
				$scope.mappingObj.category5 = "";
				$scope.mappingObj.category6 = "";
				$scope.loader = false;
				$scope.isDisabled1 = false;
			});
		} else if(type == 3){
			EBCategoryService.subCategory(eb_category_id).then(function(data){
				$scope.categorylist4 = data;
				if(!$scope.categorylist4.length){
					$scope.isDisabled1 = false;
					$scope.mappingObj.new_eb_category_id = eb_category_id;
				}
				$scope.categorylist5 = [];
				$scope.categorylist6 = [];
				$scope.mappingObj.category4 = "";
				$scope.mappingObj.category5 = "";
				$scope.mappingObj.category6 = "";
				$scope.loader = false;
				$scope.isDisabled1 = false;
			});
		} else if(type == 4){
			EBCategoryService.subCategory(eb_category_id).then(function(data){
				$scope.categorylist5 = data;
				if(!$scope.categorylist5.length){
					$scope.isDisabled1 = false;
					$scope.mappingObj.new_eb_category_id = eb_category_id;
				}
				$scope.categorylist6 = [];
				$scope.mappingObj.category5 = "";
				$scope.mappingObj.category6 = "";
				$scope.loader = false;
				$scope.isDisabled1 = false;
			});
		} else if(type == 5){
			EBCategoryService.subCategory(eb_category_id).then(function(data){
				$scope.categorylist6 = data;
				if(!$scope.categorylist6.length){
					$scope.isDisabled1 = false;
					$scope.mappingObj.new_eb_category_id = eb_category_id;
				}
				$scope.mappingObj.category6 = "";
				$scope.loader = false;
				$scope.isDisabled1 = false;
			});
		} else if(type == 6){
			$scope.isDisabled1 = false;
			$scope.loader = false;
			$scope.mappingObj.new_eb_category_id = eb_category_id;
		}
	};

	/*
     * Pagination product list
     */

	$scope.units = [
        {'id': 10, 'label': '10'},
		{'id': 20, 'label': '20'},
        {'id': 50, 'label': '50'},
        {'id': 100, 'label': '100'},
    ]
    if($scope.profile.id == '1828'){
		$scope.units = [
        	{'id': 10, 'label': '10'},
			{'id': 20, 'label': '20'},
        	{'id': 50, 'label': '50'},
        	{'id': 100, 'label': '100'},
        	{'id': 500, 'label': '500'},
        	{'id': 1000, 'label': '1000'}
    	]
	}
	$scope.perPage = $scope.units[1];
	if($scope.profile.id == '1872'){
		$scope.perPage = $scope.units[3];
	}

	if($scope.perPage.id < $scope.pagination.total) {
		$scope.start = 1;
		$scope.end = $scope.perPage.id;
	} else {
		$scope.start = 1;
		$scope.end = $scope.pagination.total;
	}	

	$scope.pageChanged = function (per_page) {
		$scope.loader = true;
		if($scope.query == '') {
			ProductService.pageChange($scope.pagination.current_page, per_page.id,$scope.end,$scope.pagination.total).then(function (data) {
	            $scope.loader = false;
				$scope.products = data;
				$scope.pagination = $scope.products.metadata;
				$scope.maxSize = 2;
				if(($scope.pagination.current_page * per_page.id) < $scope.pagination.total) {
					$scope.start = $scope.pagination.current_page * per_page.id - per_page.id + 1;
					$scope.end = $scope.pagination.current_page * per_page.id;			
				} else {
					$scope.start = $scope.pagination.current_page * per_page.id - per_page.id + 1;
					$scope.end = $scope.pagination.total;	
				}
			});
		} else { 
			ProductService.search($scope.query, per_page.id, $scope.pagination.current_page, $scope.end, $scope.pagination.total).then(function (data) {
				$scope.loader = false;
				$scope.products = data;
				$scope.pagination = $scope.products.metadata;
				$scope.maxSize = 2;
				if(($scope.pagination.current_page * per_page.id) < $scope.pagination.total) {
					$scope.start = $scope.pagination.current_page * per_page.id - per_page.id + 1;
					$scope.end = $scope.pagination.current_page * per_page.id;			
				} else {
					$scope.start = $scope.pagination.current_page * per_page.id - per_page.id + 1;
					$scope.end = $scope.pagination.total;	
				}
			});
		} 
	};

	/*
     * Search in Product
     */

	$scope.search = function (per_page) {
		$scope.loader = true;
		ProductService.search($scope.query, per_page.id).then(function (data) {	
			$scope.loader = false;
			$scope.products = data;
			$scope.pagination = $scope.products.metadata;			
            $scope.maxSize = 2;
			if(($scope.pagination.current_page * per_page.id) < $scope.pagination.total) {
				$scope.start = $scope.pagination.current_page * per_page.id - per_page.id + 1;
				$scope.end = $scope.pagination.current_page * per_page.id;			
			} else {
				$scope.start = $scope.pagination.current_page * per_page.id - per_page.id + 1;
				$scope.end = $scope.pagination.total;	
			}
		});
	};

	$scope.refresh = function(){
		$scope.loader = true;
		$scope.query = '';
		ProductService.list().then(function (data) {
			$scope.loader = false;
			$scope.products = data;
			$scope.pagination = $scope.products.metadata;
			$scope.maxSize = 2;
			$scope.perPage = $scope.units[1];
			var per_page = $scope.perPage;
			if(($scope.pagination.current_page * per_page.id) < $scope.pagination.total) {
				$scope.start = $scope.pagination.current_page * per_page.id - per_page.id + 1;
				$scope.end = $scope.pagination.current_page * per_page.id;			
			} else {
				$scope.start = $scope.pagination.current_page * per_page.id - per_page.id + 1;
				$scope.end = $scope.pagination.total;	
			}
			//$scope.start = 1;
			//$scope.end = $scope.perPage.id;		
		});
	}

	$scope.fetchStatus = function(){
		ProductService.fetchStatus().then(function (data) {	
			if(data.status == 'AMZ_KEY_NOT_EXIST'){
				$scope.status = "You have not added Amazon MWS keys yet. Please add your MWS keys to start fetching the products!";
			} else if (data.status == 'REQUEST_IN_PROGRESS') {
				$scope.status = "Account setup is in progress. Please check back later!";
			} else {
				$scope.status = "Your Amazon seller central account does not have any active product!";
			}
		});
	}
	
	/*
     * pushall selected Products
     */

    $scope.pushall = function (product) {
		$scope.loader = true;
		ProductService.pushall(product);
	};

	/*
     * push selected Products
     */
	$scope.push = function (product) {
		var errmsg = {"msg": ["Please choose a product to import."]};
		if(Array.isArray(product)){
			if(product.length > 0){
				$scope.loader = true;
				ProductService.push(product);	
			} else {
				Notification({message: errmsg, templateUrl:'app/vendors/angular-ui-notification/tpl/validation.tpl.html'}, 'warning');
			}				
		} else {
			if(product){
				$scope.loader = true;
				ProductService.push(product);
			} else {
				Notification({message: errmsg, templateUrl:'app/vendors/angular-ui-notification/tpl/validation.tpl.html'}, 'warning');
			}
		}
    };

	// Push product to ebay
	$scope.pushEB = function (product) {
		var errmsg = {"msg": ["Please choose a product to import."]};
		if(Array.isArray(product)){
			if(product.length > 0){
				$scope.loader = true;
				ProductService.pushEB(product);	
			} else {
				Notification({message: errmsg, templateUrl:'app/vendors/angular-ui-notification/tpl/validation.tpl.html'}, 'warning');
			}				
		} else {
			if(product){
				$scope.loader = true;
				ProductService.pushEB(product);
			} else {
				Notification({message: errmsg, templateUrl:'app/vendors/angular-ui-notification/tpl/validation.tpl.html'}, 'warning');
			}
		}
    };
	
	// Push product to walmart
	$scope.pushWM = function (product) {
		var errmsg = {"msg": ["Please choose a product to import."]};
		if(Array.isArray(product)){
			if(product.length > 0){
				$scope.loader = true;
				ProductService.pushWM(product);	
			} else {
				Notification({message: errmsg, templateUrl:'app/vendors/angular-ui-notification/tpl/validation.tpl.html'}, 'warning');
			}				
		} else {
			if(product){
				$scope.loader = true;
				ProductService.pushWM(product);
			} else {
				Notification({message: errmsg, templateUrl:'app/vendors/angular-ui-notification/tpl/validation.tpl.html'}, 'warning');
			}
		}
    };

	// Duplicate product to amazon
	$scope.pushDupAmz = function (product) {
		var errmsg = {"msg": ["Please choose a product to import."]};
		if(Array.isArray(product)){
			if(product.length > 0){
				$scope.loader = true;
				ProductService.pushDupAmz(product);	
			} else {
				Notification({message: errmsg, templateUrl:'app/vendors/angular-ui-notification/tpl/validation.tpl.html'}, 'warning');
			}				
		} else {
			if(product){
				$scope.loader = true;
				ProductService.pushDupAmz(product);
			} else {
				Notification({message: errmsg, templateUrl:'app/vendors/angular-ui-notification/tpl/validation.tpl.html'}, 'warning');
			}
		}
    };
	
	// Refresh image
	$scope.requestImgRefresh = function (product) {
		var errmsg = {"msg": ["Please choose a product to import."]};
		if(Array.isArray(product)){
			if(product.length > 0){
				$scope.loader = true;
				ProductService.requestImgRefresh(product);	
			} else {
				Notification({message: errmsg, templateUrl:'app/vendors/angular-ui-notification/tpl/validation.tpl.html'}, 'warning');
			}				
		} else {
			if(product){
				$scope.loader = true;
				ProductService.requestImgRefresh(product);
			} else {
				Notification({message: errmsg, templateUrl:'app/vendors/angular-ui-notification/tpl/validation.tpl.html'}, 'warning');
			}
		}
    };

	/*
     * unblock selected Products
     */
	$scope.unblock = function (product) {
		var errmsg = {"msg": ["Please choose a product to unblock."]};
		if(Array.isArray(product)){
			if(product.length > 0){
				$scope.loader = true;
				ProductService.unblock(product);
			} else {
				Notification({message: errmsg, templateUrl:'app/vendors/angular-ui-notification/tpl/validation.tpl.html'}, 'warning');
			}				
		} else {
			if(product){
				$scope.loader = true;
				ProductService.unblock(product);
			} else {
				Notification({message: errmsg, templateUrl:'app/vendors/angular-ui-notification/tpl/validation.tpl.html'}, 'warning');
			}
		}				


	};

	/*
     * block selected Products
     */
    $scope.block = function (product) {
		var errmsg = {"msg": ["Please choose a product to block."]};
		if(Array.isArray(product)){
			if(product.length > 0){
				$scope.loader = true;
				ProductService.block(product);
			} else {
				Notification({message: errmsg, templateUrl:'app/vendors/angular-ui-notification/tpl/validation.tpl.html'}, 'warning');
			}				
		} else {
			if(product){
				$scope.loader = true;
				ProductService.block(product);
			} else {
				Notification({message: errmsg, templateUrl:'app/vendors/angular-ui-notification/tpl/validation.tpl.html'}, 'warning');
			}
		}		
    };
	
	/*
     * remove selected Products
     */
	$scope.remove = function (product) {
		var errmsg = {"msg": ["Please choose a product to import."]};
		if(Array.isArray(product)){
			if(product.length > 0){
				$scope.loader = true;
				ProductService.remove(product);	
			} else {
				Notification({message: errmsg, templateUrl:'app/vendors/angular-ui-notification/tpl/validation.tpl.html'}, 'warning');
			}				
		} else {
			if(product){
				$scope.loader = true;
				ProductService.remove(product);
			} else {
				Notification({message: errmsg, templateUrl:'app/vendors/angular-ui-notification/tpl/validation.tpl.html'}, 'warning');
			}
		}
    };

	$scope.export = function () {
		$scope.loader = true;
		ProductService.downloadExport();
	};

	$scope.export1 = function () {
		$scope.loader = true;
		ProductService.downloadExport1();
	};

	$scope.resync = function () {
		$scope.loader = true;
		ProductService.resync();
	};

    /**********************************************************
     * Event Listener
     **********************************************************/
        // Get list of selected product to do actions

    $scope.selection = [];
	$scope.selectedAll = false;
	$scope.checkAll = function () {		
		if ($scope.selectedAll) {
			$scope.selectedAll = true;				
        } else {
			$scope.selectedAll = false;
        }
		angular.forEach($scope.products, function (product) {
			 product.Selected = $scope.selectedAll;
			 $scope.toggleSelection(product.product_id);
        });
    };

    $scope.toggleSelection = function toggleSelection(productId) {
		// toggle selection for a given product by Id
		var idx = $scope.selection.indexOf(productId);
		// is currently selected
		if (idx > -1) {
			$scope.selection.splice(idx, 1);
        } else {
			$scope.selection.push(productId);
        }
    };

	$scope.removeSelection = function removeSelection(productId) {
		// toggle selection for a given product by Id
		var idx = $scope.selection.indexOf(productId);
		// is currently selected
		if (idx > -1) {
			$scope.selection.splice(idx, 1);
        }
    };

    $scope.$on('product.push', function (event, data, skuconsumed) {
		$scope.loader = false;
        if(Array.isArray(data)){
			Notification({message: 'product.form.productPushSuccessP', templateUrl:'app/vendors/angular-ui-notification/tpl/success.tpl.html'},'success');
			for(var i = 0; i < $scope.products.length; i++) {
				if($.inArray($scope.products[i].product_id, data) > -1) {
					$scope.products[i].status = "Import in progress";
					$scope.removeSelection($scope.products[i].product_id);
				}
			}
			$scope.selectedAll = '';
			$scope.profile.skuconsumed = skuconsumed;
		} else {
			Notification({message: 'product.form.productPushSuccess', templateUrl:'app/vendors/angular-ui-notification/tpl/success.tpl.html'},'success');
			for(var i = 0; i < $scope.products.length; i++) {
				if($scope.products[i].product_id == data) {
					$scope.products[i].status = "Import in progress";
					$scope.removeSelection($scope.products[i].product_id);
					break;
				}
			}
			$scope.profile.skuconsumed = skuconsumed;
		}		
    }); 

    $scope.$on('product.block', function (event, data) {
		$scope.loader = false;
		if(Array.isArray(data)){
			Notification({message: 'product.form.productBlockSuccessP', templateUrl:'app/vendors/angular-ui-notification/tpl/success.tpl.html'},'success');
			for(var i = 0; i < $scope.products.length; i++) {
				if($.inArray($scope.products[i].product_id, data) > -1) {
					$scope.products[i].block = 1;
					$scope.removeSelection($scope.products[i].product_id);
				}
			}
			$scope.selectedAll = '';
		} else {
			Notification({message: 'product.form.productBlockSuccess', templateUrl:'app/vendors/angular-ui-notification/tpl/success.tpl.html'},'success');
			for(var i = 0; i < $scope.products.length; i++) {
				if($scope.products[i].product_id == data) {
					$scope.products[i].block = 1;
					$scope.removeSelection($scope.products[i].product_id);
					break;
				}
			}
		}		
    });

    $scope.$on('product.unblock', function (event, data) {
		$scope.loader = false;
        if(Array.isArray(data)){
			Notification({message: 'product.form.productUnblockSuccessP' ,templateUrl:'app/vendors/angular-ui-notification/tpl/success.tpl.html'},'success');
			for(var i = 0; i < $scope.products.length; i++) {
				if($.inArray($scope.products[i].product_id, data) > -1) {
					$scope.products[i].block = 0;
					$scope.removeSelection($scope.products[i].product_id);
				}
			}
			$scope.selectedAll = '';
		} else {
			Notification({message: 'product.form.productUnblockSuccess' ,templateUrl:'app/vendors/angular-ui-notification/tpl/success.tpl.html'},'success');
			for(var i = 0; i < $scope.products.length; i++) {
				if($scope.products[i].product_id == data) {
					$scope.products[i].block = 0;
					$scope.removeSelection($scope.products[i].product_id);
					break;
				}
			}
		}		
    });

    $scope.$on('product.pushall', function (event, skuconsumed) {
		Notification({message: 'product.form.productPushAllSuccess' ,templateUrl:'app/vendors/angular-ui-notification/tpl/success.tpl.html'},'success');
		$scope.profile.skuconsumed = skuconsumed;
		ProductService.list().then(function (data) {
			$scope.loader = false;
			$scope.products = data;
            $scope.selection = [];
        });
    });

	$scope.$on('product.pusheb', function (event, data, skuconsumed, type) {
		$scope.loader = false;
        if(Array.isArray(data)){
			Notification({message: 'product.form.productPushSuccessP', templateUrl:'app/vendors/angular-ui-notification/tpl/success.tpl.html'},'success');
			for(var i = 0; i < $scope.products.length; i++) {
				if($.inArray($scope.products[i].product_id, data) > -1) {
					if($scope.products[i].eb_status == "Ready to Import") {
						$scope.products[i].eb_status = "Import in progress";
					}
					$scope.removeSelection($scope.products[i].product_id);
				}
			}
			$scope.profile.skuconsumed = skuconsumed;
		} else {
			Notification({message: 'product.form.productPushSuccess', templateUrl:'app/vendors/angular-ui-notification/tpl/success.tpl.html'},'success');
			for(var i = 0; i < $scope.products.length; i++) {
				if($scope.products[i].product_id == data) {
					if($scope.products[i].eb_status == "Ready to Import") {
						$scope.products[i].eb_status = "Import in progress";
					}
					$scope.removeSelection($scope.products[i].product_id);
					break;
				}
			}
			$scope.profile.skuconsumed = skuconsumed;
		}		
    });
	
	$scope.$on('product.pushwm', function (event, data, skuconsumed, type) {
		$scope.loader = false;
        if(Array.isArray(data)){
			Notification({message: 'product.form.productPushSuccessP', templateUrl:'app/vendors/angular-ui-notification/tpl/success.tpl.html'},'success');
			for(var i = 0; i < $scope.products.length; i++) {
				if($.inArray($scope.products[i].product_id, data) > -1) {
					$scope.products[i].wm_status = "Import in progress";
					$scope.removeSelection($scope.products[i].product_id);
				}
			}
			$scope.profile.skuconsumed = skuconsumed;
		} else {
			Notification({message: 'product.form.productPushSuccess', templateUrl:'app/vendors/angular-ui-notification/tpl/success.tpl.html'},'success');
			for(var i = 0; i < $scope.products.length; i++) {
				if($scope.products[i].product_id == data) {
					$scope.products[i].wm_status = "Import in progress";
					$scope.removeSelection($scope.products[i].product_id);
					break;
				}
			}
			$scope.profile.skuconsumed = skuconsumed;
		}		
    });

	$scope.$on('product.pushdupamz', function (event, data, skuconsumed, type) {
		$scope.loader = false;
        if(Array.isArray(data)){
			Notification({message: 'product.form.productPushSuccessP', templateUrl:'app/vendors/angular-ui-notification/tpl/success.tpl.html'},'success');
			for(var i = 0; i < $scope.products.length; i++) {
				if($.inArray($scope.products[i].product_id, data) > -1) {
					$scope.products[i].dup_product.status = "Import in progress";
					$scope.removeSelection($scope.products[i].product_id);
				}
			}
			$scope.profile.skuconsumed = skuconsumed;
		} else {
			Notification({message: 'product.form.productPushSuccess', templateUrl:'app/vendors/angular-ui-notification/tpl/success.tpl.html'},'success');
			for(var i = 0; i < $scope.products.length; i++) {
				if($scope.products[i].product_id == data) {
					$scope.products[i].dup_product.status = "Import in progress";
					$scope.removeSelection($scope.products[i].product_id);
					break;
				}
			}
			$scope.profile.skuconsumed = skuconsumed;
		}		
    });
	
	$scope.$on('product.requestImgRefresh', function (event, data, type) {
		$scope.loader = false;
        if(Array.isArray(data)){
			Notification({message: 'Request has been scheduled and will be processed soon.', templateUrl:'app/vendors/angular-ui-notification/tpl/success.tpl.html'},'success');			
		} else {
			Notification({message: 'Request has been scheduled and will be processed soon.', templateUrl:'app/vendors/angular-ui-notification/tpl/success.tpl.html'},'success');			
		}		
    });

	$scope.$on('product.updateupc', function (event, data) {
		$scope.loader = false;
		$scope.isDisabled = false;
		Notification({message: 'product.form.upcUpdateSuccess', templateUrl:'app/vendors/angular-ui-notification/tpl/success.tpl.html'},'success');
		for(var i = 0; i < $scope.products.length; i++) {
			if($scope.products[i].variants[0].id == data.variant_id) {
				$scope.products[i].variants[0].productidtype = 3;
				$scope.products[i].variants[0].productid = data.upc;
			}
		}
		$('#upcModal').modal('hide');
    });
	
	$scope.$on('product.exportdone', function (event) {
		$scope.loader = false;		
    });
	
	$scope.$on('mapping.update', function (event, data, resp) {
		$scope.loader = false;
		$scope.isDisabled = false;
		Notification({message: 'mapping.form.mappingUpdateSuccess', templateUrl:'app/vendors/angular-ui-notification/tpl/success.tpl.html'},'success');				
		$('#updateMappingModal').modal('hide');
    });

	$scope.$on('product.resync', function (event, data, resp) {
		$scope.loader = false;
		$scope.isDisabled = false;
		Notification({message: 'Request has been initiated.', templateUrl:'app/vendors/angular-ui-notification/tpl/success.tpl.html'},'success');		
    });

    $scope.$on('product.validationError', function(event,errorData) {
		$scope.loader = false;
		ProductService.list().then(function (data) {
			//$scope.products = data;
            $scope.selection = [];
			$scope.selectedAll= '';
        });
		Notification({message: errorData, templateUrl:'app/vendors/angular-ui-notification/tpl/validation.tpl.html'}, 'warning');
		$scope.isDisabled = false;
	});

	$scope.$on('product.remove', function (event, data) {
		$scope.loader = false;
        if(Array.isArray(data)){
			Notification({message: 'Products have been removed successfully.', templateUrl:'app/vendors/angular-ui-notification/tpl/success.tpl.html'},'success');
			for(var i = 0; i < $scope.products.length; i++) {
				if($.inArray($scope.products[i].product_id, data) > -1) {
				    $scope.products.splice(i, 1); 
					//$scope.products[i].status = "Ready to Import";
				//	$scope.removeSelection($scope.products[i].product_id);
				}
			}
			$scope.selectedAll = '';
		} else {
			Notification({message: 'Product has been removed successfully.', templateUrl:'app/vendors/angular-ui-notification/tpl/success.tpl.html'},'success');
			for(var i = 0; i < $scope.products.length; i++) {
				if($scope.products[i].product_id == data) {
				    $scope.products.splice(i, 1); 
				//	$scope.products[i].status = "Ready to Import";
				//	$scope.removeSelection($scope.products[i].product_id);
					break;
				}
			}
		}		
    });
});