'use strict';

angular.module('ng-laravel').service('ProductService', function($rootScope, Restangular,CacheFactory) {
    
	/*
     * Build collection /product
     */
	var _productService = Restangular.all('product');
    
	if (!CacheFactory.get('productsCache')) {
		var productsCache = CacheFactory('productsCache');
    }

    /*
     * Get list of products from cache.
     * if cache is empty, data fetched and cache create else retrieve from cache
     */
    this.cachedList = function() {
        // GET /api/product
		if (!productsCache.get('list')) {
			return this.list();
        } else{
			return productsCache.get('list');
        }
    };

    /*
     * Get list of products
     */
    this.list = function() {
		// GET /api/product
        var data = _productService.getList();
        productsCache.put('list', data);
        return data;
    };

	/*
     * Pagination change
     */
    this.pageChange = function(pageNumber, per_page, end, pagination) {
        // GET /api/product?page=2		
		if(end == pagination) {
		//	pageNumber = 1;
			return _productService.getList({page:pageNumber, per_page:per_page});
		} else {
			return _productService.getList({page:pageNumber,per_page:per_page});
		}
    };

    /*this.cachedShow = function(id) {
        // GET /api/task/:id
        if (!productsCache.get('show'+id)) {
            return this.show(id);
        } else{
            return productsCache.get('show'+id);
        }
    };*/

	/*
     * Search in product
     */
	this.search = function(query, per_page, pageNumber, end, pagination) {
	    // GET /api/product/search?query=test&per_page=10
		//alert(JSON.stringify(query));
		//alert(JSON.stringify(pageNumber));
        if(query !=''){
			if(end == pagination) {
				pageNumber = 1;
				return _productService.customGETLIST("search", {page:pageNumber, query:query, per_page:per_page});
			} else {
				return _productService.customGETLIST("search", {page:pageNumber, query:query, per_page:per_page});	
			}
        } else {
			return _productService.getList({page:pageNumber,per_page:per_page});
        }
    }
	
	/*
     * pushall Product (PUT)
     */
    this.pushall = function() {        
		Restangular.all('product/pushall').post().then(function(response) {
			$rootScope.$broadcast('product.pushall', response.skuconsumed);
        }, function(response) {			
			$rootScope.$broadcast('product.validationError', response.data.error);
        });
    };

	/*
     * push Product 
     */
    this.push = function(selection) {
		Restangular.several('product/push',selection).post().then(function(response) {
			$rootScope.$broadcast('product.push', selection, response.skuconsumed);
        }, function(response){
			//console.log(response);
			$rootScope.$broadcast('product.validationError', response.data.error);
        });
    };
	
	// Push product to eBay
    this.pushEB = function(selection) {
		Restangular.several('product/pusheb',selection).post().then(function(response) {
			$rootScope.$broadcast('product.pusheb', selection, response.skuconsumed);
        }, function(response){
			//console.log(response);
			$rootScope.$broadcast('product.validationError', response.data.error);
        });
    };
	
	// Push product to walmart
    this.pushWM = function(selection) {
		Restangular.several('product/pushwm',selection).post().then(function(response) {
			$rootScope.$broadcast('product.pushwm', selection, response.skuconsumed);
        }, function(response){
			//console.log(response);
			$rootScope.$broadcast('product.validationError', response.data.error);
        });
    };

	// Push product to duplicate on amazon
    this.pushDupAmz = function(selection) {
		Restangular.several('product/pushdupamz', selection).post().then(function(response) {
			$rootScope.$broadcast('product.pushdupamz', selection, response.skuconsumed);
        }, function(response){
			$rootScope.$broadcast('product.validationError', response.data.error);
        });
    };
	
	// Request Image refresh
    this.requestImgRefresh = function(selection) {
		Restangular.several('product/requestImgRefresh', selection).post().then(function(response) {
			$rootScope.$broadcast('product.requestImgRefresh', selection);
        }, function(response){
			$rootScope.$broadcast('product.validationError', response.data.error);
        });
    };

	/*
     * unblock Product 
     */
    this.unblock = function(selection) {      
		Restangular.several('product/unblock',selection).post().then(function() {
			$rootScope.$broadcast('product.unblock', selection);
        }, function(response){			
			$rootScope.$broadcast('product.validationError', response.data.error);
        });
    };

	/*
     * block Product
     */
    this.block = function(selection) {  
	    Restangular.several('product/block', selection).post().then(function() {
		    $rootScope.$broadcast('product.block', selection);
        }, function(response){
			$rootScope.$broadcast('product.validationError',response.data.error);
        });
    };

	this.fetchStatus = function() {
        // GET /api/amzconfig/status
		var _amzconfigService = Restangular.one('amzconfig');
        var data = _amzconfigService.customGET("status");  
		return data;
    };

	this.updateUPC = function(variant_id, upc) {
		var data = {'variant_id': variant_id, 'upc': upc};
	    Restangular.all('product').customPOST(data, "updateupc").then(function() {
		    $rootScope.$broadcast('product.updateupc', data);
        }, function(response){
			//console.log(response);
			$rootScope.$broadcast('product.validationError',response.data.error);
        });
    };

    this.resync = function() {		
    	Restangular.all('product/resync').post().then(function(response) {
			$rootScope.$broadcast('product.resync');
        }, function(response) {			
			$rootScope.$broadcast('product.validationError', response.data.error);
        });	    
    };
	
	this.remove = function(selection) {
		Restangular.several('product/remove',selection).post().then(function(response) {
			$rootScope.$broadcast('product.remove', selection);
        }, function(response){
			$rootScope.$broadcast('product.validationError', response.data.error);
        });
    };

	this.downloadExport = function(){
		_productService.customGET('export/file').then(function(response) {
            var anchor = document.createElement("a");
            document.body.appendChild(anchor);//required in FF, optional for Chrome
            anchor.download = "exportfile.xlsx";
            anchor.href = "http://api.skububble.com/public/reports/user.xlsx";
            anchor.click();
			$rootScope.$broadcast('product.exportdone');
        })
    };

	this.downloadExport1 = function(){
		_productService.customGET('export/file1').then(function(response) {
            var anchor = document.createElement("a");
            document.body.appendChild(anchor);//required in FF, optional for Chrome
            anchor.download = "exportfile.xlsx";
            anchor.href = "http://api.skububble.com/public/reports/dupamz.xlsx";
            anchor.click();
			$rootScope.$broadcast('product.exportdone');
        })
    };
});