<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class EbProduct extends Model {
		
	protected $table = 'products1';

	protected $primaryKey = 'product_id';

    public function user() {
		return $this->belongsTo('App\User', 'user_id', 'id');
	}
	
	public function variants() {
		return $this->hasMany('App\EbProductVariant', 'product_id', 'product_id');
	}

	public function variantsCount() {
		return $this->hasOne('App\EbProductVariant', 'product_id', 'product_id')->selectRaw('product_id, count(*) as no_of_variants, sum(quantity) as quantity')->groupBy('product_id');
	}

    protected $fillable = [
        'user_id', 'title', 'description', 'feature1', 'feature2', 'feature3', 'feature4', 'feature5', 'item_note', 'brand', 'product_type', 'option1name', 'option2name', 'option3name', 'shopifyproductid', 'newflag', 'quantityflag', 'priceflag'
	];
	
}