<?php

namespace App;

use Illuminate\Database\Eloquent\Model;


class ProductVariant extends Model {
	
	protected $table = 'product_variants';

	protected $primaryKey = 'id';
	
	public function user() {
		return $this->belongsTo('App\User', 'user_id', 'id');
	}

	public function product() {
		return $this->belongsTo('App\Product', 'product_id', 'product_id');
	}	
	
	public function dupVariant() {
		return $this->hasOne('App\DupProductVariant', 'orig_variant_id', 'id');
	}

    protected $fillable = [
        'product_id', 'sku', 'option1val', 'option2val', 'option3val', 'price', 'quantity', 'productidtype','productid', 'newflag', 'quantityflag', 'priceflag', 'shopifyproductid', 'shopifyvariantid'
    ];
	
}
