"use strict";

var app = angular.module('ng-laravel', ['ui.bootstrap']);
app.controller('EbProductListCtrl', function ($scope, EbProductService, $stateParams, $http, resolvedItems, $translatePartialLoader, $rootScope, trans, Notification) {

	/*
     * Define initial value
     */
    $scope.query = '';
	$scope.status = 'Checking status...';

    /*
     * Get all Products
     * Get from resolvedItems function in this page route (config.router.js)
     */
    $scope.products = resolvedItems;
    $scope.pagination = $scope.products.metadata;
    $scope.maxSize = 2;
	$scope.upcobj = {};

    /*
     * Get all Product and refresh cache.
     * At first check cache, if exist, we return data from cache and if don't exist return from API
     */
    EbProductService.list().then(function (data) {		
		$scope.products = data;
		$scope.pagination = $scope.products.metadata;		
		if($scope.pagination.total == 0) {
			$scope.fetchStatus();
		}
	});

	$scope.popupvariants = function (product_id) {
		for(var i=0; i < $scope.products.length; i++) {
			if($scope.products[i].product_id == product_id.id) {
				$scope.popupvariant = $scope.products[i].variants;
				$scope.popupoption1 = $scope.products[i].option1name;
				$scope.popupoption2 = $scope.products[i].option2name;
				$scope.popupoption3 = $scope.products[i].option3name;
			}
		}
	};
		
	/*
     * Pagination product list
     */
	$scope.units = [
        {'id': 10, 'label': '10'},
		{'id': 20, 'label': '20'},
        {'id': 50, 'label': '50'},
        {'id': 100, 'label': '100'},
    ]
	$scope.perPage = $scope.units[1];
	if($scope.profile.id == '1872'){
		$scope.perPage = $scope.units[3];
	}
	if($scope.perPage.id < $scope.pagination.total) {
		$scope.start = 1;
		$scope.end = $scope.perPage.id;
	} else {
		$scope.start = 1;
		$scope.end = $scope.pagination.total;
	}	
	
	$scope.pageChanged = function (per_page) {
		$scope.loader = true;
		if($scope.query == '') {
			EbProductService.pageChange($scope.pagination.current_page, per_page.id,$scope.end,$scope.pagination.total).then(function (data) {
	            $scope.loader = false;
				$scope.products = data;
				$scope.pagination = $scope.products.metadata;
				$scope.maxSize = 2;
				if(($scope.pagination.current_page * per_page.id) < $scope.pagination.total) {
					$scope.start = $scope.pagination.current_page * per_page.id - per_page.id + 1;
					$scope.end = $scope.pagination.current_page * per_page.id;			
				} else {
					$scope.start = $scope.pagination.current_page * per_page.id - per_page.id + 1;
					$scope.end = $scope.pagination.total;	
				}
			});
		} else { 
			EbProductService.search($scope.query, per_page.id, $scope.pagination.current_page, $scope.end, $scope.pagination.total).then(function (data) {
				$scope.loader = false;
				$scope.products = data;
				$scope.pagination = $scope.products.metadata;
				$scope.maxSize = 2;
				if(($scope.pagination.current_page * per_page.id) < $scope.pagination.total) {
					$scope.start = $scope.pagination.current_page * per_page.id - per_page.id + 1;
					$scope.end = $scope.pagination.current_page * per_page.id;			
				} else {
					$scope.start = $scope.pagination.current_page * per_page.id - per_page.id + 1;
					$scope.end = $scope.pagination.total;	
				}
			});
		} 
	};

	/*
     * Search in Product
     */
	 
	$scope.search = function (per_page) {
		$scope.loader = true;
		EbProductService.search($scope.query, per_page.id).then(function (data) {	
			$scope.loader = false;
			$scope.products = data;
			$scope.pagination = $scope.products.metadata;			
            $scope.maxSize = 2;
			if(($scope.pagination.current_page * per_page.id) < $scope.pagination.total) {
				$scope.start = $scope.pagination.current_page * per_page.id - per_page.id + 1;
				$scope.end = $scope.pagination.current_page * per_page.id;			
			} else {
				$scope.start = $scope.pagination.current_page * per_page.id - per_page.id + 1;
				$scope.end = $scope.pagination.total;	
			}
		});
	};
	
	$scope.refresh = function(){
		$scope.loader = true;
		$scope.query = '';
		EbProductService.list().then(function (data) {
			$scope.loader = false;
			$scope.products = data;
			$scope.pagination = $scope.products.metadata;
			$scope.maxSize = 2;
			$scope.perPage = $scope.units[1];
			var per_page = $scope.perPage;
			if(($scope.pagination.current_page * per_page.id) < $scope.pagination.total) {
				$scope.start = $scope.pagination.current_page * per_page.id - per_page.id + 1;
				$scope.end = $scope.pagination.current_page * per_page.id;			
			} else {
				$scope.start = $scope.pagination.current_page * per_page.id - per_page.id + 1;
				$scope.end = $scope.pagination.total;	
			}
			//$scope.start = 1;
			//$scope.end = $scope.perPage.id;		
		});
	}
	
	$scope.fetchStatus = function(){
		EbProductService.fetchStatus().then(function (data) {	
			if(data.status == 'AMZ_KEY_NOT_EXIST'){
				$scope.status = "You have not added Amazon MWS keys yet. Please add your MWS keys to start fetching the products!";
			} else if (data.status == 'REQUEST_IN_PROGRESS') {
				$scope.status = "Account setup is in progress. Please check back later!";
			} else {
				$scope.status = "Your Amazon seller central account does not have any active product!";
			}
		});
	}
	
	/*
     * pushall selected Products
     */
    $scope.pushall = function (product) {
		$scope.loader = true;
		EbProductService.pushall(product);
	};
	
	
	/*
     * push selected Products
     */
	$scope.push = function (product) {
		var errmsg = {"msg": ["Please choose a product to import."]};
		if(Array.isArray(product)){
			if(product.length > 0){
				$scope.loader = true;
				EbProductService.push(product);	
			} else {
				Notification({message: errmsg, templateUrl:'app/vendors/angular-ui-notification/tpl/validation.tpl.html'}, 'warning');
			}				
		} else {
			if(product){
				$scope.loader = true;
				EbProductService.push(product);
			} else {
				Notification({message: errmsg, templateUrl:'app/vendors/angular-ui-notification/tpl/validation.tpl.html'}, 'warning');
			}
		}
    };		
	
	/*
     * unblock selected Products
     */
	$scope.unblock = function (product) {
		var errmsg = {"msg": ["Please choose a product to unblock."]};
		if(Array.isArray(product)){
			if(product.length > 0){
				$scope.loader = true;
				EbProductService.unblock(product);
			} else {
				Notification({message: errmsg, templateUrl:'app/vendors/angular-ui-notification/tpl/validation.tpl.html'}, 'warning');
			}				
		} else {
			if(product){
				$scope.loader = true;
				EbProductService.unblock(product);
			} else {
				Notification({message: errmsg, templateUrl:'app/vendors/angular-ui-notification/tpl/validation.tpl.html'}, 'warning');
			}
		}				
	};
	
	
	/*
     * block selected Products
     */
    $scope.block = function (product) {
		var errmsg = {"msg": ["Please choose a product to block."]};
		if(Array.isArray(product)){
			if(product.length > 0){
				$scope.loader = true;
				EbProductService.block(product);
			} else {
				Notification({message: errmsg, templateUrl:'app/vendors/angular-ui-notification/tpl/validation.tpl.html'}, 'warning');
			}				
		} else {
			if(product){
				$scope.loader = true;
				EbProductService.block(product);
			} else {
				Notification({message: errmsg, templateUrl:'app/vendors/angular-ui-notification/tpl/validation.tpl.html'}, 'warning');
			}
		}		
    };	

    /**********************************************************
     * Event Listener
     **********************************************************/
        // Get list of selected product to do actions
    $scope.selection = [];
	$scope.selectedAll = false;
	$scope.checkAll = function () {		
		if ($scope.selectedAll) {
			$scope.selectedAll = true;				
        } else {
			$scope.selectedAll = false;
        }
		angular.forEach($scope.products, function (product) {
			 product.Selected = $scope.selectedAll;
			 $scope.toggleSelection(product.product_id);
        });
    };

    $scope.toggleSelection = function toggleSelection(productId) {
		// toggle selection for a given product by Id
		var idx = $scope.selection.indexOf(productId);
		// is currently selected
		if (idx > -1) {
			$scope.selection.splice(idx, 1);
        } else {
			$scope.selection.push(productId);
        }
    };
	
	$scope.removeSelection = function removeSelection(productId) {
		// toggle selection for a given product by Id
		var idx = $scope.selection.indexOf(productId);
		// is currently selected
		if (idx > -1) {
			$scope.selection.splice(idx, 1);
        }
    };

    $scope.$on('product.push', function (event, data, skuconsumed) {
		$scope.loader = false;
        if(Array.isArray(data)){
			Notification({message: 'product.form.productPushSuccessP', templateUrl:'app/vendors/angular-ui-notification/tpl/success.tpl.html'},'success');
			for(var i = 0; i < $scope.products.length; i++) {
				if($.inArray($scope.products[i].product_id, data) > -1) {
					$scope.products[i].status = "Import in progress";
					$scope.removeSelection($scope.products[i].product_id);
				}
			}
			$scope.selectedAll = '';
			$scope.profile.skuconsumed = skuconsumed;
		} else {
			Notification({message: 'product.form.productPushSuccess', templateUrl:'app/vendors/angular-ui-notification/tpl/success.tpl.html'},'success');
			for(var i = 0; i < $scope.products.length; i++) {
				if($scope.products[i].product_id == data) {
					$scope.products[i].status = "Import in progress";
					$scope.removeSelection($scope.products[i].product_id);
					break;
				}
			}
			$scope.profile.skuconsumed = skuconsumed;
		}		
    });
   
    $scope.$on('product.block', function (event, data) {
		$scope.loader = false;
		if(Array.isArray(data)){
			Notification({message: 'product.form.productBlockSuccessP', templateUrl:'app/vendors/angular-ui-notification/tpl/success.tpl.html'},'success');
			for(var i = 0; i < $scope.products.length; i++) {
				if($.inArray($scope.products[i].product_id, data) > -1) {
					$scope.products[i].block = 1;
					$scope.removeSelection($scope.products[i].product_id);
				}
			}
			$scope.selectedAll = '';
		} else {
			Notification({message: 'product.form.productBlockSuccess', templateUrl:'app/vendors/angular-ui-notification/tpl/success.tpl.html'},'success');
			for(var i = 0; i < $scope.products.length; i++) {
				if($scope.products[i].product_id == data) {
					$scope.products[i].block = 1;
					$scope.removeSelection($scope.products[i].product_id);
					break;
				}
			}
		}		
    });

    $scope.$on('product.unblock', function (event, data) {
		$scope.loader = false;
        if(Array.isArray(data)){
			Notification({message: 'product.form.productUnblockSuccessP' ,templateUrl:'app/vendors/angular-ui-notification/tpl/success.tpl.html'},'success');
			for(var i = 0; i < $scope.products.length; i++) {
				if($.inArray($scope.products[i].product_id, data) > -1) {
					$scope.products[i].block = 0;
					$scope.removeSelection($scope.products[i].product_id);
				}
			}
			$scope.selectedAll = '';
		} else {
			Notification({message: 'product.form.productUnblockSuccess' ,templateUrl:'app/vendors/angular-ui-notification/tpl/success.tpl.html'},'success');
			for(var i = 0; i < $scope.products.length; i++) {
				if($scope.products[i].product_id == data) {
					$scope.products[i].block = 0;
					$scope.removeSelection($scope.products[i].product_id);
					break;
				}
			}
		}		
    });
	
    $scope.$on('product.pushall', function (event, skuconsumed) {
		Notification({message: 'product.form.productPushAllSuccess' ,templateUrl:'app/vendors/angular-ui-notification/tpl/success.tpl.html'},'success');
		$scope.profile.skuconsumed = skuconsumed;
		EbProductService.list().then(function (data) {
			$scope.loader = false;
			$scope.products = data;
            $scope.selection = [];
        });
    });	

    $scope.$on('product.validationError', function(event,errorData) {
		$scope.loader = false;		
		EbProductService.list().then(function (data) {
			//$scope.products = data;
            $scope.selection = [];
			$scope.selectedAll= '';
        });
		Notification({message: errorData, templateUrl:'app/vendors/angular-ui-notification/tpl/validation.tpl.html'}, 'warning');
		$scope.isDisabled = false;
	});
});