"use strict";

var app = angular.module('ng-laravel', ['ui.select']);
app.controller('SettingsCtrl', function($scope, SettingsService, resolvedItems, $http, $rootScope, $translatePartialLoader, Notification, trans, $state, $timeout){
			
    $scope.settings = resolvedItems;
	$scope.publishedList = [{id:'1',value:'Published'},{id:'0',value:'Hidden'}];
	$scope.fulfilment_serviceList = [{id:'manual',value:'Manual'},{id:'amazon_marketplace_web',value:'amazon_marketplace_web'}];
	$scope.inventory_policyList = [{id:'shopify',value:'Shopify tracks this product\'s inventory'},{id:'',value:'Don\'t track inventory'}];
	$scope.product_importList = [{id:'1',value:'Enable'},{id:'0',value:'Disable'}];
	$scope.inventory_syncList = [{id:'1',value:'Enable'},{id:'0',value:'Disable'}];
	$scope.price_syncList = [{id:'1',value:'Enable'},{id:'0',value:'Disable'}];
	
	/*SettingsService.list().then(function(data){
		$scope.settings = data;
		$scope.isDisabled = true;
    });*/
	
    $scope.update = function(settings) {
        $scope.isDisabled = true;
		$scope.tmp = angular.isObject(settings) ? angular.toJson(settings) : settings;
        SettingsService.update($scope.tmp);
    };  

    /********************************************************
     * Event Listeners
     * Task event listener related to TaskCreateCtrl
     ********************************************************/
    // Create task event listener
    $scope.$on('settings.update', function() {
		Notification({message: 'settings.form.settingsUpdateSuccess' ,templateUrl:'app/vendors/angular-ui-notification/tpl/success.tpl.html'},'success');
		$scope.isDisabled = false;
    });

    //Validation error in create task event listener
    $scope.$on('settings.validationError', function(event,errorData) {
        Notification({message: errorData ,templateUrl:'app/vendors/angular-ui-notification/tpl/validation.tpl.html'},'warning');
        $scope.isDisabled = false;
    });

});