import React, { memo, useRef, useEffect } from 'react';
import { classNames } from '../../../../utilities/css.js';
import styles from '../../Tabs.css.js';
import { UnstyledLink } from '../../../UnstyledLink/UnstyledLink.js';

const Item = /*#__PURE__*/memo(function Item({
  id,
  focused,
  children,
  url,
  accessibilityLabel,
  onClick = noop
}) {
  const focusedNode = useRef(null);
  useEffect(() => {
    const focusTarget = focusedNode.current;
    if (focusTarget && focusTarget instanceof HTMLElement && focused) {
      requestAnimationFrame(() => {
        focusTarget.focus();
      });
    }
  }, [focusedNode, focused]);
  const classname = classNames(styles.Item);
  const sharedProps = {
    id,
    ref: focusedNode,
    onClick,
    className: classname,
    'aria-selected': false,
    'aria-label': accessibilityLabel
  };
  const markup = url ? /*#__PURE__*/React.createElement(UnstyledLink, Object.assign({}, sharedProps, {
    url: url
  }), children) : /*#__PURE__*/React.createElement("button", Object.assign({}, sharedProps, {
    ref: focusedNode,
    type: "button"
  }), children);
  return /*#__PURE__*/React.createElement("li", null, markup);
});
function noop() {}

export { Item };
