<?php
	set_time_limit(0);
	require_once("includes/config.php");
	
	$conn = new mysqli($host, $username, $password, $dbname);

	// Check connection
	if ($conn->connect_error) {
		// TODO: Add some logging and email notification here
		die("Connection failed: " . $conn->connect_error);
	}
	mysqli_set_charset($conn,"utf8");
	
	define('APPLICATION_NAME', 'ECOMSHORE');
    define('APPLICATION_VERSION', '1.0');
	set_include_path(get_include_path() . PATH_SEPARATOR . 'includes/');
	function __autoload($className){		
        $filePath = str_replace('_', DIRECTORY_SEPARATOR, $className) . '.php';
        $includePaths = explode(PATH_SEPARATOR, get_include_path());
        foreach($includePaths as $includePath){
            if(file_exists($includePath . DIRECTORY_SEPARATOR . $filePath)){
                require_once $filePath;
                return;
            }
        }
    }	

	function getMWSProductsServiceURL($marketplace_id){
		$mwsServiceUrlArr = array("A2EUQ1WTGCTBG2" => "https://mws.amazonservices.com/Products/2011-10-01", "A1AM78C64UM0Y8" => "https://mws.amazonservices.com/Products/2011-10-01", "ATVPDKIKX0DER" => "https://mws.amazonservices.com/Products/2011-10-01", "A1PA6795UKMFR9" => "https://mws-eu.amazonservices.com/Products/2011-10-01", "A1RKKUPIHCS9HS" => "https://mws-eu.amazonservices.com/Products/2011-10-01", "A13V1IB3VIYZZH" => "https://mws-eu.amazonservices.com/Products/2011-10-01", "APJ6JRA9NG5V4" => "https://mws-eu.amazonservices.com/Products/2011-10-01", "A1F83G8C2ARO7P" => "https://mws-eu.amazonservices.com/Products/2011-10-01", "A21TJRUUN4KGV" => "https://mws.amazonservices.in/Products/2011-10-01", "AAHKV2X7AFYLW" => "https://mws.amazonservices.com.cn/Products/2011-10-01", "A1VC38T7YXB528" => "https://mws.amazonservices.jp/Products/2011-10-01");
		if(array_key_exists($marketplace_id, $mwsServiceUrlArr)){
			return $mwsServiceUrlArr[$marketplace_id];
		} else {
			return false;
		}		
	}

	$errmsg = '';
	if(isset($_POST['merchant_id'])){
		$merchant_id = trim($_POST['merchant_id']);
		$marketplace_id = trim($_POST['marketplace_id']);
		$mws_token = trim($_POST['auth_token']);
		$access_key_id = 'AKIAJZRMMQV2HEQQGOYA';
    	$secret_access_key = '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';
        if($marketplace_id == 'A21TJRUUN4KGV' || $marketplace_id == 'A1AM78C64UM0Y8' || $marketplace_id == 'A1F83G8C2ARO7P' || $marketplace_id == 'A1PA6795UKMFR9' || $marketplace_id == 'A1RKKUPIHCS9HS' || $marketplace_id == 'A13V1IB3VIYZZH' || $marketplace_id == 'APJ6JRA9NG5V4'){
	        $access_key_id = 'AKIAISIE2BRRDNZACYKQ';
	    	$secret_access_key = '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';
    	}
		$serviceUrl = getMWSProductsServiceURL($marketplace_id);
		$config = array (
			'ServiceURL' => $serviceUrl,
			'ProxyHost' => null,
			'ProxyPort' => -1,
			'ProxyUsername' => null,
			'ProxyPassword' => null,
			'MaxErrorRetry' => 3,
		);
	
		$service = new MarketplaceWebServiceProducts_Client(
			$access_key_id,
			$secret_access_key,
			APPLICATION_NAME,
			APPLICATION_VERSION,
			$config);

		$request = new MarketplaceWebServiceProducts_Model_GetMatchingProductRequest();
		$request->setSellerId($merchant_id);
		$asin = new MarketplaceWebServiceProducts_Model_ASINListType();
		$asin->setASIN(array("B06XP7FC78"));//
		$request->setMarketplaceId($marketplace_id);					
		$request->setASINList($asin);
		$request->setMWSAuthToken($mws_token);
		
		try {
			$response = $service->GetMatchingProduct($request);	
			$errmsg = 'Valid Keys!';
		} catch (MarketplaceWebServiceProducts_Exception $ex) {
			$errmsg = 'Invalid Keys!';
		}
	}
?>
<!doctype html>
	<html lang="en">
		<head>
		<meta charset="UTF-8">
		<title>Validate Keys</title>
		<meta name="viewport" content="width=device-width, initial-scale=1.0">
		<link href="//maxcdn.bootstrapcdn.com/bootstrap/4.1.1/css/bootstrap.min.css" rel="stylesheet" id="bootstrap-css">
		<script src="//maxcdn.bootstrapcdn.com/bootstrap/4.1.1/js/bootstrap.min.js"></script>
		<script src="//cdnjs.cloudflare.com/ajax/libs/jquery/3.2.1/jquery.min.js"></script>
	</head>
	<body>
		<div class="row">
			<div class="col-md-6" style="padding=0.5em;">
				<div class="card">
					<div class="card-body">
						<h2 class="card-title">Enter your MWS keys below to validate</h2>
						<?php
							if($errmsg != ''){	
						?>
						<div class="form-group">
							<h2><strong><?=$errmsg?></h2>
						</div>
						<?php
							}
						?>
						<form name="myform" action="validatekeys.php" method="post">
							<div class="form-group">
								<div class="form-group">
									<label for="shop" class="col-form-label">Seller ID / Merchant ID</label>
									<input type="text" class="form-control" id="merchant_id" name="merchant_id" placeholder="" required>
								</div>
								<div class="form-group">
									<label for="shop" class="col-form-label">MWS Auth Token</label>
									<input type="text" class="form-control" id="auth_token" name="auth_token" placeholder="" required>
								</div>
								<label for="appname" class="col-form-label">Choose Amazon Marketplace</label>
								<select class="form-control" id="marketplace_id" name="marketplace_id">
									<option value="ATVPDKIKX0DER">amazon.com</option>
									<option value="A2EUQ1WTGCTBG2">amazon.ca</option>
									<option value="A1F83G8C2ARO7P">amazon.co.uk</option>
								</select>                            
							</div>							
							<div class="form-group">
								<button type="submit" class="btn btn-primary btn-lg btn-block">Check Now!</button>
							</div>
						</form>
                    </div>
                </div>
            </div>                
            <div class="col-md-6"></div>
        </div>
	</body>
</html>