const metadata = {
  "AdjustIcon": {
    "id": "AdjustIcon",
    "name": "Adjust",
    "description": "Used to denote that an adjustment can be made.",
    "keywords": [
      "adjust",
      "adjustment",
      "controls",
      "dials"
    ]
  },
  "AffiliateIcon": {
    "id": "AffiliateIcon",
    "name": "Affiliate",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "AirplaneIcon": {
    "id": "AirplaneIcon",
    "name": "Airplane",
    "description": "Used as a navigation item in our emoji picker for the transport category.",
    "keywords": [
      "transport",
      "plane",
      "airplane",
      "emoji",
      "navigation"
    ]
  },
  "AlertBubbleIcon": {
    "id": "AlertBubbleIcon",
    "name": "Alert bubble",
    "description": "Used to represent a dispute or important conversation or notification.",
    "keywords": [
      "dispute",
      "claim"
    ]
  },
  "AlertCircleIcon": {
    "id": "AlertCircleIcon",
    "name": "Alert circle",
    "description": "Used to alert merchants of a warning message.",
    "keywords": [
      "attention",
      "alert",
      "warning",
      "exclamation",
      "bang",
      "circle",
      "round"
    ]
  },
  "AlertDiamondIcon": {
    "id": "AlertDiamondIcon",
    "name": "Alert diamond",
    "description": "Used to alert merchants of a critical error.",
    "keywords": [
      "alert",
      "attention",
      "critical",
      "diamond",
      "error",
      "exclamation",
      "bang"
    ]
  },
  "AlertTriangleIcon": {
    "id": "AlertTriangleIcon",
    "name": "Alert triangle",
    "description": "Used to represent risk associated with orders.",
    "keywords": [
      "risk",
      "warning",
      "triangle",
      "alert"
    ]
  },
  "AppExtensionIcon": {
    "id": "AppExtensionIcon",
    "name": "App extension",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "AppsFilledIcon": {
    "id": "AppsFilledIcon",
    "name": "Apps filled",
    "description": "Used to represent partner apps.",
    "keywords": [
      "add",
      "apps",
      "applications",
      "blocks",
      "embedded",
      "extensions"
    ]
  },
  "AppsIcon": {
    "id": "AppsIcon",
    "name": "Apps",
    "description": "Used to represent partner apps.",
    "keywords": [
      "add",
      "apps",
      "applications",
      "blocks",
      "embedded",
      "extensions"
    ]
  },
  "ArchiveIcon": {
    "id": "ArchiveIcon",
    "name": "Archive",
    "description": "Used to denote the action of archiving an item or resource.",
    "keywords": [
      "archive",
      "box"
    ]
  },
  "ArrowDiagonalIcon": {
    "id": "ArrowDiagonalIcon",
    "name": "Arrow diagonal",
    "description": "Used to denote that associated text will be inserted",
    "keywords": [
      "arrow",
      "diagonal"
    ]
  },
  "ArrowDownIcon": {
    "id": "ArrowDownIcon",
    "name": "Arrow down",
    "description": "Used to represent a negative trend when looking at analytical information.",
    "keywords": [
      "arrow",
      "down"
    ]
  },
  "ArrowLeftIcon": {
    "id": "ArrowLeftIcon",
    "name": "Arrow left",
    "description": "Used to represent backwards navigation.",
    "keywords": [
      "back",
      "navigation"
    ]
  },
  "ArrowRightIcon": {
    "id": "ArrowRightIcon",
    "name": "Arrow right",
    "description": "Used to indicate that merchants will be directed to the next page.",
    "keywords": [
      "arrow",
      "right",
      "next"
    ]
  },
  "ArrowUpIcon": {
    "id": "ArrowUpIcon",
    "name": "Arrow up",
    "description": "Used to represent a positive trend when looking at analytical information.",
    "keywords": [
      "arrow",
      "up"
    ]
  },
  "ArrowsInHorizontalIcon": {
    "id": "ArrowsInHorizontalIcon",
    "name": "Arrows in horizontal",
    "description": "Action | Used when a merchant simplifies text using AI.",
    "keywords": [
      "simplify",
      "shorten",
      "reduce",
      "summarize"
    ]
  },
  "ArrowsOutHorizontalFilledIcon": {
    "id": "ArrowsOutHorizontalFilledIcon",
    "name": "Arrows out horizontal filled",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "ArrowsOutHorizontalIcon": {
    "id": "ArrowsOutHorizontalIcon",
    "name": "Arrows out horizontal",
    "description": "Action | Used when a merchant extends or expands text using AI.",
    "keywords": [
      "extend",
      "expand",
      "lengthen"
    ]
  },
  "AtmWithdrawalIcon": {
    "id": "AtmWithdrawalIcon",
    "name": "ATM withdrawal",
    "description": "Used to direct merchants to details about an ATM withdrawal",
    "keywords": [
      "finances",
      "financial accounts",
      "transactions"
    ]
  },
  "AttachmentFilledIcon": {
    "id": "AttachmentFilledIcon",
    "name": "Attachment filled",
    "description": "Used to represent an attachment.",
    "keywords": [
      "attachment",
      "paper clip",
      "files"
    ]
  },
  "AttachmentIcon": {
    "id": "AttachmentIcon",
    "name": "Attachment",
    "description": "Used to represent an attachment.",
    "keywords": [
      "attachment",
      "paper clip",
      "files"
    ]
  },
  "AutomationFilledIcon": {
    "id": "AutomationFilledIcon",
    "name": "Automation filled",
    "description": "Used to represent automation, or a task that can be automated.",
    "keywords": [
      "automation",
      "cog",
      "automated",
      "gear"
    ]
  },
  "AutomationIcon": {
    "id": "AutomationIcon",
    "name": "Automation",
    "description": "Used to represent automation, or a task that can be automated.",
    "keywords": [
      "automation",
      "cog",
      "automated",
      "gear"
    ]
  },
  "BackspaceIcon": {
    "id": "BackspaceIcon",
    "name": "Backspace",
    "description": "Used to represent backspace on a mobile keyboard.",
    "keywords": [
      "backspace",
      "x",
      "delete"
    ]
  },
  "BankFilledIcon": {
    "id": "BankFilledIcon",
    "name": "Bank filled",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "BankIcon": {
    "id": "BankIcon",
    "name": "Bank",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "BarcodeIcon": {
    "id": "BarcodeIcon",
    "name": "Barcode",
    "description": "Used to represent a barcode.",
    "keywords": [
      "barcode",
      "scanner"
    ]
  },
  "BillFilledIcon": {
    "id": "BillFilledIcon",
    "name": "Bill filled",
    "description": "User to represent Bill Pay, or a receipt.",
    "keywords": [
      "Invoice",
      "Bill",
      "Payment",
      "Receipt",
      "Purchase",
      "Transaction",
      "Proof",
      "Expense",
      "Statement"
    ]
  },
  "BillIcon": {
    "id": "BillIcon",
    "name": "Bill",
    "description": "User to represent Bill Pay, or a receipt.",
    "keywords": [
      "Invoice",
      "Bill",
      "Payment",
      "Receipt",
      "Purchase",
      "Transaction",
      "Proof",
      "Expense",
      "Statement"
    ]
  },
  "BlankFilledIcon": {
    "id": "BlankFilledIcon",
    "name": "Blank Filled",
    "description": "Represents the absence of an icon",
    "keywords": [
      "Empty",
      "Undefined",
      null
    ]
  },
  "BlankIcon": {
    "id": "BlankIcon",
    "name": "Blank",
    "description": "Represents the absence of an icon",
    "keywords": [
      "Empty",
      "Undefined",
      null
    ]
  },
  "BlogIcon": {
    "id": "BlogIcon",
    "name": "Blog",
    "description": "Used to represent a blog post, or something being written.",
    "keywords": [
      "author",
      "blog",
      "pen",
      "pencil"
    ]
  },
  "BookIcon": {
    "id": "BookIcon",
    "name": "Book",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "BookOpenIcon": {
    "id": "BookOpenIcon",
    "name": "Book open",
    "description": "Used to represent a book, dictionary or thesaurus.",
    "keywords": [
      "book",
      "thesaurus",
      "dictionary"
    ]
  },
  "BugIcon": {
    "id": "BugIcon",
    "name": "Bug",
    "description": "Used to represent a bug in code.",
    "keywords": [
      "bug",
      "insect"
    ]
  },
  "BulletIcon": {
    "id": "BulletIcon",
    "name": "Bullet",
    "description": "Used for bulleted lists",
    "keywords": [
      "Bullet",
      "List"
    ]
  },
  "ButtonIcon": {
    "id": "ButtonIcon",
    "name": "Button",
    "description": "Used to represent a button block appearing as a sub-element of a section, page or layout.",
    "keywords": [
      "button",
      "press",
      "click",
      "buy button",
      "block"
    ]
  },
  "ButtonPressIcon": {
    "id": "ButtonPressIcon",
    "name": "Button press",
    "description": "Used to represent our Buy Button.",
    "keywords": [
      "button",
      "buy button",
      "press"
    ]
  },
  "CalculatorIcon": {
    "id": "CalculatorIcon",
    "name": "Calculator",
    "description": "Used to represent a handheld credit card reader.",
    "keywords": [
      "credit card",
      "moneris",
      "payment"
    ]
  },
  "CalendarCheckIcon": {
    "id": "CalendarCheckIcon",
    "name": "Calendar check",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "CalendarIcon": {
    "id": "CalendarIcon",
    "name": "Calendar",
    "description": "Used to denote the action of opening a date picker.",
    "keywords": [
      "calendar",
      "date",
      "time",
      "month",
      "year",
      "day"
    ]
  },
  "CalendarTimeIcon": {
    "id": "CalendarTimeIcon",
    "name": "Calendar time",
    "description": "Used to denote the action of opening a date picker with time",
    "keywords": [
      "calendar",
      "date",
      "time",
      "month",
      "year",
      "day"
    ]
  },
  "CameraFlipIcon": {
    "id": "CameraFlipIcon",
    "name": "Camera flip",
    "description": "Used to represent an action to flip a mobile phone camera.",
    "keywords": [
      "camera",
      "flip",
      "selfie"
    ]
  },
  "CameraIcon": {
    "id": "CameraIcon",
    "name": "Camera",
    "description": "Used to represent a camera.",
    "keywords": [
      "camera",
      "photo"
    ]
  },
  "CaretDownIcon": {
    "id": "CaretDownIcon",
    "name": "Caret down",
    "description": "Used to represent there is dropdown content",
    "keywords": [
      "dropdown",
      "select"
    ]
  },
  "CaretUpIcon": {
    "id": "CaretUpIcon",
    "name": "Caret up",
    "description": "Used to denote the action of contracting a section to hide additional content, like an accordion. Also used to represent sorting order.",
    "keywords": [
      "caret",
      "up",
      "close"
    ]
  },
  "CartAbandonedFilledIcon": {
    "id": "CartAbandonedFilledIcon",
    "name": "Cart abandoned filled",
    "description": "Used to represent a prospective purchase that a buyer didn’t complete.",
    "keywords": [
      "orders",
      "sales",
      "funnel"
    ]
  },
  "CartAbandonedIcon": {
    "id": "CartAbandonedIcon",
    "name": "Cart abandoned",
    "description": "Used to represent a prospective purchase that a buyer didn’t complete.",
    "keywords": [
      "orders",
      "sales",
      "funnel"
    ]
  },
  "CartDiscountIcon": {
    "id": "CartDiscountIcon",
    "name": "Cart discount",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "CartDownFilledIcon": {
    "id": "CartDownFilledIcon",
    "name": "Cart down filled",
    "description": "Used to represent saving the contents of a shopping cart.",
    "keywords": [
      "cart",
      "checkout"
    ]
  },
  "CartDownIcon": {
    "id": "CartDownIcon",
    "name": "Cart down",
    "description": "Used to represent saving the contents of a shopping cart.",
    "keywords": [
      "cart",
      "checkout"
    ]
  },
  "CartFilledIcon": {
    "id": "CartFilledIcon",
    "name": "Cart filled",
    "description": "Used to represent a shopping cart.",
    "keywords": [
      "cart",
      "checkout",
      "shopping"
    ]
  },
  "CartIcon": {
    "id": "CartIcon",
    "name": "Cart",
    "description": "Used to represent a shopping cart.",
    "keywords": [
      "checkout",
      "cart",
      "shopping"
    ]
  },
  "CartSaleIcon": {
    "id": "CartSaleIcon",
    "name": "Cart sale",
    "description": "Used to represent a quick checkout process or quick sale.",
    "keywords": [
      "cart",
      "checkout",
      "quick",
      "sale"
    ]
  },
  "CartUpIcon": {
    "id": "CartUpIcon",
    "name": "Cart up",
    "description": "Used to represent retrieving the contents of saved shopping cart.",
    "keywords": [
      "cart",
      "checkout"
    ]
  },
  "CashDollarFilledIcon": {
    "id": "CashDollarFilledIcon",
    "name": "Cash dollar filled",
    "description": "Used to represent Dollar currency.",
    "keywords": [
      "currency",
      "money"
    ]
  },
  "CashDollarIcon": {
    "id": "CashDollarIcon",
    "name": "Cash dollar",
    "description": "Used to represent Dollar currency.",
    "keywords": [
      "currency",
      "money"
    ]
  },
  "CashEuroIcon": {
    "id": "CashEuroIcon",
    "name": "Cash euro",
    "description": "N/A",
    "keywords": [
      "currency",
      "money"
    ]
  },
  "CashPoundIcon": {
    "id": "CashPoundIcon",
    "name": "Cash pound",
    "description": "N/A",
    "keywords": [
      "currency",
      "money"
    ]
  },
  "CashRupeeIcon": {
    "id": "CashRupeeIcon",
    "name": "Cash rupee",
    "description": "N/A",
    "keywords": [
      "currency",
      "money"
    ]
  },
  "CashYenIcon": {
    "id": "CashYenIcon",
    "name": "Cash yen",
    "description": "N/A",
    "keywords": [
      "currency",
      "money"
    ]
  },
  "CatalogIcon": {
    "id": "CatalogIcon",
    "name": "Catalog",
    "description": "Represents catalogs within the Admin",
    "keywords": [
      "catalog",
      "products",
      "markets"
    ]
  },
  "CategoriesIcon": {
    "id": "CategoriesIcon",
    "name": "Categories",
    "description": "Used to represent either list of categories or files.",
    "keywords": [
      "categories",
      "files"
    ]
  },
  "ChannelsIcon": {
    "id": "ChannelsIcon",
    "name": "Channels",
    "description": "Used to represent channels, or items connected by a common root.",
    "keywords": [
      "channels",
      "connect",
      "connected",
      "path",
      "related"
    ]
  },
  "ChartCohortIcon": {
    "id": "ChartCohortIcon",
    "name": "Chart cohort",
    "description": "Used to represent a cohort analysis.",
    "keywords": [
      "analytics",
      "graph",
      "cohort analysis",
      "reports"
    ]
  },
  "ChartDonutIcon": {
    "id": "ChartDonutIcon",
    "name": "Chart donut",
    "description": "Used to represent a donut chart.",
    "keywords": [
      "analytics",
      "graph",
      "donut chart"
    ]
  },
  "ChartFunnelIcon": {
    "id": "ChartFunnelIcon",
    "name": "Chart funnel",
    "description": "Used to represent a funnel chart.",
    "keywords": [
      "analytics",
      "graph",
      "funnel chart"
    ]
  },
  "ChartHistogramFirstIcon": {
    "id": "ChartHistogramFirstIcon",
    "name": "Chart histogram first",
    "description": "Used to represent the first click marketing attribution model",
    "keywords": [
      "marketing",
      "attribution model",
      "first click"
    ]
  },
  "ChartHistogramFirstLastIcon": {
    "id": "ChartHistogramFirstLastIcon",
    "name": "Chart histogram first last",
    "description": "Used to represent the position based marketing attribution model",
    "keywords": [
      "marketing",
      "attribution model",
      "position based"
    ]
  },
  "ChartHistogramFlatIcon": {
    "id": "ChartHistogramFlatIcon",
    "name": "Chart histogram flat",
    "description": "Used to represent the linear marketing attribution model",
    "keywords": [
      "marketing",
      "attribution model",
      "linear"
    ]
  },
  "ChartHistogramFullIcon": {
    "id": "ChartHistogramFullIcon",
    "name": "Chart histogram full",
    "description": "Used to represent the any click marketing attribution model",
    "keywords": [
      "marketing",
      "attribution model",
      "any click"
    ]
  },
  "ChartHistogramGrowthIcon": {
    "id": "ChartHistogramGrowthIcon",
    "name": "Chart histogram growth",
    "description": "Used to represent the time decay marketing attribution model",
    "keywords": [
      "marketing",
      "attribution model",
      "time decay"
    ]
  },
  "ChartHistogramLastIcon": {
    "id": "ChartHistogramLastIcon",
    "name": "Chart histogram last",
    "description": "Used to represent the last click marketing attribution model",
    "keywords": [
      "marketing",
      "attribution model",
      "last click"
    ]
  },
  "ChartHistogramSecondLastIcon": {
    "id": "ChartHistogramSecondLastIcon",
    "name": "Chart histogram second last",
    "description": "Used to represent the last non-direct click marketing attribution model",
    "keywords": [
      "marketing",
      "attribution model",
      "last non-direct click"
    ]
  },
  "ChartHorizontalIcon": {
    "id": "ChartHorizontalIcon",
    "name": "Chart horizontal",
    "description": "Used to represent a horizontal bar chart.",
    "keywords": [
      "analytics",
      "graph",
      "horizontal bar chart"
    ]
  },
  "ChartLineIcon": {
    "id": "ChartLineIcon",
    "name": "Chart line",
    "description": "Used to represent a line chart.",
    "keywords": [
      "analytics",
      "graph",
      "line chart"
    ]
  },
  "ChartPopularIcon": {
    "id": "ChartPopularIcon",
    "name": "Chart popular",
    "description": "Used to represent activity or something increasing in popularity.",
    "keywords": [
      "activity",
      "graph",
      "popular"
    ]
  },
  "ChartStackedIcon": {
    "id": "ChartStackedIcon",
    "name": "Chart stacked",
    "description": "Used to represent a stacked bar chart.",
    "keywords": [
      "analytics",
      "graph",
      "stacked bar chart"
    ]
  },
  "ChartVerticalFilledIcon": {
    "id": "ChartVerticalFilledIcon",
    "name": "Chart vertical filled",
    "description": "Used to represent analytics or data.",
    "keywords": [
      "analytics",
      "data",
      "graph",
      "reports"
    ]
  },
  "ChartVerticalIcon": {
    "id": "ChartVerticalIcon",
    "name": "Chart vertical",
    "description": "Used to represent the Data driven marketing attribution model",
    "keywords": [
      "marketing",
      "attribution model",
      "data driven"
    ]
  },
  "ChatIcon": {
    "id": "ChatIcon",
    "name": "Chat",
    "description": "Used to give merchants an indication of comments attached to an order.",
    "keywords": [
      "speech",
      "bubble",
      "conversation",
      "talk",
      "chat",
      "comment"
    ]
  },
  "ChatReferralIcon": {
    "id": "ChatReferralIcon",
    "name": "Chat referral",
    "description": "Used to represent the source of a referral.",
    "keywords": [
      "referral",
      "code",
      "coupon"
    ]
  },
  "CheckCircleIcon": {
    "id": "CheckCircleIcon",
    "name": "Check circle",
    "description": "Used to represent an action to approve or confirm.",
    "keywords": [
      "good",
      "positive",
      "checkmark",
      "circle",
      "round",
      "approve"
    ]
  },
  "CheckIcon": {
    "id": "CheckIcon",
    "name": "Check",
    "description": "N/A",
    "keywords": [
      "checkmark",
      "yes",
      "ok",
      "good",
      "tick"
    ]
  },
  "CheckSmallIcon": {
    "id": "CheckSmallIcon",
    "name": "Check small",
    "description": "Used to denote the action of checking a Polaris checkbox.",
    "keywords": [
      "checkmark",
      "yes",
      "ok",
      "good",
      "passed",
      "tick"
    ]
  },
  "CheckboxIcon": {
    "id": "CheckboxIcon",
    "name": "Checkbox",
    "description": "N/A",
    "keywords": [
      "checkmark",
      "select"
    ]
  },
  "ChevronDownIcon": {
    "id": "ChevronDownIcon",
    "name": "Chevron down",
    "description": "Used to denote the action of expanding a section to reveal more content.",
    "keywords": [
      "chevron",
      "down"
    ]
  },
  "ChevronLeftIcon": {
    "id": "ChevronLeftIcon",
    "name": "Chevron left",
    "description": "Used to represent the back action commonly found in iOS.",
    "keywords": [
      "back",
      "ios",
      "navigation"
    ]
  },
  "ChevronRightIcon": {
    "id": "ChevronRightIcon",
    "name": "Chevron right",
    "description": "Used to indicate that merchants will be directed to the next item.",
    "keywords": [
      "chevron",
      "right"
    ]
  },
  "ChevronUpIcon": {
    "id": "ChevronUpIcon",
    "name": "Chevron up",
    "description": "Used to denote the action of contracting a section to hide additional content.",
    "keywords": [
      "chevron",
      "up"
    ]
  },
  "CircleChevronDownIcon": {
    "id": "CircleChevronDownIcon",
    "name": "Circle chevron down",
    "description": "Used to represent a collapsible section, or an action to navigate down.",
    "keywords": [
      "chevron",
      "down",
      "circle",
      "outline"
    ]
  },
  "CircleChevronLeftIcon": {
    "id": "CircleChevronLeftIcon",
    "name": "Circle chevron left",
    "description": "Used to represent an action to navigate back.",
    "keywords": [
      "back",
      "chevron",
      "left",
      "circle",
      "outline"
    ]
  },
  "CircleChevronRightIcon": {
    "id": "CircleChevronRightIcon",
    "name": "Circle chevron right",
    "description": "Used to help direct merchants from a item’s name in a list to the item’s show page.",
    "keywords": [
      "chevron",
      "right",
      "circle",
      "outline"
    ]
  },
  "CircleChevronUpIcon": {
    "id": "CircleChevronUpIcon",
    "name": "Circle chevron up",
    "description": "Used to represent a collapsible section, or an action to navigate up.",
    "keywords": [
      "chevron",
      "up",
      "circle",
      "outline"
    ]
  },
  "CircleDownIcon": {
    "id": "CircleDownIcon",
    "name": "Circle down",
    "description": "Used to represent downwards navigation, or that something is below it.",
    "keywords": [
      "arrow",
      "down"
    ]
  },
  "CircleLeftIcon": {
    "id": "CircleLeftIcon",
    "name": "Circle left",
    "description": "Used to represent backwards naviagation, or that something is before it.",
    "keywords": [
      "arrow",
      "back"
    ]
  },
  "CircleRightIcon": {
    "id": "CircleRightIcon",
    "name": "Circle right",
    "description": "Used to represent forwards naviagation, or that something is after it.",
    "keywords": [
      "arrow",
      "forward"
    ]
  },
  "CircleUpIcon": {
    "id": "CircleUpIcon",
    "name": "Circle up",
    "description": "Used to represent upwards naviagation, or that something is above it.",
    "keywords": [
      "arrow",
      "up"
    ]
  },
  "ClipboardCheckFilledIcon": {
    "id": "ClipboardCheckFilledIcon",
    "name": "Clipboard check filled",
    "description": "Used to represent a completed checklist.",
    "keywords": [
      "checklist",
      "complete"
    ]
  },
  "ClipboardCheckIcon": {
    "id": "ClipboardCheckIcon",
    "name": "Clipboard check",
    "description": "Used to represent a completed checklist.",
    "keywords": [
      "checklist",
      "complete"
    ]
  },
  "ClipboardChecklistIcon": {
    "id": "ClipboardChecklistIcon",
    "name": "Clipboard checklist",
    "description": "Used to represent a checklist.",
    "keywords": [
      "checklist",
      "list"
    ]
  },
  "ClipboardIcon": {
    "id": "ClipboardIcon",
    "name": "Clipboard",
    "description": "Used to represent a clipboard, usually accompanying a copy action.",
    "keywords": [
      "clipboard",
      "copy",
      "copy and paste"
    ]
  },
  "ClockIcon": {
    "id": "ClockIcon",
    "name": "Clock",
    "description": "Used to indicate time.",
    "keywords": [
      "time",
      "clock",
      "watch",
      "minute",
      "second",
      "hour",
      "stopwatch",
      "circle"
    ]
  },
  "CodeAddIcon": {
    "id": "CodeAddIcon",
    "name": "Code add",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "CodeIcon": {
    "id": "CodeIcon",
    "name": "Code",
    "description": "Used to represent an object embedded from a web resource.",
    "keywords": [
      "embed",
      "web resource",
      "web",
      "iframe"
    ]
  },
  "CollectionFeaturedIcon": {
    "id": "CollectionFeaturedIcon",
    "name": "Collection featured",
    "description": "Used to represent a featured or favorite collection.",
    "keywords": [
      "collection",
      "favorite",
      "favourite",
      "featured"
    ]
  },
  "CollectionFilledIcon": {
    "id": "CollectionFilledIcon",
    "name": "Collection filled",
    "description": "Used to represent a collection of products.",
    "keywords": [
      "collection",
      "tag",
      "tags",
      "swing"
    ]
  },
  "CollectionIcon": {
    "id": "CollectionIcon",
    "name": "Collection",
    "description": "Used to represent a collection of products.",
    "keywords": [
      "collection",
      "tag",
      "tags",
      "swing"
    ]
  },
  "CollectionListIcon": {
    "id": "CollectionListIcon",
    "name": "Collection list",
    "description": "Used to represent a list of collections.",
    "keywords": [
      "collection",
      "collections",
      "list",
      "tag",
      "tags",
      "swing"
    ]
  },
  "CollectionReferenceIcon": {
    "id": "CollectionReferenceIcon",
    "name": "Collection reference",
    "description": "Used to represent collections referenced on other resources",
    "keywords": [
      "collection",
      "reference",
      "metafields"
    ]
  },
  "ColorIcon": {
    "id": "ColorIcon",
    "name": "Color",
    "description": "Used to represent a color swatch, or palette of colors.",
    "keywords": [
      "color",
      "palette",
      "swatch"
    ]
  },
  "ColorNoneIcon": {
    "id": "ColorNoneIcon",
    "name": "Color none",
    "description": "Used to represent a lack of color, or that a color is not allowed or available.",
    "keywords": [
      "color",
      "drop",
      "droplet",
      "water",
      "strike",
      "line",
      "no",
      "crossed"
    ]
  },
  "CompassIcon": {
    "id": "CompassIcon",
    "name": "Compass",
    "description": "Used to represent a compass or navigation.",
    "keywords": [
      "compass",
      "navigation"
    ]
  },
  "ComposeIcon": {
    "id": "ComposeIcon",
    "name": "Compose",
    "description": "Used to denote the action of composing a new message.",
    "keywords": [
      "compose",
      "message",
      "write",
      "pencil",
      "pen"
    ]
  },
  "ConfettiIcon": {
    "id": "ConfettiIcon",
    "name": "Confetti",
    "description": "Used to represent a moment of celebration, or to call attention to something fun or new.",
    "keywords": [
      "celebrate",
      "confetti",
      "tada"
    ]
  },
  "ConnectIcon": {
    "id": "ConnectIcon",
    "name": "Connect",
    "description": "Used to represent a connection between two items or resources.",
    "keywords": [
      "connect",
      "connected",
      "path",
      "join",
      "related"
    ]
  },
  "ContentFilledIcon": {
    "id": "ContentFilledIcon",
    "name": "Content filled",
    "description": "Used to represent content.",
    "keywords": [
      "content",
      "files",
      "metaobjects"
    ]
  },
  "ContentIcon": {
    "id": "ContentIcon",
    "name": "Content",
    "description": "Used to represent content.",
    "keywords": [
      "content",
      "files",
      "metaobjects"
    ]
  },
  "ContractFilledIcon": {
    "id": "ContractFilledIcon",
    "name": "Contract filled",
    "description": "N/A",
    "keywords": [
      "legal",
      "page",
      "scroll",
      "paper"
    ]
  },
  "ContractIcon": {
    "id": "ContractIcon",
    "name": "Contract",
    "description": "N/A",
    "keywords": [
      "legal",
      "page",
      "scroll",
      "paper"
    ]
  },
  "CornerPillIcon": {
    "id": "CornerPillIcon",
    "name": "Corner pill",
    "description": "Used to represent the corner shape of a button.",
    "keywords": [
      "button radius",
      "button corner",
      "pill",
      "email",
      "editor"
    ]
  },
  "CornerRoundIcon": {
    "id": "CornerRoundIcon",
    "name": "Corner round",
    "description": "Used to represent the corner shape of a button.",
    "keywords": [
      "button radius",
      "button corner",
      "rounded",
      "email",
      "editor"
    ]
  },
  "CornerSquareIcon": {
    "id": "CornerSquareIcon",
    "name": "Corner square",
    "description": "Used to represent the corner shape of a button.",
    "keywords": [
      "button radius",
      "button corner",
      "square",
      "email",
      "editor"
    ]
  },
  "CreditCardCancelIcon": {
    "id": "CreditCardCancelIcon",
    "name": "Credit card cancel",
    "description": "Used to represent a cancellation related to a charge",
    "keywords": [
      "card",
      "credit card",
      "payment",
      "credit card cancel"
    ]
  },
  "CreditCardIcon": {
    "id": "CreditCardIcon",
    "name": "Credit card",
    "description": "Used to represent a credit card.",
    "keywords": [
      "card",
      "credit card",
      "payment"
    ]
  },
  "CreditCardPercentIcon": {
    "id": "CreditCardPercentIcon",
    "name": "Credit card percent",
    "description": "Used to represent a credit card interest.",
    "keywords": [
      "card",
      "credit card",
      "interest",
      "payment"
    ]
  },
  "CreditCardReaderChipIcon": {
    "id": "CreditCardReaderChipIcon",
    "name": "Credit card reader chip",
    "description": "Used to represent a card chip reader.",
    "keywords": [
      "credit card",
      "payment"
    ]
  },
  "CreditCardReaderIcon": {
    "id": "CreditCardReaderIcon",
    "name": "Credit card reader",
    "description": "Used to represent the Shopify Tap and Chip reader.",
    "keywords": [
      "chip and swipe",
      "card reader",
      "POS"
    ]
  },
  "CreditCardReaderTapIcon": {
    "id": "CreditCardReaderTapIcon",
    "name": "Credit card reader tap",
    "description": "Used to represent the Shopify Tap and Chip reader.",
    "keywords": [
      "tap and chip",
      "card reader",
      "POS"
    ]
  },
  "CreditCardSecureIcon": {
    "id": "CreditCardSecureIcon",
    "name": "Credit card secure",
    "description": "Used to represent a secured credit card.",
    "keywords": [
      "card",
      "credit card",
      "payment",
      "secure"
    ]
  },
  "CreditCardTapChipIcon": {
    "id": "CreditCardTapChipIcon",
    "name": "Credit card tap chip",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "CropIcon": {
    "id": "CropIcon",
    "name": "Crop",
    "description": "Used in media editing for croping an image.",
    "keywords": [
      "crop"
    ]
  },
  "CurrencyConvertIcon": {
    "id": "CurrencyConvertIcon",
    "name": "Currency convert",
    "description": "Used to represent currency conversion.",
    "keywords": [
      "currency",
      "exchange",
      "forex"
    ]
  },
  "CursorBannerIcon": {
    "id": "CursorBannerIcon",
    "name": "Cursor banner",
    "description": "Represents a cookie/permissions banner",
    "keywords": [
      "Cursor",
      "Cookie",
      "Permissions",
      "Banner",
      "Consent",
      "Agreement"
    ]
  },
  "CursorFilledIcon": {
    "id": "CursorFilledIcon",
    "name": "Cursor filled",
    "description": "Used to represent a user clicking, or interacting with something.",
    "keywords": [
      "click",
      "cursor"
    ]
  },
  "CursorIcon": {
    "id": "CursorIcon",
    "name": "Cursor",
    "description": "Used to represent a user clicking, or interacting with something.",
    "keywords": [
      "click",
      "cursor"
    ]
  },
  "CursorOptionIcon": {
    "id": "CursorOptionIcon",
    "name": "Cursor option",
    "description": "Represents the act of selecting options",
    "keywords": [
      "Selection",
      "Options",
      "Choices",
      "Settings",
      "Preferences"
    ]
  },
  "DataPresentationIcon": {
    "id": "DataPresentationIcon",
    "name": "Data presentation",
    "description": "Used to represent a presentation or graph.",
    "keywords": [
      "graph",
      "presentation"
    ]
  },
  "DataTableIcon": {
    "id": "DataTableIcon",
    "name": "Data table",
    "description": "Used to represent a data table.",
    "keywords": [
      "analytics",
      "data table"
    ]
  },
  "DatabaseAddIcon": {
    "id": "DatabaseAddIcon",
    "name": "Database add",
    "description": "Used to represent adding, inserting, or connecting a dynamic source.",
    "keywords": [
      "dynamic source",
      "data source",
      "dynamic",
      "data",
      "datasource",
      "dynamicsource",
      "dynamic data",
      "add data source",
      "add dynamic source",
      "add",
      "insert",
      "insert data source",
      "insert dynamic source",
      "db",
      "database"
    ]
  },
  "DatabaseConnectIcon": {
    "id": "DatabaseConnectIcon",
    "name": "Database",
    "description": "Used to represent a dynamic source",
    "keywords": [
      "dynamic source",
      "data source",
      "dynamic",
      "data",
      "datasource",
      "dynamicsource",
      "db",
      "database"
    ]
  },
  "DatabaseIcon": {
    "id": "DatabaseIcon",
    "name": "Database",
    "description": "Used to represent a dynamic source",
    "keywords": [
      "dynamic source",
      "data source",
      "dynamic",
      "data",
      "datasource",
      "dynamicsource",
      "db",
      "database"
    ]
  },
  "DeleteIcon": {
    "id": "DeleteIcon",
    "name": "Delete",
    "description": "Used to denote a destructive action to delete an item.",
    "keywords": [
      "delete",
      "remove",
      "trash",
      "garbage",
      "get rid of"
    ]
  },
  "DeliveryFilledIcon": {
    "id": "DeliveryFilledIcon",
    "name": "Delivery filled",
    "description": "Used to represent shipping-related events or actions such as shipping labels or tracking information.",
    "keywords": [
      "shipping",
      "shipment",
      "carrier",
      "ship",
      "fulfillment",
      "fulfilment",
      "label",
      "tracking",
      "truck"
    ]
  },
  "DeliveryIcon": {
    "id": "DeliveryIcon",
    "name": "Delivery",
    "description": "Used to represent shipping-related events or actions such as shipping labels or tracking information.",
    "keywords": [
      "shipping",
      "shipment",
      "carrier",
      "ship",
      "fulfillment",
      "fulfilment",
      "label",
      "tracking",
      "truck"
    ]
  },
  "DesktopIcon": {
    "id": "DesktopIcon",
    "name": "Desktop",
    "description": "Used to represent a large screen or desktop computer.",
    "keywords": [
      "desktop",
      "screen"
    ]
  },
  "DisabledIcon": {
    "id": "DisabledIcon",
    "name": "Disabled",
    "description": "Used to represent an item or resource that is disabled, or an action that is not allowed.",
    "keywords": [
      "blocked",
      "disabled"
    ]
  },
  "DiscountCodeIcon": {
    "id": "DiscountCodeIcon",
    "name": "Discount code",
    "description": "Used to represent a discount code or coupon.",
    "keywords": [
      "coupon",
      "discount"
    ]
  },
  "DiscountFilledIcon": {
    "id": "DiscountFilledIcon",
    "name": "Discount filled",
    "description": "Used to represent a discount.",
    "keywords": [
      "discount"
    ]
  },
  "DiscountIcon": {
    "id": "DiscountIcon",
    "name": "Discount",
    "description": "Used to represent a discount.",
    "keywords": [
      "discount"
    ]
  },
  "DnsSettingsIcon": {
    "id": "DnsSettingsIcon",
    "name": "Dns settings",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "DockFloatingIcon": {
    "id": "DockFloatingIcon",
    "name": "Dock floating",
    "description": "Used to represent a window that is floating in the bottom right of the admin",
    "keywords": [
      "magic",
      "chat",
      "window",
      "floating",
      "layout",
      "right"
    ]
  },
  "DockSideIcon": {
    "id": "DockSideIcon",
    "name": "Dock side",
    "description": "Used to represent a window that is docked to the right side of the admin",
    "keywords": [
      "magic",
      "chat",
      "window",
      "docked",
      "layout",
      "right"
    ]
  },
  "DomainFilledIcon": {
    "id": "DomainFilledIcon",
    "name": "Domain filled",
    "description": "Used to represent a discount.",
    "keywords": [
      "Domain",
      "Web",
      "Website",
      "Digital"
    ]
  },
  "DomainIcon": {
    "id": "DomainIcon",
    "name": "Domain",
    "description": "N/A",
    "keywords": [
      "Domain",
      "Web",
      "Website",
      "Digital"
    ]
  },
  "DomainLandingPageIcon": {
    "id": "DomainLandingPageIcon",
    "name": "Domain landing page",
    "description": "Used to represent a landing page or adding an item or resource to a page.",
    "keywords": [
      "landing",
      "landing page",
      "incoming"
    ]
  },
  "DomainNewIcon": {
    "id": "DomainNewIcon",
    "name": "Domain new",
    "description": "N/A",
    "keywords": [
      "Register",
      "Add",
      "Domain",
      "Web",
      "Create",
      "Website",
      "Digital"
    ]
  },
  "DomainRedirectIcon": {
    "id": "DomainRedirectIcon",
    "name": "Domain redirect",
    "description": "Used to represent a redirect domain.",
    "keywords": [
      "Domain",
      "Redirect"
    ]
  },
  "DragDropIcon": {
    "id": "DragDropIcon",
    "name": "Drag drop",
    "description": "Used to represent drag and drop.",
    "keywords": [
      "drag",
      "drop",
      "files",
      "copy"
    ]
  },
  "DragHandleIcon": {
    "id": "DragHandleIcon",
    "name": "Drag handle",
    "description": "Used to represent drag handles.",
    "keywords": [
      "drag",
      "draggable",
      "grab",
      "reposition"
    ]
  },
  "DuplicateIcon": {
    "id": "DuplicateIcon",
    "name": "Duplicate",
    "description": "Used to denote the action of duplicating orders, to save as (reports), and to copy content to clipboard like an address.",
    "keywords": [
      "duplicate",
      "copy",
      "make another one",
      "two",
      "duo"
    ]
  },
  "EditIcon": {
    "id": "EditIcon",
    "name": "Edit",
    "description": "Used to represent the action of editing or modifying information.",
    "keywords": [
      "pencil",
      "pen",
      "paper",
      "edit",
      "page",
      "change"
    ]
  },
  "EmailFollowUpIcon": {
    "id": "EmailFollowUpIcon",
    "name": "Email follow up",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "EmailIcon": {
    "id": "EmailIcon",
    "name": "Email",
    "description": "Used to represent an email or letter.",
    "keywords": [
      "email",
      "invite",
      "letter"
    ]
  },
  "EmailNewsletterIcon": {
    "id": "EmailNewsletterIcon",
    "name": "Email newsletter",
    "description": "Used to represent an opened email or letter.",
    "keywords": [
      "email",
      "letter",
      "opened",
      "read"
    ]
  },
  "EnterIcon": {
    "id": "EnterIcon",
    "name": "Enter",
    "description": "Used to represent the action of authenticating, gaining access or log in",
    "keywords": [
      "authenticating",
      "access",
      "log in",
      "enter",
      "sign in"
    ]
  },
  "EnvelopeIcon": {
    "id": "EnvelopeIcon",
    "name": "Envelope",
    "description": "Used to represent an envelope that merchants can use to ship orders to their customers.",
    "keywords": [
      "shipping",
      "packaging",
      "envelope"
    ]
  },
  "EnvelopeSoftPackIcon": {
    "id": "EnvelopeSoftPackIcon",
    "name": "Envelope soft pack",
    "description": "Used to represent a soft pack envelope (or bubble mailer) that merchants can use to ship orders to their customers.",
    "keywords": [
      "shipping",
      "packaging",
      "envelope",
      "bubble",
      "mailer",
      "bubblewrap",
      "padded"
    ]
  },
  "ExchangeIcon": {
    "id": "ExchangeIcon",
    "name": "Exchange",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "ExitIcon": {
    "id": "ExitIcon",
    "name": "Exit",
    "description": "Used to denote the action of logging out of Shopify.",
    "keywords": [
      "logout",
      "log-out",
      "sign-out",
      "sign-off",
      "signoff",
      "disconnect",
      "exit",
      "quit"
    ]
  },
  "ExportIcon": {
    "id": "ExportIcon",
    "name": "Export",
    "description": "Used to denote the action of exporting content.",
    "keywords": [
      "export",
      "take out",
      "resource"
    ]
  },
  "ExternalIcon": {
    "id": "ExternalIcon",
    "name": "External",
    "description": "Used to denote the action of navigating to an external resource.",
    "keywords": [
      "external",
      "outside",
      "not here"
    ]
  },
  "ExternalSmallIcon": {
    "id": "ExternalSmallIcon",
    "name": "External small",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "EyeCheckMarkIcon": {
    "id": "EyeCheckMarkIcon",
    "name": "Eye check mark",
    "description": "Used to represent accessibility information or features.",
    "keywords": [
      "accessibility",
      "usability",
      "a11y",
      "disability",
      "equal access",
      "universal design",
      "eye"
    ]
  },
  "EyeDropperIcon": {
    "id": "EyeDropperIcon",
    "name": "Eye dropper",
    "description": "Used to represent a color picker.",
    "keywords": [
      "color",
      "color picker",
      "eye dropper"
    ]
  },
  "EyeFirstIcon": {
    "id": "EyeFirstIcon",
    "name": "Eye first",
    "description": "Used to represent a first view or visitor.",
    "keywords": [
      "first",
      "view",
      "visitor"
    ]
  },
  "EyeglassesIcon": {
    "id": "EyeglassesIcon",
    "name": "Eyeglasses",
    "description": "Used to represent resources to learn more about a topic or feature.",
    "keywords": [
      "resources",
      "learn more",
      "glasses",
      "research"
    ]
  },
  "FaviconIcon": {
    "id": "FaviconIcon",
    "name": "Favicon",
    "description": "Used to represent a favicon.",
    "keywords": [
      "favicon",
      "ico",
      "icon"
    ]
  },
  "FileFilledIcon": {
    "id": "FileFilledIcon",
    "name": "File filled",
    "description": "Used to denote a file such as images, video, pdfs, etc.",
    "keywords": [
      "file",
      "images",
      "video"
    ]
  },
  "FileIcon": {
    "id": "FileIcon",
    "name": "File",
    "description": "Used to denote a file such as images, video, pdfs, etc.",
    "keywords": [
      "file",
      "images",
      "video"
    ]
  },
  "FilterIcon": {
    "id": "FilterIcon",
    "name": "Filter",
    "description": "Used to represent an action to filter a list of items or resources.",
    "keywords": [
      "filter",
      "options"
    ]
  },
  "FinanceFilledIcon": {
    "id": "FinanceFilledIcon",
    "name": "Finance filled",
    "description": "Used to direct merchants to Shopify Finance",
    "keywords": [
      "finances",
      "financial accounts",
      "transactions"
    ]
  },
  "FinanceIcon": {
    "id": "FinanceIcon",
    "name": "Finance",
    "description": "Used to direct merchants to Shopify Finance",
    "keywords": [
      "finances",
      "financial accounts",
      "transactions"
    ]
  },
  "FlagIcon": {
    "id": "FlagIcon",
    "name": "Flag",
    "description": "Used to represent a flag.",
    "keywords": [
      "flag"
    ]
  },
  "FlipHorizontalIcon": {
    "id": "FlipHorizontalIcon",
    "name": "Flip horizontal",
    "description": "Used in media editing for flipping an image horizontally.",
    "keywords": [
      "flip",
      "mirror",
      "horizontal"
    ]
  },
  "FlipVerticalIcon": {
    "id": "FlipVerticalIcon",
    "name": "Flip vertical",
    "description": "Used in media editing for flipping an image vertically.",
    "keywords": [
      "flip",
      "mirror",
      "vertical"
    ]
  },
  "FlowerFilledIcon": {
    "id": "FlowerFilledIcon",
    "name": "Flower filled",
    "description": "Used to help direct merchants to the Capital page",
    "keywords": [
      "capital",
      "flower",
      "plant"
    ]
  },
  "FlowerIcon": {
    "id": "FlowerIcon",
    "name": "Flower",
    "description": "Used to help direct merchants to the Capital page",
    "keywords": [
      "capital",
      "flower",
      "plant"
    ]
  },
  "FolderAddIcon": {
    "id": "FolderAddIcon",
    "name": "Folder add",
    "description": "Used to represent an action to add a folder.",
    "keywords": [
      "add",
      "folder",
      "plus"
    ]
  },
  "FolderDownIcon": {
    "id": "FolderDownIcon",
    "name": "Folder down",
    "description": "Used to represent an action to download a folder.",
    "keywords": [
      "download",
      "folder"
    ]
  },
  "FolderIcon": {
    "id": "FolderIcon",
    "name": "Folder",
    "description": "Used to represent a folder.",
    "keywords": [
      "folder"
    ]
  },
  "FolderRemoveIcon": {
    "id": "FolderRemoveIcon",
    "name": "Folder remove",
    "description": "Used to represent an action to remove a folder.",
    "keywords": [
      "folder",
      "minus",
      "remove"
    ]
  },
  "FolderUpIcon": {
    "id": "FolderUpIcon",
    "name": "Folder up",
    "description": "Used to represent an action to upload a folder.",
    "keywords": [
      "folder",
      "upload"
    ]
  },
  "FoodIcon": {
    "id": "FoodIcon",
    "name": "Food",
    "description": "Used as a navigation item in our emoji picker for the food category.",
    "keywords": [
      "emoji",
      "navigation",
      "coffee",
      "food"
    ]
  },
  "ForkliftIcon": {
    "id": "ForkliftIcon",
    "name": "Forklift",
    "description": "Used to represent a forklift or equipment used in a warehouse.",
    "keywords": [
      "forklift",
      "lift",
      "delivery",
      "warehouse"
    ]
  },
  "FormsIcon": {
    "id": "FormsIcon",
    "name": "Forms",
    "description": "Used to represent a text input for a form.",
    "keywords": [
      "form",
      "input",
      "text"
    ]
  },
  "GamesIcon": {
    "id": "GamesIcon",
    "name": "Games",
    "description": "Used to represent a console controller.",
    "keywords": [
      "console",
      "controller",
      "games"
    ]
  },
  "GaugeIcon": {
    "id": "GaugeIcon",
    "name": "Gauge",
    "description": "Used to represent an analytics benchmark",
    "keywords": [
      "analytics",
      "benchmark",
      "gauge chart"
    ]
  },
  "GiftCardFilledIcon": {
    "id": "GiftCardFilledIcon",
    "name": "Gift card filled",
    "description": "Used to represent a gift card or present.",
    "keywords": [
      "gift",
      "gift card",
      "present"
    ]
  },
  "GiftCardIcon": {
    "id": "GiftCardIcon",
    "name": "Gift card",
    "description": "Used to represent a gift card or present.",
    "keywords": [
      "gift",
      "gift card",
      "present"
    ]
  },
  "GlobeAsiaFilledIcon": {
    "id": "GlobeAsiaFilledIcon",
    "name": "Globe Asia filled",
    "description": "Used to represent a globe with Asia.",
    "keywords": [
      "globe",
      "asia"
    ]
  },
  "GlobeAsiaIcon": {
    "id": "GlobeAsiaIcon",
    "name": "Globe Asia",
    "description": "Used to represent a globe with Asia.",
    "keywords": [
      "globe",
      "asia"
    ]
  },
  "GlobeEUFilledIcon": {
    "id": "GlobeEUFilledIcon",
    "name": "Globe EU filled",
    "description": "Used to represent a globe with Europe.",
    "keywords": [
      "globe",
      "EU",
      "europe"
    ]
  },
  "GlobeEUIcon": {
    "id": "GlobeEUIcon",
    "name": "Globe EU",
    "description": "Used to represent a globe with Europe.",
    "keywords": [
      "globe",
      "EU",
      "europe"
    ]
  },
  "GlobeFilledIcon": {
    "id": "GlobeFilledIcon",
    "name": "Globe filled",
    "description": "Used to represent a globe",
    "keywords": [
      "globe"
    ]
  },
  "GlobeIcon": {
    "id": "GlobeIcon",
    "name": "Globe",
    "description": "Used to represent a globe.",
    "keywords": [
      "globe"
    ]
  },
  "HashtagDecimalIcon": {
    "id": "HashtagDecimalIcon",
    "name": "Hashtag decimal",
    "description": "Used to denote a decimal number",
    "keywords": [
      "decimal",
      "number"
    ]
  },
  "HashtagIcon": {
    "id": "HashtagIcon",
    "name": "Hashtag",
    "description": "Used to represent a hashtag.",
    "keywords": [
      "pound",
      "#",
      "sharp",
      "num"
    ]
  },
  "HeartIcon": {
    "id": "HeartIcon",
    "name": "Heart",
    "description": "Used to represent a heart or an action to love or like something.",
    "keywords": [
      "heart",
      "love"
    ]
  },
  "HideIcon": {
    "id": "HideIcon",
    "name": "Hide",
    "description": "Used to represent an action to hide something, or to represent a hidden item or resource.",
    "keywords": [
      "section",
      "conceal",
      "eye",
      "see",
      "show"
    ]
  },
  "HomeFilledIcon": {
    "id": "HomeFilledIcon",
    "name": "Home filled",
    "description": "Used to help direct merchants back to the admin home page.",
    "keywords": [
      "home page",
      "home",
      "base",
      "main page",
      "start"
    ]
  },
  "HomeIcon": {
    "id": "HomeIcon",
    "name": "Home",
    "description": "Used to help direct merchants back to the admin home page.",
    "keywords": [
      "home page",
      "home",
      "base",
      "main page",
      "start"
    ]
  },
  "IconsFilledIcon": {
    "id": "IconsFilledIcon",
    "name": "S filled icon",
    "description": "Used to represent icons or shapes.",
    "keywords": [
      "icons",
      "shapes"
    ]
  },
  "IconsIcon": {
    "id": "IconsIcon",
    "name": "S icon",
    "description": "Used to represent icons or shapes.",
    "keywords": [
      "icons",
      "shapes"
    ]
  },
  "IdentityCardFilledIcon": {
    "id": "IdentityCardFilledIcon",
    "name": "Identity card filled",
    "description": "Used to represent a personal identification document, such as a driver’s license.",
    "keywords": [
      "document",
      "upload",
      "license",
      "id",
      "identity",
      "card"
    ]
  },
  "IdentityCardIcon": {
    "id": "IdentityCardIcon",
    "name": "Identity card",
    "description": "Used to represent a personal identification document, such as a driver’s license.",
    "keywords": [
      "document",
      "upload",
      "license",
      "id",
      "identity",
      "card"
    ]
  },
  "ImageAddIcon": {
    "id": "ImageAddIcon",
    "name": "Image add",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "ImageAltIcon": {
    "id": "ImageAltIcon",
    "name": "Image alt",
    "description": "Used to represent the alt text attribute used to describe the appearance and function of an image on a page.",
    "keywords": [
      "accessibility",
      "alt text"
    ]
  },
  "ImageExploreIcon": {
    "id": "ImageExploreIcon",
    "name": "Image explore",
    "description": "Used to represent exploring a variety of imagery assets",
    "keywords": [
      "images",
      "media"
    ]
  },
  "ImageIcon": {
    "id": "ImageIcon",
    "name": "Image",
    "description": "Used to represent an image or placeholder.",
    "keywords": [
      "image",
      "placeholder"
    ]
  },
  "ImageMagicIcon": {
    "id": "ImageMagicIcon",
    "name": "Image Magic",
    "description": "Used for signifying Magic media editing, like background removal and image generation.",
    "keywords": [
      "Magic",
      "Generation",
      "Media"
    ]
  },
  "ImageWithTextOverlayIcon": {
    "id": "ImageWithTextOverlayIcon",
    "name": "Image with text overlay",
    "description": "Used to represent a layout option of text overlaid on an image.",
    "keywords": [
      "image",
      "picture",
      "photo",
      "text",
      "content",
      "overlay",
      "layout",
      "section"
    ]
  },
  "ImagesIcon": {
    "id": "ImagesIcon",
    "name": "Images",
    "description": "Used to represent multiple images.",
    "keywords": [
      "images",
      "gallery"
    ]
  },
  "ImportIcon": {
    "id": "ImportIcon",
    "name": "Import",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "InboundIcon": {
    "id": "InboundIcon",
    "name": "Inbound",
    "description": "Used to represent an inbound transaction or payment",
    "keywords": [
      "finances",
      "financial accounts",
      "transactions"
    ]
  },
  "IncentiveIcon": {
    "id": "IncentiveIcon",
    "name": "Incentive",
    "description": "Used to represent an incentive",
    "keywords": [
      "incentive",
      "incentives",
      "growth"
    ]
  },
  "IncomingIcon": {
    "id": "IncomingIcon",
    "name": "Incoming",
    "description": "Used to represent an incoming item or resource, or importing an item or resource.",
    "keywords": [
      "import",
      "inbox",
      "incoming"
    ]
  },
  "InfoIcon": {
    "id": "InfoIcon",
    "name": "Info",
    "description": "Used to represent a hint, or draw attention to a piece of information.",
    "keywords": [
      "info",
      "information",
      "hint"
    ]
  },
  "InventoryFilledIcon": {
    "id": "InventoryFilledIcon",
    "name": "Inventory filled",
    "description": "Used to represent inventory or a warehouse.",
    "keywords": [
      "inventory",
      "warehouse"
    ]
  },
  "InventoryIcon": {
    "id": "InventoryIcon",
    "name": "Inventory",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "InventoryUpdatedIcon": {
    "id": "InventoryUpdatedIcon",
    "name": "Inventory updated",
    "description": "Used to represent updated inventory at a warehouse.",
    "keywords": [
      "warehouse",
      "inventory",
      "manage",
      "update"
    ]
  },
  "IqIcon": {
    "id": "IqIcon",
    "name": "Iq",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "KeyIcon": {
    "id": "KeyIcon",
    "name": "Key",
    "description": "Used to represent a key or security.",
    "keywords": [
      "key",
      "lock",
      "secure",
      "security",
      "unlock"
    ]
  },
  "KeyboardHideIcon": {
    "id": "KeyboardHideIcon",
    "name": "Keyboard hide",
    "description": "Used to represent an action to hide the keyboard on a mobile device.",
    "keywords": [
      "hide keyboard",
      "keyboard"
    ]
  },
  "KeyboardIcon": {
    "id": "KeyboardIcon",
    "name": "Keyboard",
    "description": "Used to represent a keyboard or keyboard shortcuts.",
    "keywords": [
      "keyboard",
      "shortcuts"
    ]
  },
  "LabelPrinterIcon": {
    "id": "LabelPrinterIcon",
    "name": "Label printer",
    "description": "Used to represent a label printer (a special printer that prints 4x6 shipping labels on thermal sticker paper).",
    "keywords": [
      "label",
      "printer",
      "4x6",
      "shipping",
      "print",
      "thermal"
    ]
  },
  "LanguageFilledIcon": {
    "id": "LanguageFilledIcon",
    "name": "Language filled",
    "description": "Used to represent internationalization or multiple language options.",
    "keywords": [
      "language",
      "international"
    ]
  },
  "LanguageIcon": {
    "id": "LanguageIcon",
    "name": "Language",
    "description": "Used to represent internationalization or multiple language options.",
    "keywords": [
      "language",
      "international"
    ]
  },
  "LanguageTranslateIcon": {
    "id": "LanguageTranslateIcon",
    "name": "Language translate",
    "description": "Used to represent internationalization or multiple language options.",
    "keywords": [
      "language",
      "international"
    ]
  },
  "LayoutBlockIcon": {
    "id": "LayoutBlockIcon",
    "name": "Layout block",
    "description": "Used to represent a content block as a sub-element of a section, page or layout.",
    "keywords": [
      "block",
      "element",
      "item",
      "layout",
      "content"
    ]
  },
  "LayoutBuyButtonHorizontalIcon": {
    "id": "LayoutBuyButtonHorizontalIcon",
    "name": "Layout buy button horizontal",
    "description": "Used to represent a horizontal layout for our Buy Button.",
    "keywords": [
      "button",
      "buy button",
      "layout"
    ]
  },
  "LayoutBuyButtonIcon": {
    "id": "LayoutBuyButtonIcon",
    "name": "Layout buy button",
    "description": "Used to represent a centered layout for our Buy Button.",
    "keywords": [
      "center",
      "layout"
    ]
  },
  "LayoutBuyButtonVerticalIcon": {
    "id": "LayoutBuyButtonVerticalIcon",
    "name": "Layout buy button vertical",
    "description": "Used to represent a vertical layout for our Buy Button.",
    "keywords": [
      "button",
      "buy button",
      "layout"
    ]
  },
  "LayoutColumn1Icon": {
    "id": "LayoutColumn1Icon",
    "name": "Layout column1",
    "description": "Used to represent a 1 column layout.",
    "keywords": [
      "single column",
      "column",
      "layout",
      "email"
    ]
  },
  "LayoutColumns2Icon": {
    "id": "LayoutColumns2Icon",
    "name": "Layout columns2",
    "description": "Used to represent a 2 column layout.",
    "keywords": [
      "two columns",
      "column",
      "layout",
      "email"
    ]
  },
  "LayoutColumns3Icon": {
    "id": "LayoutColumns3Icon",
    "name": "Layout columns3",
    "description": "Used to represent a 3 column layout or an action to hide or show columns",
    "keywords": [
      "three columns",
      "column",
      "options",
      "layout"
    ]
  },
  "LayoutFooterIcon": {
    "id": "LayoutFooterIcon",
    "name": "Layout footer",
    "description": "Used to represent the footer section of a component, page or layout.",
    "keywords": [
      "layout",
      "footer",
      "content",
      "dashed",
      "bottom",
      "section"
    ]
  },
  "LayoutHeaderIcon": {
    "id": "LayoutHeaderIcon",
    "name": "Layout header",
    "description": "Used to represent the header section of a component, page or layout.",
    "keywords": [
      "layout",
      "header",
      "content",
      "dashed",
      "section"
    ]
  },
  "LayoutLogoBlockIcon": {
    "id": "LayoutLogoBlockIcon",
    "name": "Layout logo block",
    "description": "Used to represent a layout option of one or more logos.",
    "keywords": [
      "logo",
      "list",
      "layout",
      "section",
      "circle",
      "dotted"
    ]
  },
  "LayoutPopupIcon": {
    "id": "LayoutPopupIcon",
    "name": "Layout popup",
    "description": "Used to represent the option to popup the content.",
    "keywords": [
      "popup",
      "window",
      "overlay"
    ]
  },
  "LayoutRows2Icon": {
    "id": "LayoutRows2Icon",
    "name": "Layout rows2",
    "description": "Used to represent a 2 row layout.",
    "keywords": [
      "two rows",
      "row",
      "layout"
    ]
  },
  "LayoutSectionIcon": {
    "id": "LayoutSectionIcon",
    "name": "Layout section",
    "description": "Used to represent the middle section of a component, page or layout.",
    "keywords": [
      "layout",
      "middle",
      "content",
      "dashed",
      "section"
    ]
  },
  "LayoutSidebarLeftIcon": {
    "id": "LayoutSidebarLeftIcon",
    "name": "Layout sidebar left",
    "description": "Used to represent the left section of a component, page or layout.",
    "keywords": [
      "sidebar",
      "layout",
      "section",
      "left",
      "content"
    ]
  },
  "LayoutSidebarRightIcon": {
    "id": "LayoutSidebarRightIcon",
    "name": "Layout sidebar right",
    "description": "Used to represent the right section of a component, page or layout.",
    "keywords": [
      "sidebar",
      "layout",
      "section",
      "right",
      "content"
    ]
  },
  "LightbulbIcon": {
    "id": "LightbulbIcon",
    "name": "Lightbulb",
    "description": "Used to represent a hint or idea.",
    "keywords": [
      "hint",
      "idea",
      "light bulb"
    ]
  },
  "LinkIcon": {
    "id": "LinkIcon",
    "name": "Link",
    "description": "Used to represent a link.",
    "keywords": [
      "chain",
      "link"
    ]
  },
  "ListBulletedFilledIcon": {
    "id": "ListBulletedFilledIcon",
    "name": "List bulleted filled",
    "description": "Used to represent a list of items or resources, or a bulleted list.",
    "keywords": [
      "bulleted list",
      "list",
      "keywords",
      "todo"
    ]
  },
  "ListBulletedIcon": {
    "id": "ListBulletedIcon",
    "name": "List bulleted",
    "description": "Used to represent a list of items or resources, or a bulleted list.",
    "keywords": [
      "bulleted list",
      "list",
      "keywords",
      "todo"
    ]
  },
  "ListNumberedIcon": {
    "id": "ListNumberedIcon",
    "name": "List numbered",
    "description": "Used to format text with a numbered list.",
    "keywords": [
      "text format",
      "list",
      "numbered list",
      "rich text",
      "rte",
      "format",
      "text",
      "text editing"
    ]
  },
  "LiveFilledIcon": {
    "id": "LiveFilledIcon",
    "name": "Live filled",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "LiveIcon": {
    "id": "LiveIcon",
    "name": "Live",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "LocationFilledIcon": {
    "id": "LocationFilledIcon",
    "name": "Location filled",
    "description": "Used to represent a location.",
    "keywords": [
      "location",
      "pin"
    ]
  },
  "LocationIcon": {
    "id": "LocationIcon",
    "name": "Location",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "LocationNoneIcon": {
    "id": "LocationNoneIcon",
    "name": "Location none",
    "description": "Used to represent an inactive location.",
    "keywords": [
      "inactive location",
      "deactivated location",
      "location"
    ]
  },
  "LockFilledIcon": {
    "id": "LockFilledIcon",
    "name": "Lock filled",
    "description": "Used to represent a lock, a secure item or resource or that an option or setting is currently locked.",
    "keywords": [
      "lock",
      "secure"
    ]
  },
  "LockIcon": {
    "id": "LockIcon",
    "name": "Lock",
    "description": "Used to represent a lock, a secure item or resource or that an option or setting is currently locked.",
    "keywords": [
      "lock",
      "secure"
    ]
  },
  "LogoCriteoIcon": {
    "id": "LogoCriteoIcon",
    "name": "Logo Criteo",
    "set": "Minor",
    "description": "Criteo logo",
    "keywords": [
      "criteo",
      "social media"
    ]
  },
  "LogoFacebookIcon": {
    "id": "LogoFacebookIcon",
    "name": "Facebook",
    "set": "Minor",
    "description": "Used to represent Facebook.",
    "keywords": [
      "Facebook",
      "social media"
    ]
  },
  "LogoGoogleIcon": {
    "id": "LogoGoogleIcon",
    "name": "Logo Google",
    "set": "Minor",
    "description": "Google logo",
    "keywords": [
      "Google",
      "social media"
    ]
  },
  "LogoInstagramIcon": {
    "id": "LogoInstagramIcon",
    "name": "Instagram",
    "set": "Minor",
    "description": "Used to represent Instagram.",
    "keywords": [
      "Instagram",
      "social media"
    ]
  },
  "LogoMetaIcon": {
    "id": "LogoMetaIcon",
    "name": "Logo Meta",
    "set": "Minor",
    "description": "Meta logo",
    "keywords": [
      "Meta",
      "Facebook",
      "social media"
    ]
  },
  "LogoPinterestIcon": {
    "id": "LogoPinterestIcon",
    "name": "Logo pinterest",
    "description": "Pinterest logo",
    "keywords": [
      "Pintrest",
      "Social media"
    ]
  },
  "LogoSnapchatIcon": {
    "id": "LogoSnapchatIcon",
    "name": "Logo snapchat",
    "description": "Snapchat logo",
    "keywords": [
      "Snapchat",
      "Social media"
    ]
  },
  "LogoTiktokIcon": {
    "id": "LogoTiktokIcon",
    "name": "Logo tiktok",
    "description": "Tiktok logo",
    "keywords": [
      "Tiktok",
      "Social media"
    ]
  },
  "LogoTumblrIcon": {
    "id": "LogoTumblrIcon",
    "name": "Logo tumblr",
    "description": "Logo for Tumblr social media platform",
    "keywords": [
      "tumblr",
      "social media"
    ]
  },
  "LogoTwitchIcon": {
    "id": "LogoTwitchIcon",
    "name": "Logo twitch",
    "description": "Logo for Twich",
    "keywords": [
      "Twitch",
      "Social media"
    ]
  },
  "LogoVimeoIcon": {
    "id": "LogoVimeoIcon",
    "name": "Logo vimeo",
    "description": "Logo for Vimeo social media platform",
    "keywords": [
      "Vimeo",
      "social media"
    ]
  },
  "LogoXIcon": {
    "id": "LogoXIcon",
    "name": "Logo X",
    "description": "Used to represent X.",
    "keywords": [
      "Twitter",
      "X",
      "social media"
    ]
  },
  "LogoYoutubeIcon": {
    "id": "LogoYoutubeIcon",
    "name": "Logo youtube",
    "description": "Used to represent Youtube.",
    "keywords": [
      "Youtube",
      "social media"
    ]
  },
  "MagicIcon": {
    "id": "MagicIcon",
    "name": "Magic",
    "description": "Concept     | Used to represent AI-assisted features.",
    "keywords": [
      "Magic",
      "AI",
      "Artificial Intelligence",
      "ML",
      "Machine Learning",
      "Generative",
      "Sparkle",
      "Stars"
    ]
  },
  "MakePaymentIcon": {
    "id": "MakePaymentIcon",
    "name": "Make payment",
    "description": "Used to denote making a payment",
    "keywords": [
      "finances",
      "financial accounts",
      "transactions"
    ]
  },
  "MarketsEuroFilledIcon": {
    "id": "MarketsEuroFilledIcon",
    "name": "Markets Euro",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "MarketsEuroIcon": {
    "id": "MarketsEuroIcon",
    "name": "Markets Euro",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "MarketsFilledIcon": {
    "id": "MarketsFilledIcon",
    "name": "Markets filled",
    "description": "Used to represent Markets, Shopify’s international commerce product.",
    "keywords": [
      "markets",
      "international",
      "commerce",
      "global"
    ]
  },
  "MarketsIcon": {
    "id": "MarketsIcon",
    "name": "Markets",
    "description": "Used to represent Markets, Shopify’s international commerce product.",
    "keywords": [
      "markets",
      "international",
      "commerce",
      "global"
    ]
  },
  "MarketsRupeeFilledIcon": {
    "id": "MarketsRupeeFilledIcon",
    "name": "Markets Rupee filled",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "MarketsRupeeIcon": {
    "id": "MarketsRupeeIcon",
    "name": "Markets Rupee",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "MarketsYenFilledIcon": {
    "id": "MarketsYenFilledIcon",
    "name": "Markets Yen Filled",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "MarketsYenIcon": {
    "id": "MarketsYenIcon",
    "name": "Markets Yen",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "MaximizeIcon": {
    "id": "MaximizeIcon",
    "name": "Maximize",
    "description": "Used to represent an action to make an item, resource or view larger.",
    "keywords": [
      "expand",
      "full screen",
      "maximise"
    ]
  },
  "MeasurementSizeIcon": {
    "id": "MeasurementSizeIcon",
    "name": "Measurement size",
    "description": "Used to represent measurement including dimension, volume, and weight.",
    "keywords": [
      "dimension",
      "weight",
      "volume",
      "measurement",
      "size"
    ]
  },
  "MeasurementVolumeIcon": {
    "id": "MeasurementVolumeIcon",
    "name": "Measurement volume",
    "description": "Used to represent volume measurement",
    "keywords": [
      "volume",
      "measurement",
      "size"
    ]
  },
  "MeasurementWeightIcon": {
    "id": "MeasurementWeightIcon",
    "name": "Measurement weight",
    "description": "Used to represent weight measurement",
    "keywords": [
      "weight",
      "measurement"
    ]
  },
  "MediaReceiverIcon": {
    "id": "MediaReceiverIcon",
    "name": "Media receiver",
    "description": "Used to represent a digital receiver or wireless network device.",
    "keywords": [
      "receiver",
      "wifi",
      "wireless"
    ]
  },
  "MegaphoneFilledIcon": {
    "id": "MegaphoneFilledIcon",
    "name": "Megaphone filled",
    "description": "Used to represent an action to open an external resource, or promote an item or resource.",
    "keywords": [
      "external",
      "promote"
    ]
  },
  "MegaphoneIcon": {
    "id": "MegaphoneIcon",
    "name": "Megaphone",
    "description": "Used to represent an action to open an external resource, or promote an item or resource.",
    "keywords": [
      "external",
      "promote"
    ]
  },
  "MentionIcon": {
    "id": "MentionIcon",
    "name": "Mention",
    "description": "Used to represent an action to mention someone.",
    "keywords": [
      "at",
      "mention"
    ]
  },
  "MenuHorizontalIcon": {
    "id": "MenuHorizontalIcon",
    "name": "Menu horizontal",
    "description": "Used to represent an action to reveal a menu or more options.",
    "keywords": [
      "dots",
      "ellipsis",
      "menu",
      "options",
      "overflow",
      "..."
    ]
  },
  "MenuIcon": {
    "id": "MenuIcon",
    "name": "Menu",
    "description": "Used to help direct merchants to navigation on mobile.",
    "keywords": [
      "hamburger",
      "menu",
      "burger"
    ]
  },
  "MenuVerticalIcon": {
    "id": "MenuVerticalIcon",
    "name": "Menu vertical",
    "description": "Used to represent an action to reveal a menu or more options.",
    "keywords": [
      "dots",
      "menu",
      "options",
      "overflow"
    ]
  },
  "MergeIcon": {
    "id": "MergeIcon",
    "name": "Merge",
    "description": "Used to represent merging of objects.",
    "keywords": [
      "merge",
      "combine",
      "union",
      "join"
    ]
  },
  "MetafieldsFilledIcon": {
    "id": "MetafieldsFilledIcon",
    "name": "Metafields filled",
    "description": "Used to represent metafields",
    "keywords": [
      "metafields",
      "data sources"
    ]
  },
  "MetafieldsIcon": {
    "id": "MetafieldsIcon",
    "name": "Metafields",
    "description": "Used to represent metafields",
    "keywords": [
      "metafields",
      "data sources"
    ]
  },
  "MetaobjectFilledIcon": {
    "id": "MetaobjectFilledIcon",
    "name": "Metaobject",
    "description": "Used to represent metaobjects",
    "keywords": [
      "metaobject",
      "content"
    ]
  },
  "MetaobjectIcon": {
    "id": "MetaobjectIcon",
    "name": "Metaobject",
    "description": "Used to represent metaobjects",
    "keywords": [
      "metaobject",
      "content"
    ]
  },
  "MetaobjectListIcon": {
    "id": "MetaobjectListIcon",
    "name": "Metaobject list",
    "description": "Used to represent a list of metaobjects",
    "keywords": [
      "metaobject",
      "metaobjects",
      "content",
      "list"
    ]
  },
  "MetaobjectReferenceIcon": {
    "id": "MetaobjectReferenceIcon",
    "name": "Metaobject reference",
    "description": "Used to represent a metaobject referenced on other resources",
    "keywords": [
      "metaobject",
      "reference"
    ]
  },
  "MicrophoneIcon": {
    "id": "MicrophoneIcon",
    "name": "Microphone",
    "description": "Used to represent a microphone.",
    "keywords": [
      "mic",
      "microphone"
    ]
  },
  "MinimizeIcon": {
    "id": "MinimizeIcon",
    "name": "Minimize",
    "description": "Used to represent an action to make an item, resource or view smaller.",
    "keywords": [
      "minimise"
    ]
  },
  "MinusCircleIcon": {
    "id": "MinusCircleIcon",
    "name": "Minus circle",
    "description": "Used to represent an action to remove an item or resource, or decrease the quantity of an item or resource.",
    "keywords": [
      "less",
      "minus",
      "remove"
    ]
  },
  "MinusIcon": {
    "id": "MinusIcon",
    "name": "Minus",
    "description": "Used to denote the action of removing an item.",
    "keywords": [
      "minus",
      "negative",
      "subtract",
      "subtraction",
      "math",
      "-",
      "substract",
      "less"
    ]
  },
  "MobileIcon": {
    "id": "MobileIcon",
    "name": "Mobile",
    "description": "Used to represent a mobile phone.",
    "keywords": [
      "mobile",
      "phone"
    ]
  },
  "MoneyFilledIcon": {
    "id": "MoneyFilledIcon",
    "name": "Money filled",
    "description": "Used to represent money.",
    "keywords": [
      "money",
      "balance",
      "billing",
      "finances",
      "money",
      "payout",
      "cash"
    ]
  },
  "MoneyIcon": {
    "id": "MoneyIcon",
    "name": "Money",
    "description": "Used to represent the Finances section.",
    "keywords": [
      "balance",
      "billing",
      "finances",
      "money",
      "payout"
    ]
  },
  "MoneyNoneIcon": {
    "id": "MoneyNoneIcon",
    "name": "Money none",
    "description": "Used to represent blocked payouts or lack of funds.",
    "keywords": [
      "blocked payouts",
      "payouts blocked",
      "payouts",
      "money",
      "none"
    ]
  },
  "MoonIcon": {
    "id": "MoonIcon",
    "name": "Moon",
    "description": "Used to indicate night and dark mode",
    "keywords": [
      "moon",
      "dark",
      "night"
    ]
  },
  "NatureIcon": {
    "id": "NatureIcon",
    "name": "Nature",
    "description": "N/A",
    "keywords": [
      "Nature",
      "Leaf"
    ]
  },
  "NoteAddIcon": {
    "id": "NoteAddIcon",
    "name": "Note add",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "NoteIcon": {
    "id": "NoteIcon",
    "name": "Note",
    "description": "Used to represent a document or note.",
    "keywords": [
      "annotations",
      "document",
      "note",
      "notes",
      "page",
      "paper",
      "tags"
    ]
  },
  "NotificationFilledIcon": {
    "id": "NotificationFilledIcon",
    "name": "Notification filled",
    "description": "Used to represent a notification or alert.",
    "keywords": [
      "notifications",
      "alerts",
      "bell"
    ]
  },
  "NotificationIcon": {
    "id": "NotificationIcon",
    "name": "Notification",
    "description": "Used to represent a notification or alert.",
    "keywords": [
      "notifications",
      "alerts",
      "bell"
    ]
  },
  "OrderDraftFilledIcon": {
    "id": "OrderDraftFilledIcon",
    "name": "Order draft filled",
    "description": "Used to represent an order that is in a Draft state.",
    "keywords": [
      "draft",
      "order",
      "pending"
    ]
  },
  "OrderDraftIcon": {
    "id": "OrderDraftIcon",
    "name": "Order draft",
    "description": "Used to represent an order that is in a Draft state.",
    "keywords": [
      "draft",
      "order",
      "pending"
    ]
  },
  "OrderFilledIcon": {
    "id": "OrderFilledIcon",
    "name": "Order filled",
    "description": "Used to represent an inbox or an item or resource arriving in an inbox.",
    "keywords": [
      "inbox",
      "orders"
    ]
  },
  "OrderFirstIcon": {
    "id": "OrderFirstIcon",
    "name": "Order first",
    "description": "Used to represent a first order.",
    "keywords": [
      "celebrate",
      "first",
      "milestone",
      "order"
    ]
  },
  "OrderFulfilledIcon": {
    "id": "OrderFulfilledIcon",
    "name": "Order fulfilled",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "OrderIcon": {
    "id": "OrderIcon",
    "name": "Order",
    "description": "Used to represent an inbox or an item or resource arriving in an inbox.",
    "keywords": [
      "inbox",
      "orders"
    ]
  },
  "OrderRepeatIcon": {
    "id": "OrderRepeatIcon",
    "name": "Order repeat",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "OrderUnfulfilledIcon": {
    "id": "OrderUnfulfilledIcon",
    "name": "Order unfulfilled",
    "description": "Used to represent an empty inbox.",
    "keywords": [
      "inbox",
      "unfulilled"
    ]
  },
  "OrdersStatusIcon": {
    "id": "OrdersStatusIcon",
    "name": "Orders status",
    "description": "Used to represent the activity of an inbox.",
    "keywords": [
      "activity",
      "inbox",
      "status",
      "orders"
    ]
  },
  "OrganizationFilledIcon": {
    "id": "OrganizationFilledIcon",
    "name": "Organization filled",
    "description": "Used to represent a plus organization.",
    "keywords": [
      "organization",
      "business"
    ]
  },
  "OrganizationIcon": {
    "id": "OrganizationIcon",
    "name": "Organization",
    "description": "Used to represent a plus organization.",
    "keywords": [
      "organization",
      "business"
    ]
  },
  "OutboundIcon": {
    "id": "OutboundIcon",
    "name": "Outbound",
    "description": "Used to represent an outbound transaction or payment",
    "keywords": [
      "finances",
      "financial accounts",
      "transactions"
    ]
  },
  "OutdentIcon": {
    "id": "OutdentIcon",
    "name": "Outdent",
    "description": "Used to decrease text indentation with list formatting.",
    "keywords": [
      "text format",
      "list",
      "rich text",
      "rte",
      "format",
      "text",
      "text editing"
    ]
  },
  "OutgoingIcon": {
    "id": "OutgoingIcon",
    "name": "Outgoing",
    "description": "Used to represent an outgoing item or resource, or exporting an item or resource.",
    "keywords": [
      "export",
      "outbox",
      "outgoing"
    ]
  },
  "PackageFilledIcon": {
    "id": "PackageFilledIcon",
    "name": "Package filled",
    "description": "Used to represent a package or box that merchants can ship their products in.",
    "keywords": [
      "shipping",
      "box",
      "package",
      "cardboard"
    ]
  },
  "PackageFulfilledIcon": {
    "id": "PackageFulfilledIcon",
    "name": "Package fulfilled",
    "description": "The fulfillment icon is associated with the 'fulfilled' status.",
    "keywords": [
      "fulfillment",
      "fulfilled"
    ]
  },
  "PackageIcon": {
    "id": "PackageIcon",
    "name": "Package",
    "description": "Used to represent a package or box that merchants can ship their products in.",
    "keywords": [
      "shipping",
      "box",
      "package",
      "cardboard"
    ]
  },
  "PackageOnHoldIcon": {
    "id": "PackageOnHoldIcon",
    "name": "Package on hold",
    "description": "The fulfillment icon is associated with the 'on hold' status.",
    "keywords": [
      "fulfillment",
      "on hold",
      "on-hold"
    ]
  },
  "PackageReturnedIcon": {
    "id": "PackageReturnedIcon",
    "name": "Package returned",
    "description": "Used to represent returns on an order.",
    "keywords": [
      "returns",
      "return",
      "order"
    ]
  },
  "PageAddIcon": {
    "id": "PageAddIcon",
    "name": "Page add",
    "description": "Used to represent an action to add a page or document.",
    "keywords": [
      "add",
      "document",
      "page",
      "paper"
    ]
  },
  "PageAttachmentIcon": {
    "id": "PageAttachmentIcon",
    "name": "Page attachment",
    "description": "This icon denotes an attachment of any file to a timeline.",
    "keywords": [
      "timeline",
      "attachment",
      "generic",
      "file"
    ]
  },
  "PageClockFilledIcon": {
    "id": "PageClockFilledIcon",
    "name": "Page clock filled",
    "description": "Used to represent a story activity log, or any other report/series of events that happened in the past.",
    "keywords": [
      "History",
      "Timeline",
      "Events",
      "Past",
      "Monitoring"
    ]
  },
  "PageClockIcon": {
    "id": "PageClockIcon",
    "name": "Page clock",
    "description": "Used to represent a story activity log, or any other report/series of events that happened in the past.",
    "keywords": [
      "History",
      "Timeline",
      "Events",
      "Past",
      "Monitoring"
    ]
  },
  "PageDownIcon": {
    "id": "PageDownIcon",
    "name": "Page down",
    "description": "Used to represent an action to download a page or document.",
    "keywords": [
      "document",
      "download",
      "page",
      "paper"
    ]
  },
  "PageHeartIcon": {
    "id": "PageHeartIcon",
    "name": "Page heart",
    "description": "Used to represent a featured or favorite page or content item.",
    "keywords": [
      "favourite",
      "favorite",
      "feature"
    ]
  },
  "PageIcon": {
    "id": "PageIcon",
    "name": "Page",
    "description": "Used to represent a blank page or document.",
    "keywords": [
      "blank",
      "document",
      "page",
      "paper"
    ]
  },
  "PageReferenceIcon": {
    "id": "PageReferenceIcon",
    "name": "Page reference",
    "description": "Used to represent pages referenced on other resources",
    "keywords": [
      "page",
      "reference",
      "metafields"
    ]
  },
  "PageRemoveIcon": {
    "id": "PageRemoveIcon",
    "name": "Page remove",
    "description": "Used to represent an action to remove a page or document.",
    "keywords": [
      "document",
      "minus",
      "page",
      "paper",
      "remove"
    ]
  },
  "PageUpIcon": {
    "id": "PageUpIcon",
    "name": "Page up",
    "description": "Used to represent an action to upload a page or document.",
    "keywords": [
      "document",
      "page",
      "paper",
      "upload"
    ]
  },
  "PaginationEndIcon": {
    "id": "PaginationEndIcon",
    "name": "Pagination end",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "PaginationStartIcon": {
    "id": "PaginationStartIcon",
    "name": "Pagination start",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "PaintBrushFlatIcon": {
    "id": "PaintBrushFlatIcon",
    "name": "Paint brush flat",
    "description": "Used to represent a paintbrush or an action to customize an item or resource.",
    "keywords": [
      "brush",
      "customize",
      "paintbrush"
    ]
  },
  "PaintBrushRoundIcon": {
    "id": "PaintBrushRoundIcon",
    "name": "Paint brush round",
    "description": "Used to represent an illustration, painting or brush.",
    "keywords": [
      "brush",
      "illustration",
      "paint"
    ]
  },
  "PaperCheckIcon": {
    "id": "PaperCheckIcon",
    "name": "Paper check",
    "description": "Used to represent a paper check payment method.",
    "keywords": [
      "payment method"
    ]
  },
  "PasskeyFilledIcon": {
    "id": "PasskeyFilledIcon",
    "name": "Passkey filled",
    "description": "Used to represent a passkey",
    "keywords": [
      "passkey",
      "identity",
      "security"
    ]
  },
  "PasskeyIcon": {
    "id": "PasskeyIcon",
    "name": "Passkey",
    "description": "Used to represent a passkey",
    "keywords": [
      "passkey",
      "identity",
      "security"
    ]
  },
  "PauseCircleIcon": {
    "id": "PauseCircleIcon",
    "name": "Pause circle",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "PaymentCaptureIcon": {
    "id": "PaymentCaptureIcon",
    "name": "Payment capture",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "PaymentFilledIcon": {
    "id": "PaymentFilledIcon",
    "name": "Payment filled",
    "description": "Used to represent a payment made by credit or debit card.",
    "keywords": [
      "credit",
      "credit card",
      "debit",
      "debit card",
      "payment"
    ]
  },
  "PaymentIcon": {
    "id": "PaymentIcon",
    "name": "Payment",
    "description": "Used to represent a payment made by credit or debit card.",
    "keywords": [
      "credit",
      "credit card",
      "debit",
      "debit card",
      "payment"
    ]
  },
  "PayoutDollarIcon": {
    "id": "PayoutDollarIcon",
    "name": "Payout dollar",
    "description": "Used to label payout transactions in dollars",
    "keywords": [
      "finances",
      "financial accounts",
      "transactions"
    ]
  },
  "PayoutEuroIcon": {
    "id": "PayoutEuroIcon",
    "name": "Payout euro",
    "description": "Used to label payout transactions in euros",
    "keywords": [
      "finances",
      "financial accounts",
      "transactions"
    ]
  },
  "PayoutIcon": {
    "id": "PayoutIcon",
    "name": "Payout",
    "description": "Used to label payout transactions in a generic currency",
    "keywords": [
      "finances",
      "financial accounts",
      "transactions"
    ]
  },
  "PayoutPoundIcon": {
    "id": "PayoutPoundIcon",
    "name": "Payout pound",
    "description": "Used to label payout transactions in pounds",
    "keywords": [
      "finances",
      "financial accounts",
      "transactions"
    ]
  },
  "PayoutRupeeIcon": {
    "id": "PayoutRupeeIcon",
    "name": "Payout rupee",
    "description": "Used to label payout transactions in rupees",
    "keywords": [
      "finances",
      "financial accounts",
      "transactions"
    ]
  },
  "PayoutYenIcon": {
    "id": "PayoutYenIcon",
    "name": "Payout yen",
    "description": "Used to label payout transactions in yen",
    "keywords": [
      "finances",
      "financial accounts",
      "transactions"
    ]
  },
  "PersonAddIcon": {
    "id": "PersonAddIcon",
    "name": "Person add",
    "description": "Used to represent adding a customer, or user.",
    "keywords": [
      "add",
      "user"
    ]
  },
  "PersonExitIcon": {
    "id": "PersonExitIcon",
    "name": "Person exit",
    "description": "Represents the concept of opting out, or exiting.",
    "keywords": [
      "Opt-out",
      "User",
      "Logout",
      "Exit",
      "Sign out",
      "Leave",
      "Disconnect"
    ]
  },
  "PersonFilledIcon": {
    "id": "PersonFilledIcon",
    "name": "Person filled",
    "description": "Used to represent a customer, or user.",
    "keywords": [
      "customer",
      "user"
    ]
  },
  "PersonIcon": {
    "id": "PersonIcon",
    "name": "Person",
    "description": "Used to represent a customer, or user.",
    "keywords": [
      "customer",
      "user"
    ]
  },
  "PersonLockFilledIcon": {
    "id": "PersonLockFilledIcon",
    "name": "Person lock filled",
    "description": "Used to represent access permissions for users.",
    "keywords": [
      "Lock",
      "Person",
      "Access",
      "Control",
      "Rights",
      "Roles",
      "Security",
      "Authentication",
      "Authorization",
      "Login",
      "Password"
    ]
  },
  "PersonLockIcon": {
    "id": "PersonLockIcon",
    "name": "Person lock",
    "description": "Used to represent access permissions for users.",
    "keywords": [
      "Lock",
      "Person",
      "Access",
      "Control",
      "Rights",
      "Roles",
      "Security",
      "Authentication",
      "Authorization",
      "Login",
      "Password"
    ]
  },
  "PersonRemoveIcon": {
    "id": "PersonRemoveIcon",
    "name": "Person remove",
    "description": "Used to represent removing a customer, or user.",
    "keywords": [
      "remove",
      "user"
    ]
  },
  "PersonSegmentIcon": {
    "id": "PersonSegmentIcon",
    "name": "Person segment",
    "description": "Used for customer segments",
    "keywords": [
      "Person",
      "Customer",
      "Segments",
      "Customer Segment"
    ]
  },
  "PersonalizedTextIcon": {
    "id": "PersonalizedTextIcon",
    "name": "Personalized text",
    "description": "Used to represent personalized text features.",
    "keywords": [
      "Personalized text",
      "Personalization",
      "Customer attributes",
      "Customer",
      "Dynamic content"
    ]
  },
  "PhoneIcon": {
    "id": "PhoneIcon",
    "name": "Phone",
    "description": "Used to represent a phone or phone call.",
    "keywords": [
      "call",
      "phone"
    ]
  },
  "PhoneInIcon": {
    "id": "PhoneInIcon",
    "name": "Phone in",
    "description": "Used to represent an incoming phone call.",
    "keywords": [
      "call",
      "incoming",
      "phone"
    ]
  },
  "PhoneOutIcon": {
    "id": "PhoneOutIcon",
    "name": "Phone out",
    "description": "Used to represent an outgoing phone call.",
    "keywords": [
      "call",
      "outgoing",
      "phone"
    ]
  },
  "PinFilledIcon": {
    "id": "PinFilledIcon",
    "name": "Pin filled",
    "description": "Used to represent a pin or an action to pin or save something.",
    "keywords": [
      "pin",
      "save"
    ]
  },
  "PinIcon": {
    "id": "PinIcon",
    "name": "Pin",
    "description": "Used to represent an unpinned item or an action to unpin something.",
    "keywords": [
      "unpin"
    ]
  },
  "PlanFilledIcon": {
    "id": "PlanFilledIcon",
    "name": "Plan filled",
    "description": "Wayfinding | Minor icon used to help direct merchants to the Plan page in Settings.",
    "keywords": [
      "Plan",
      "Plans",
      "Steps",
      "Levels",
      "Stairs",
      "Staircase"
    ]
  },
  "PlanIcon": {
    "id": "PlanIcon",
    "name": "Plan",
    "description": "Wayfinding | Minor icon used to help direct merchants to the Plan page in Settings.",
    "keywords": [
      "Plan",
      "Plans",
      "Steps",
      "Levels",
      "Stairs",
      "Staircase"
    ]
  },
  "PlayCircleIcon": {
    "id": "PlayCircleIcon",
    "name": "Play circle",
    "description": "Used to represent an action to play or resume something.",
    "keywords": [
      "video",
      "control",
      "media",
      "play",
      "motion",
      "animation",
      "film",
      "circle"
    ]
  },
  "PlayIcon": {
    "id": "PlayIcon",
    "name": "Play",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "PlusCircleIcon": {
    "id": "PlusCircleIcon",
    "name": "Plus circle",
    "description": "Used to denote the action of adding new content, like adding a new variant option name in the mobile app.",
    "keywords": [
      "plus",
      "circle",
      "outline",
      "+"
    ]
  },
  "PlusIcon": {
    "id": "PlusIcon",
    "name": "Plus",
    "description": "Used to represent an action to add an item or resource, or increase the quantity of an item or resource.",
    "keywords": [
      "add",
      "plus",
      "increase"
    ]
  },
  "PointOfSaleIcon": {
    "id": "PointOfSaleIcon",
    "name": "Point of sale",
    "description": "Used to represent a point of sale or sales register.",
    "keywords": [
      "point of sale",
      "POS",
      "terminal",
      "register"
    ]
  },
  "PriceListFilledIcon": {
    "id": "PriceListFilledIcon",
    "name": "Price list filled",
    "description": "n/a",
    "keywords": [
      "n/a"
    ]
  },
  "PriceListIcon": {
    "id": "PriceListIcon",
    "name": "Price list",
    "description": "n/a",
    "keywords": [
      "n/a"
    ]
  },
  "PrintIcon": {
    "id": "PrintIcon",
    "name": "Print",
    "description": "Used to denote the action of printing.",
    "keywords": [
      "print",
      "printing",
      "printer"
    ]
  },
  "ProductAddIcon": {
    "id": "ProductAddIcon",
    "name": "Product add",
    "description": "Used as an action to add a new product.",
    "keywords": [
      "add",
      "product",
      "price tag"
    ]
  },
  "ProductCostIcon": {
    "id": "ProductCostIcon",
    "name": "Product cost",
    "description": "Used to represent the cost of a product",
    "keywords": [
      "product",
      "cost"
    ]
  },
  "ProductFilledIcon": {
    "id": "ProductFilledIcon",
    "name": "Product filled",
    "description": "Used to represent products or a price tag.",
    "keywords": [
      "tag",
      "products",
      "price"
    ]
  },
  "ProductIcon": {
    "id": "ProductIcon",
    "name": "Product",
    "description": "Used to represent products or a price tag.",
    "keywords": [
      "tag",
      "products",
      "price"
    ]
  },
  "ProductListIcon": {
    "id": "ProductListIcon",
    "name": "Product list",
    "description": "Used to represent a list of products.",
    "keywords": [
      "tag",
      "products",
      "price",
      "list"
    ]
  },
  "ProductReferenceIcon": {
    "id": "ProductReferenceIcon",
    "name": "Product reference",
    "description": "Used to represent products referenced on other resources",
    "keywords": [
      "products",
      "reference",
      "metafields"
    ]
  },
  "ProductRemoveIcon": {
    "id": "ProductRemoveIcon",
    "name": "Product remove",
    "description": "Used to represent an action to remove a product.",
    "keywords": [
      "remove",
      "minus",
      "product"
    ]
  },
  "ProductReturnIcon": {
    "id": "ProductReturnIcon",
    "name": "Product return",
    "description": "Used to help direct merchants to returns page.",
    "keywords": [
      "return",
      "product return",
      "return page",
      "arrow"
    ]
  },
  "ProductUnavailableIcon": {
    "id": "ProductUnavailableIcon",
    "name": "Product unavailable",
    "description": "When a product has been deleted and is no longer available",
    "keywords": [
      "Product"
    ]
  },
  "ProfileIcon": {
    "id": "ProfileIcon",
    "name": "Profile",
    "description": "Used to represent a staff member.",
    "keywords": [
      "avatar",
      "user",
      "profile",
      "me",
      "portrait",
      "staff"
    ]
  },
  "QuestionCircleIcon": {
    "id": "QuestionCircleIcon",
    "name": "Question circle",
    "description": "Used to give merchants help or support for a feature.",
    "keywords": [
      "question",
      "question mark",
      "help",
      "support",
      "learn more",
      "circle"
    ]
  },
  "ReceiptDollarFilledIcon": {
    "id": "ReceiptDollarFilledIcon",
    "name": "Receipt dollar filled",
    "description": "N/A",
    "keywords": [
      "Dollar",
      "Receipt",
      "Invoice",
      "Bill",
      "Payment",
      "Receipt",
      "Purchase",
      "Transaction",
      "Proof",
      "Expense",
      "Statement"
    ]
  },
  "ReceiptDollarIcon": {
    "id": "ReceiptDollarIcon",
    "name": "Receipt dollar",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "ReceiptEuroFilledIcon": {
    "id": "ReceiptEuroFilledIcon",
    "name": "Receipt euro filled",
    "description": "N/A",
    "keywords": [
      "Euro",
      "Receipt",
      "Invoice",
      "Bill",
      "Payment",
      "Receipt",
      "Purchase",
      "Transaction",
      "Proof",
      "Expense",
      "Statement"
    ]
  },
  "ReceiptEuroIcon": {
    "id": "ReceiptEuroIcon",
    "name": "Receipt euro",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "ReceiptIcon": {
    "id": "ReceiptIcon",
    "name": "Receipt",
    "description": "Used to represent a sales receipt or invoice.",
    "keywords": [
      "invoice",
      "receipt",
      "sale"
    ]
  },
  "ReceiptPaidIcon": {
    "id": "ReceiptPaidIcon",
    "name": "Receipt paid",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "ReceiptPoundFilledIcon": {
    "id": "ReceiptPoundFilledIcon",
    "name": "Receipt pound filled",
    "description": "N/A",
    "keywords": [
      "Pound",
      "Receipt",
      "Invoice",
      "Bill",
      "Payment",
      "Receipt",
      "Purchase",
      "Transaction",
      "Proof",
      "Expense",
      "Statement"
    ]
  },
  "ReceiptPoundIcon": {
    "id": "ReceiptPoundIcon",
    "name": "Receipt pound",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "ReceiptRefundIcon": {
    "id": "ReceiptRefundIcon",
    "name": "Receipt refund",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "ReceiptRupeeFilledIcon": {
    "id": "ReceiptRupeeFilledIcon",
    "name": "Receipt rupee filled",
    "description": "N/A",
    "keywords": [
      "Rupee",
      "Receipt",
      "Invoice",
      "Bill",
      "Payment",
      "Receipt",
      "Purchase",
      "Transaction",
      "Proof",
      "Expense",
      "Statement"
    ]
  },
  "ReceiptRupeeIcon": {
    "id": "ReceiptRupeeIcon",
    "name": "Receipt rupee",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "ReceiptYenFilledIcon": {
    "id": "ReceiptYenFilledIcon",
    "name": "Receipt yen filled",
    "description": "N/A",
    "keywords": [
      "Yen",
      "Receipt",
      "Invoice",
      "Bill",
      "Payment",
      "Receipt",
      "Purchase",
      "Transaction",
      "Proof",
      "Expense",
      "Statement"
    ]
  },
  "ReceiptYenIcon": {
    "id": "ReceiptYenIcon",
    "name": "Receipt yen",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "RedoIcon": {
    "id": "RedoIcon",
    "name": "Redo",
    "description": "Used to indicate redoing an action after undoing it.",
    "keywords": [
      "redo",
      "undo",
      "rollback",
      "return"
    ]
  },
  "ReferralCodeIcon": {
    "id": "ReferralCodeIcon",
    "name": "Referral code",
    "description": "Used to represent a referral code’s usage status.",
    "keywords": [
      "referral",
      "code",
      "coupon"
    ]
  },
  "RefreshIcon": {
    "id": "RefreshIcon",
    "name": "Refresh",
    "description": "Used to denote the action of resetting a customer’s account password on their customer page.",
    "keywords": [
      "refresh",
      "reload",
      "sync"
    ]
  },
  "RemoveBackgroundIcon": {
    "id": "RemoveBackgroundIcon",
    "name": "Remove background",
    "description": "Used to signify the background removal feature in Magic media editing.",
    "keywords": [
      "Magic",
      "Background",
      "Removal",
      "Media"
    ]
  },
  "ReplaceIcon": {
    "id": "ReplaceIcon",
    "name": "Replace",
    "description": "Used to represent an action to replace an item or resource with another.",
    "keywords": [
      "replace",
      "image",
      "picture",
      "photo",
      "switch",
      "swap",
      "arrow",
      "arrows",
      "square"
    ]
  },
  "ReplayIcon": {
    "id": "ReplayIcon",
    "name": "Replay",
    "description": "Used to represent an action to replay or restart something.",
    "keywords": [
      "replay",
      "restart"
    ]
  },
  "ResetIcon": {
    "id": "ResetIcon",
    "name": "Reset",
    "description": "Used to represent an action to reset or restart something.",
    "keywords": [
      "reset",
      "restart"
    ]
  },
  "ReturnIcon": {
    "id": "ReturnIcon",
    "name": "Return",
    "description": "Used to represent an action to create a new line, sometimes referred to as a carriage return.",
    "keywords": [
      "enter",
      "return"
    ]
  },
  "RewardIcon": {
    "id": "RewardIcon",
    "name": "Reward",
    "description": "Used to represent the concept of a reward, prize or loyalty.",
    "keywords": [
      "rewards",
      "loyalty",
      "incentive",
      "bonus",
      "perks",
      "benefits",
      "appreciation",
      "prize",
      "recognition"
    ]
  },
  "RotateLeftIcon": {
    "id": "RotateLeftIcon",
    "name": "Rotate left",
    "description": "Used in media editing for rotating an image counterclockwise.",
    "keywords": [
      "Rotate",
      "Left",
      "Counterclockwise"
    ]
  },
  "RotateRightIcon": {
    "id": "RotateRightIcon",
    "name": "Rotate right",
    "description": "Used in media editing for rotating an image clockwise.",
    "keywords": [
      "Rotate",
      "Right",
      "Clockwise"
    ]
  },
  "SandboxIcon": {
    "id": "SandboxIcon",
    "name": "Sandbox",
    "description": "Used to represent a development store (feature exclusive to Shopify Plus Partners).",
    "keywords": [
      "sandbox",
      "plus",
      "partners",
      "partner",
      "development",
      "testing"
    ]
  },
  "SaveIcon": {
    "id": "SaveIcon",
    "name": "Save",
    "description": "Used to denote the action of saving.",
    "keywords": [
      "save",
      "saving",
      "store"
    ]
  },
  "SearchIcon": {
    "id": "SearchIcon",
    "name": "Search",
    "description": "Used to denote the action of searching throughout the admin.",
    "keywords": [
      "search",
      "find",
      "glass"
    ]
  },
  "SearchListIcon": {
    "id": "SearchListIcon",
    "name": "Search list",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "SearchRecentIcon": {
    "id": "SearchRecentIcon",
    "name": "Search recent",
    "description": "Used to represent recent searches or search history.",
    "keywords": [
      "history",
      "recent",
      "recent search",
      "search history"
    ]
  },
  "SearchResourceIcon": {
    "id": "SearchResourceIcon",
    "name": "Search resource",
    "description": "N/A",
    "keywords": [
      "Report",
      "Explore"
    ]
  },
  "SelectIcon": {
    "id": "SelectIcon",
    "name": "Select",
    "description": "Used to denote the action opening a select.",
    "keywords": [
      "caret",
      "arrow",
      "up",
      "down",
      "select",
      "open"
    ]
  },
  "SendIcon": {
    "id": "SendIcon",
    "name": "Send",
    "description": "Used to represent an action to send a message, commonly used in a chat UI.",
    "keywords": [
      "send",
      "mail",
      "plane",
      "message",
      "chat"
    ]
  },
  "SettingsFilledIcon": {
    "id": "SettingsFilledIcon",
    "name": "Settings filled",
    "description": "Used to represent settings or a configuration option.",
    "keywords": [
      "configure",
      "settings",
      "cog"
    ]
  },
  "SettingsIcon": {
    "id": "SettingsIcon",
    "name": "Settings",
    "description": "Used to represent settings or a configuration option.",
    "keywords": [
      "configure",
      "settings",
      "cog"
    ]
  },
  "ShareIcon": {
    "id": "ShareIcon",
    "name": "Share",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "ShieldCheckMarkIcon": {
    "id": "ShieldCheckMarkIcon",
    "name": "Shield check mark",
    "description": "Used to represent a secure or protected item or resource, or than an item or resource can be trusted.",
    "keywords": [
      "protected",
      "secure",
      "trust",
      "verified"
    ]
  },
  "ShieldNoneIcon": {
    "id": "ShieldNoneIcon",
    "name": "Shield none",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "ShieldPendingIcon": {
    "id": "ShieldPendingIcon",
    "name": "Shield pending",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "ShieldPersonIcon": {
    "id": "ShieldPersonIcon",
    "name": "Shield person",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "ShippingLabelFilledIcon": {
    "id": "ShippingLabelFilledIcon",
    "name": "Shipping label filled",
    "description": "Used to represent shipping labels.",
    "keywords": [
      "Label",
      "Shipping",
      "Delivery",
      "Package",
      "Postage",
      "Parcel"
    ]
  },
  "ShippingLabelIcon": {
    "id": "ShippingLabelIcon",
    "name": "Shipping label",
    "description": "Used to represent shipping labels.",
    "keywords": [
      "Label",
      "Shipping",
      "Delivery",
      "Package",
      "Postage",
      "Parcel"
    ]
  },
  "ShopcodesIcon": {
    "id": "ShopcodesIcon",
    "name": "Shopcodes",
    "description": "Used to represent a QR code.",
    "keywords": [
      "qr code"
    ]
  },
  "SidekickIcon": {
    "id": "SidekickIcon",
    "name": "Sidekick",
    "description": "Used to denote Sidekick features and toggling Sidekick on/off.",
    "keywords": [
      "magic",
      "sidekick",
      "chat"
    ]
  },
  "SkeletonIcon": {
    "id": "SkeletonIcon",
    "name": "Skeleton",
    "description": "Used as a placeholder for Icons loaded in the future.",
    "keywords": [
      "N/A"
    ]
  },
  "SlideshowIcon": {
    "id": "SlideshowIcon",
    "name": "Slideshow",
    "description": "Used to represent a slideshow or series of images.",
    "keywords": [
      "slides",
      "slideshow",
      "image",
      "photo",
      "picture",
      "thumbnail",
      "dots",
      "swipe"
    ]
  },
  "SmileyHappyIcon": {
    "id": "SmileyHappyIcon",
    "name": "Smiley happy",
    "description": "Used to represent a happy customer or user, a smiling face or a smiley emoji.",
    "keywords": [
      "smiley",
      "happy",
      "emoji"
    ]
  },
  "SmileyJoyIcon": {
    "id": "SmileyJoyIcon",
    "name": "Smiley joy",
    "description": "Used to represent a very happy customer or user, a smiling face or a smiley emoji.",
    "keywords": [
      "smiley",
      "happy",
      "ecstatic",
      "emoji"
    ]
  },
  "SmileyNeutralIcon": {
    "id": "SmileyNeutralIcon",
    "name": "Smiley neutral",
    "description": "Used to represent a neutral customer or user, a neutral face or a neutral emoji.",
    "keywords": [
      "neutral",
      "emoji"
    ]
  },
  "SmileySadIcon": {
    "id": "SmileySadIcon",
    "name": "Smiley sad",
    "description": "Used to represent a sad customer or user, a sad face or a sad emoji.",
    "keywords": [
      "sad",
      "emoji"
    ]
  },
  "SocialAdIcon": {
    "id": "SocialAdIcon",
    "name": "Social ad",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "SocialPostIcon": {
    "id": "SocialPostIcon",
    "name": "Social post",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "SortAscendingIcon": {
    "id": "SortAscendingIcon",
    "name": "Sort ascending",
    "description": "Used to indicate that a list of items or resources has been sorted by ascending order.",
    "keywords": [
      "ascending",
      "sort",
      "order"
    ]
  },
  "SortDescendingIcon": {
    "id": "SortDescendingIcon",
    "name": "Sort descending",
    "description": "Used to indicate that a list of items or resources has been sorted by descending order.",
    "keywords": [
      "descending",
      "sort",
      "order"
    ]
  },
  "SortIcon": {
    "id": "SortIcon",
    "name": "Sort",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "SoundIcon": {
    "id": "SoundIcon",
    "name": "Sound",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "SportsIcon": {
    "id": "SportsIcon",
    "name": "Sports",
    "description": "Used as a navigation item in our emoji picker for the activities category.",
    "keywords": [
      "emoji",
      "navigation",
      "football",
      "ball",
      "activity"
    ]
  },
  "StarFilledIcon": {
    "id": "StarFilledIcon",
    "name": "Star filled",
    "description": "N/A",
    "keywords": [
      "star",
      "starred",
      "favourite",
      "favorite"
    ]
  },
  "StarIcon": {
    "id": "StarIcon",
    "name": "Star",
    "description": "N/A",
    "keywords": [
      "favorite",
      "favourite",
      "starred",
      "star"
    ]
  },
  "StatusActiveIcon": {
    "id": "StatusActiveIcon",
    "name": "Status active",
    "description": "Used to represent a resource that is in an Active state.",
    "keywords": [
      "active",
      "tick",
      "good",
      "positive",
      "checkmark",
      "circle",
      "round",
      "approve"
    ]
  },
  "StatusIcon": {
    "id": "StatusIcon",
    "name": "Status",
    "description": "Used to represent the activity of a shop or store.",
    "keywords": [
      "status",
      "activity"
    ]
  },
  "StopCircleIcon": {
    "id": "StopCircleIcon",
    "name": "Stop circle",
    "description": "Used to represent a stop action.",
    "keywords": [
      "stop"
    ]
  },
  "StoreFilledIcon": {
    "id": "StoreFilledIcon",
    "name": "Store filled",
    "description": "Used to represent a store or shop.",
    "keywords": [
      "store",
      "shop"
    ]
  },
  "StoreIcon": {
    "id": "StoreIcon",
    "name": "Store",
    "description": "Used to represent a store or shop.",
    "keywords": [
      "store",
      "shop"
    ]
  },
  "StoreImportIcon": {
    "id": "StoreImportIcon",
    "name": "Store import",
    "description": "N/A",
    "keywords": [
      "Import",
      "Store"
    ]
  },
  "StoreManagedIcon": {
    "id": "StoreManagedIcon",
    "name": "Store managed",
    "description": "Used to represent a managed or approved store.",
    "keywords": [
      "approved",
      "managed",
      "store"
    ]
  },
  "StoreOnlineIcon": {
    "id": "StoreOnlineIcon",
    "name": "Store online",
    "description": "Used to represent an online store.",
    "keywords": [
      "online store",
      "store"
    ]
  },
  "SunIcon": {
    "id": "SunIcon",
    "name": "Sun",
    "description": "Indicates day or light mode.",
    "keywords": [
      "day",
      "light",
      "sun"
    ]
  },
  "TabletIcon": {
    "id": "TabletIcon",
    "name": "Tablet",
    "description": "Used to represent a tablet.",
    "keywords": [
      "tablet",
      "ipad"
    ]
  },
  "TargetFilledIcon": {
    "id": "TargetFilledIcon",
    "name": "Target filled",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "TargetIcon": {
    "id": "TargetIcon",
    "name": "Target",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "TaxFilledIcon": {
    "id": "TaxFilledIcon",
    "name": "Tax filled",
    "description": "Used to represent sales tax or a tax receipt.",
    "keywords": [
      "sales tax",
      "tax reciept",
      "tax"
    ]
  },
  "TaxIcon": {
    "id": "TaxIcon",
    "name": "Tax",
    "description": "Used to represent sales tax or a tax receipt.",
    "keywords": [
      "sales tax",
      "tax reciept",
      "tax"
    ]
  },
  "TeamIcon": {
    "id": "TeamIcon",
    "name": "Team",
    "description": "N/A",
    "keywords": [
      "connect",
      "connected",
      "path",
      "team",
      "related"
    ]
  },
  "TextAlignCenterIcon": {
    "id": "TextAlignCenterIcon",
    "name": "Text align center",
    "description": "Icon indicating alignment of text at the center",
    "keywords": [
      "align",
      "alignment",
      "center",
      "rte",
      "text"
    ]
  },
  "TextAlignLeftIcon": {
    "id": "TextAlignLeftIcon",
    "name": "Text align left",
    "description": "Icon indicating alignment of text on the left side",
    "keywords": [
      "align",
      "alignment",
      "left",
      "rte",
      "text"
    ]
  },
  "TextAlignRightIcon": {
    "id": "TextAlignRightIcon",
    "name": "Text align right",
    "description": "Icon indicating alignment of text on the right side",
    "keywords": [
      "align",
      "alignment",
      "right",
      "rte",
      "text"
    ]
  },
  "TextBlockIcon": {
    "id": "TextBlockIcon",
    "name": "Text block",
    "description": "Used to represent a paragraph or block of text.",
    "keywords": [
      "text",
      "paragraph"
    ]
  },
  "TextBoldIcon": {
    "id": "TextBoldIcon",
    "name": "Text bold",
    "description": "Used to format text with an emphasized style.",
    "keywords": [
      "text format",
      "bold",
      "strong",
      "rich text",
      "rte",
      "format",
      "text",
      "text editing"
    ]
  },
  "TextColorIcon": {
    "id": "TextColorIcon",
    "name": "Text color",
    "description": "Used to format text with a specific color.",
    "keywords": [
      "text format",
      "color",
      "colour",
      "rich text",
      "rte",
      "format",
      "text",
      "text editing"
    ]
  },
  "TextFontIcon": {
    "id": "TextFontIcon",
    "name": "Text font",
    "description": "Used to represent a typeface or an action to change the properties of a typeface or body of text.",
    "keywords": [
      "typography",
      "font",
      "typeface",
      "type",
      "letter",
      "text"
    ]
  },
  "TextFontListIcon": {
    "id": "TextFontListIcon",
    "name": "Text font list",
    "description": "Used to represent a list of typefaces.",
    "keywords": [
      "typography",
      "font",
      "typeface",
      "type",
      "letter",
      "text",
      "list"
    ]
  },
  "TextGrammarIcon": {
    "id": "TextGrammarIcon",
    "name": "Text grammar",
    "description": "Used to represent correct grammar or a spell check.",
    "keywords": [
      "grammar",
      "spell check",
      "spelling"
    ]
  },
  "TextIcon": {
    "id": "TextIcon",
    "name": "Text",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "TextInColumnsIcon": {
    "id": "TextInColumnsIcon",
    "name": "Text in columns",
    "description": "Used to represent a layout option of two columns, each featuring an image and text.",
    "keywords": [
      "paper",
      "page",
      "content",
      "featured",
      "section",
      "columns",
      "text",
      "image",
      "photo",
      "picture",
      "writing",
      "copy"
    ]
  },
  "TextInRowsFilledIcon": {
    "id": "TextInRowsFilledIcon",
    "name": "Text in rows filled",
    "description": "N/A",
    "keywords": [
      "store"
    ]
  },
  "TextInRowsIcon": {
    "id": "TextInRowsIcon",
    "name": "Text in rows",
    "description": "N/A",
    "keywords": [
      "store"
    ]
  },
  "TextIndentIcon": {
    "id": "TextIndentIcon",
    "name": "Text indent",
    "description": "Used to increase text indentation with list formatting.",
    "keywords": [
      "text format",
      "list",
      "rich text",
      "rte",
      "format",
      "text",
      "text editing"
    ]
  },
  "TextItalicIcon": {
    "id": "TextItalicIcon",
    "name": "Text italic",
    "description": "Used to format text with an italicized style.",
    "keywords": [
      "text format",
      "italic",
      "italicize",
      "rich text",
      "rte",
      "format",
      "text",
      "text editing"
    ]
  },
  "TextQuoteIcon": {
    "id": "TextQuoteIcon",
    "name": "Text quote",
    "description": "Used to represent a quote.",
    "keywords": [
      "blockquote",
      "testimonials",
      "quote",
      "speech",
      "text",
      "sections",
      "writing",
      "content"
    ]
  },
  "TextTitleIcon": {
    "id": "TextTitleIcon",
    "name": "Text title",
    "description": "Used to represent a title or heading block appearing as a sub-element of a section, page or layout.",
    "keywords": [
      "title",
      "heading",
      "subheading",
      "content",
      "block"
    ]
  },
  "TextUnderlineIcon": {
    "id": "TextUnderlineIcon",
    "name": "Text underline",
    "description": "Used to format text with an underline.",
    "keywords": [
      "text format",
      "stroke",
      "formatting",
      "rich text",
      "rte",
      "format",
      "text",
      "text editing"
    ]
  },
  "TextWithImageIcon": {
    "id": "TextWithImageIcon",
    "name": "Text with image",
    "description": "Used to denote rich text",
    "keywords": [
      "rich text",
      "RTE",
      "rich text editor"
    ]
  },
  "ThemeEditIcon": {
    "id": "ThemeEditIcon",
    "name": "Theme edit",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "ThemeIcon": {
    "id": "ThemeIcon",
    "name": "Theme",
    "description": "Used to indicate free themes in the Shopify theme store.",
    "keywords": [
      "theme",
      "free",
      "customize"
    ]
  },
  "ThemeStoreIcon": {
    "id": "ThemeStoreIcon",
    "name": "Theme store",
    "description": "Used to represent the Shopify theme store.",
    "keywords": [
      "theme",
      "store",
      "shop",
      "customize"
    ]
  },
  "ThemeTemplateIcon": {
    "id": "ThemeTemplateIcon",
    "name": "Theme template",
    "description": "Used to represent templates.",
    "keywords": [
      "template",
      "theme",
      "section",
      "editor",
      "online store"
    ]
  },
  "ThumbsDownIcon": {
    "id": "ThumbsDownIcon",
    "name": "Thumbs down",
    "description": "Used to represent an action to dislike or disapprove of something.",
    "keywords": [
      "down",
      "thumbs down",
      "no",
      "downvote",
      "dislike",
      "disapprove",
      "negative",
      "social"
    ]
  },
  "ThumbsUpIcon": {
    "id": "ThumbsUpIcon",
    "name": "Thumbs up",
    "description": "Used to represent an action to like or approve of something.",
    "keywords": [
      "social",
      "thumbs up",
      "hand",
      "like",
      "approve",
      "positive",
      "yes",
      "upvote"
    ]
  },
  "TipJarIcon": {
    "id": "TipJarIcon",
    "name": "Tip jar",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "ToggleOffIcon": {
    "id": "ToggleOffIcon",
    "name": "Toggle off",
    "description": "Used to dennote that an element is toggled off.",
    "keywords": [
      "toggle",
      "setting",
      "switch"
    ]
  },
  "ToggleOnIcon": {
    "id": "ToggleOnIcon",
    "name": "Toggle on",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "TransactionFeeDollarIcon": {
    "id": "TransactionFeeDollarIcon",
    "name": "Transaction fee dollar",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "TransactionFeeEuroIcon": {
    "id": "TransactionFeeEuroIcon",
    "name": "Transaction fee euro",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "TransactionFeePoundIcon": {
    "id": "TransactionFeePoundIcon",
    "name": "Transaction fee pound",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "TransactionFeeRupeeIcon": {
    "id": "TransactionFeeRupeeIcon",
    "name": "Transaction fee rupee",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "TransactionFeeYenIcon": {
    "id": "TransactionFeeYenIcon",
    "name": "Transaction fee yen",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "TransactionIcon": {
    "id": "TransactionIcon",
    "name": "Transaction",
    "description": "Used to represent an action to customize an item or resource.",
    "keywords": [
      "tools",
      "options",
      "settings",
      "customize",
      "configure"
    ]
  },
  "TransferIcon": {
    "id": "TransferIcon",
    "name": "Transfer",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "TransferInIcon": {
    "id": "TransferInIcon",
    "name": "Transfer in",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "TransferInternalIcon": {
    "id": "TransferInternalIcon",
    "name": "Transfer internal",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "TransferOutIcon": {
    "id": "TransferOutIcon",
    "name": "Transfer out",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "UndoIcon": {
    "id": "UndoIcon",
    "name": "Undo",
    "description": "Used to indicate undoing an action in an editor context.",
    "keywords": [
      "redo",
      "undo",
      "return",
      "cancel"
    ]
  },
  "UnknownDeviceIcon": {
    "id": "UnknownDeviceIcon",
    "name": "Unknown device",
    "description": "Used to represent an unknown device, item or resource.",
    "keywords": [
      "unknown",
      "device"
    ]
  },
  "UploadIcon": {
    "id": "UploadIcon",
    "name": "Upload",
    "description": "Used to represent the ability to upload a file",
    "keywords": [
      "upload",
      "file",
      "arrow",
      "up"
    ]
  },
  "VariantIcon": {
    "id": "VariantIcon",
    "name": "Variant",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "ViewIcon": {
    "id": "ViewIcon",
    "name": "View",
    "description": "Used to denote the action of previewing an online store.",
    "keywords": [
      "view",
      "preview",
      "eye",
      "eyeball",
      "look",
      "see",
      "show",
      "reveal"
    ]
  },
  "ViewportNarrowIcon": {
    "id": "ViewportNarrowIcon",
    "name": "Viewport narrow",
    "description": "Used to represent an action to make a viewport, item or resource narrower.",
    "keywords": [
      "viewport",
      "narrow",
      "arrows",
      "horizontal",
      "left",
      "right"
    ]
  },
  "ViewportShortIcon": {
    "id": "ViewportShortIcon",
    "name": "Viewport short",
    "description": "Used to represent an action to make a viewport, item or resource shorter.",
    "keywords": [
      "viewport",
      "short",
      "arrows",
      "vertical",
      "up",
      "down"
    ]
  },
  "ViewportTallIcon": {
    "id": "ViewportTallIcon",
    "name": "Viewport tall",
    "description": "Used to represent an action to make a viewport, item or resource taller.",
    "keywords": [
      "viewport",
      "tall",
      "arrows",
      "vertical",
      "up",
      "down"
    ]
  },
  "ViewportWideIcon": {
    "id": "ViewportWideIcon",
    "name": "Viewport wide",
    "description": "Used to represent an action to make a viewport, item or resource wider.",
    "keywords": [
      "viewport",
      "wide",
      "arrows",
      "horizontal",
      "left",
      "right"
    ]
  },
  "WalletFilledIcon": {
    "id": "WalletFilledIcon",
    "name": "Wallet filled",
    "description": "The account’s current balance. This amount is comprised of any transaction not yet included in a payout.",
    "keywords": [
      "balance",
      "wallet",
      "money",
      "transaction",
      "payout"
    ]
  },
  "WalletIcon": {
    "id": "WalletIcon",
    "name": "Wallet",
    "description": "The account’s current balance. This amount is comprised of any transaction not yet included in a payout.",
    "keywords": [
      "balance",
      "wallet",
      "money",
      "transaction",
      "payout"
    ]
  },
  "WandIcon": {
    "id": "WandIcon",
    "name": "Wand",
    "description": "Used to represent an action to perform an automatic process or series of processes.",
    "keywords": [
      "magic",
      "wand",
      "automatic"
    ]
  },
  "WatchIcon": {
    "id": "WatchIcon",
    "name": "Watch",
    "description": "Used to represent a wearable device or wristwatch.",
    "keywords": [
      "wearable",
      "watch",
      "wristwatch"
    ]
  },
  "WifiIcon": {
    "id": "WifiIcon",
    "name": "Wifi",
    "description": "N/A",
    "keywords": [
      "N/A"
    ]
  },
  "WorkFilledIcon": {
    "id": "WorkFilledIcon",
    "name": "Work filled",
    "description": "N/A",
    "keywords": [
      "Job",
      "Briefcase",
      "Work",
      "Luggage",
      "Business"
    ]
  },
  "WorkIcon": {
    "id": "WorkIcon",
    "name": "Work",
    "description": "N/A",
    "keywords": [
      "Job",
      "Briefcase",
      "Work",
      "Luggage",
      "Business"
    ]
  },
  "WrenchIcon": {
    "id": "WrenchIcon",
    "name": "Wrench",
    "description": "Used to represent an action to troubleshoot or view troubleshooting information.",
    "keywords": [
      "tools",
      "spanner",
      "wrench",
      "troubleshoot"
    ]
  },
  "XCircleIcon": {
    "id": "XCircleIcon",
    "name": "X circle",
    "description": "Used to represent an action to cancel or remove an item or resource.",
    "keywords": [
      "cancel",
      "delete",
      "stop",
      "remove",
      "x"
    ]
  },
  "XIcon": {
    "id": "XIcon",
    "name": "X",
    "description": "Used to denote the action of cancelling a task or action and to close an overlay modal or bottom sheet.",
    "keywords": [
      "cancel",
      "delete",
      "stop",
      "remove",
      "undo",
      "x",
      "close"
    ]
  },
  "XSmallIcon": {
    "id": "XSmallIcon",
    "name": "X small",
    "description": "N/A",
    "keywords": [
      "cancel",
      "stop",
      "undo",
      "remove",
      "x"
    ]
  }
};

export { metadata as default };
