import React from 'react';
import { BrowserRouter as Router, Routes, Route, useLocation } from 'react-router-dom';
import { AppProvider } from '@shopify/polaris';
import '@shopify/polaris/build/esm/styles.css';
import Layout from './components/Layout';
import Dashboard from './components/Dashboard';
import Products from './components/Products';
import AmazonAccount from './components/AmazonAccount';
import Settings from './components/Settings';
import PlanPricing from './components/PlanPricing';
import FAQs from './components/FAQs';
import Footer from './components/common/Footer';
import "./App.css";
function App() {
  
  return (
    <AppProvider>
      <Router>
        <Layout>
          <Routes>
            <Route path="/" element={<Dashboard />} />
            <Route path="/products" element={<Products />} />
            <Route path="/amazon-account" element={<AmazonAccount />} />
            <Route path="/settings" element={<Settings />} />
            <Route path="/plan-pricing" element={<PlanPricing />} />
            <Route path="/faqs" element={<FAQs />} />
          </Routes>
        </Layout>
      </Router>
      {/* <Footer/> */}
    </AppProvider>
  );
}

export default App;
