import React, { useState, useEffect, useCallback } from 'react';
import { TopBar, Text } from '@shopify/polaris';
import { useNavigate } from 'react-router-dom';
import { authUtils } from '../../utils/auth';

function Header({ onNavigationToggle }) {
  const navigate = useNavigate();
  const [userSession, setUserSession] = useState(null);
  const [isUserMenuOpen, setIsUserMenuOpen] = useState(false);

  const toggleIsUserMenuOpen = useCallback(() => {
    setIsUserMenuOpen((open) => !open);
  }, []);

  useEffect(() => {
    // Get user data from localStorage
    const userData = authUtils.getUserData();
    if (userData) {
      setUserSession({ user: userData });
    }
  }, []);

  const handleLogOut = () => {
    authUtils.clearAuthData();
    navigate('/login');
  };

  const userName = userSession?.user?.shopurl || '';
  const userInitials = userName.charAt(0).toUpperCase();

  const userMenuMarkup = (
    <TopBar.UserMenu
      actions={[
        {
          items: [{ content: 'Logout', onAction: handleLogOut }]
        }
      ]}
      name={userName}
      detail=""
      initials={userInitials}
      open={isUserMenuOpen}
      onToggle={toggleIsUserMenuOpen}
    />
  );

  const searchFieldMarkup = (
    <Text variant="headingXl" as="h1" tone="text-inverse">Xpert Importer</Text>
  );

  return (
    <TopBar
      showNavigationToggle
      userMenu={userMenuMarkup}
      searchResultsVisible={false}
      searchField={searchFieldMarkup}
      onNavigationToggle={onNavigationToggle}
    />
  );
}

export default Header;
