<?php

namespace App\Http\Controllers;

use App\EbCategory;
use App\EbCategoryMapping;
use Illuminate\Http\Request;

use App\Http\Requests;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\App;
use Illuminate\Support\Facades\Auth;
use Symfony\Component\Translation\Tests\Dumper\IniFileDumperTest;
use Validator;
use File;
use Illuminate\Support\Facades\Log;
use Carbon\Carbon;

class EbCategoryMappingController extends Controller
{
    public function __construct()
    {
        // Apply the jwt.auth middleware to all methods in this controller
        // except for the authenticate method. We don't want to prevent
        // the user from retrieving their token if they don't already have it
        $this->middleware('jwt.auth', ['except' => ['authenticate']]);
    }
	
	public function search(Request $request) {
	    $per_page = \Request::get('per_page') ?: 20;
		$currUser = Auth::User();
        ### search
        if ($request['query']) {
			$mappings = $currUser->ebCategoryMappings()->where('product_id', 'like', '%'.$request['query'].'%')->paginate($per_page);
			return $mappings;
		} else {
			return $this->index();
		}
    }

    public function index() {
		$per_page = \Request::get('per_page') ?: 20;
	    $currUser = Auth::User();
		$mappings = $currUser->ebCategoryMappings()->paginate($per_page);
		return $mappings;
	}    
	
	public function show($id) {
		$currUser = Auth::User();
		$mapping = $currUser->ebCategoryMappings()->where('product_id', $id)->first();		
		if(!$mapping){
			return response()->json([], 201);
		} else {
			return $mapping;
		}        
        return $mapping;
    }

	public function store(Request $request) {
		$currUser = Auth::User();
		$validator = Validator::make($request->all(), [
						'product_id' => 'required',
						'eb_category_id' => 'required'], [
						'product_id.required' => 'Product ID is required.',
						'name.max' => 'eBay category is required.']);
		if ($validator->fails()) {
			return response()->json(['error' => $validator->errors()], 406);
		}
		$product_id = $request->input('product_id');
		$eb_category_id = $request->input('eb_category_id');
		$tempArr = explode(",", $product_id);
		$count = count($tempArr);
		if($count == 0){
			return response()->json(['error' => ["msg"=>["Please choose atleast one product."]]], 406);
		}
		$category_name = $this->getCategoryPath($eb_category_id);
		if(strlen($category_name) > 0){
			$category_name = substr($category_name, 3);
			$request["eb_category_name"] = $category_name;
		}		
		foreach($tempArr as $temp){
			$requestData = array("product_id" => $temp, "eb_category_id" => $eb_category_id, "eb_category_name" => $category_name);
			$existingMapping = $currUser->ebCategoryMappings()->where('product_id', '=', $temp)->first();
			if($existingMapping){
				$existingMapping->update($requestData);            	
			} else {
				$Request = EbCategoryMapping::create($requestData);
				$currUser->ebCategoryMappings()->save($Request);					
			}
		}
		return response()->json(['eb_category_name' => $category_name], 200);
    }

	private function getCategoryPath($category_id) {
		$path = "";
		$category = EbCategory::where('category_id', '=', $category_id)->first();
		if($category){
			$category_name = $category->category_name;
			$parent_category_id = $category->parent_category_id;
			$category_level = $category->category_level;
			if($category_level > 1){
				$path = $path.$this->getCategoryPath($parent_category_id);
			}
			$path = $path." > ".$category_name;
		}
		return $path;
	}
}