<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Nicolaslopezj\Searchable\SearchableTrait;

class Product extends Model {
	
	use SearchableTrait;
    protected $searchable = [
        'columns' => [            
            'product_variants.sku' => 30,
          /*  'product_variants.asin' => 40,*/
            'products.title' => 50,
        ],
        'joins' => [
            'product_variants' => ['product_variants.product_id','products.product_id'],            
        ],
		'groupBy' => ['products.product_id']
    ];

	protected $table = 'products';

	protected $primaryKey = 'product_id';

    public function user() {
		return $this->belongsTo('App\User', 'user_id', 'id');
	}
	
	public function variants() {
		return $this->hasMany('App\ProductVariant', 'product_id', 'product_id');
	}

	public function variantsCount() {
		return $this->hasOne('App\ProductVariant', 'product_id', 'product_id')->selectRaw('product_id, count(*) as no_of_variants, sum(quantity) as quantity')->groupBy('product_id');
	}
	
	public function dupProduct() {
		return $this->hasOne('App\DupProduct', 'orig_product_id', 'product_id');
	}
	
	public function imgReimportRequests() {
		return $this->hasMany('App\ImgReimportRequests', 'product_id', 'product_id');
	}

    protected $fillable = [
        'user_id', 'title', 'description', 'feature1', 'feature2', 'feature3', 'feature4', 'feature5', 'item_note', 'brand', 'product_type', 'option1name', 'option2name', 'option3name', 'shopifyproductid', 'newflag', 'quantityflag', 'priceflag', 'searchstring', 'fulfillment', 'ebayitemid', 'wpid','block', 'deleted'
	];
	
}
