<?php

namespace App\Http\Controllers;

use App\EbProduct;
use App\EbProductVariant;
use Illuminate\Http\Request;

use App\Http\Requests;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\App;
use Illuminate\Support\Facades\Auth;
use Symfony\Component\Translation\Tests\Dumper\IniFileDumperTest;
use Validator;
use File;
use Illuminate\Support\Facades\Log;
use Carbon\Carbon;
use Maatwebsite\Excel\Facades\Excel;

class EbProductController extends Controller
{
    public function __construct()
    {
        // Apply the jwt.auth middleware to all methods in this controller
        // except for the authenticate method. We don't want to prevent
        // the user from retrieving their token if they don't already have it
        $this->middleware('jwt.auth', ['except' => ['authenticate']]);
    }

	public function search(Request $request)
    {
        $per_page = \Request::get('per_page') ?: 20;
		$currUser = Auth::User();
        ### search
        if ($request['query']) {		
			$products = $currUser->ebProducts()->where('title', 'like', '%'.$request['query'].'%')->with('variants')->with('variantsCount');
			return $products->paginate($per_page);						
        } else {
			return $this->index();
		}
    }

    public function index()
    {
        $per_page = \Request::get('per_page') ?: 20;
	    $currUser = Auth::User();
		$products = $currUser->ebProducts()->with('variants')->with('variantsCount')->paginate($per_page);
		return $products;		
	}    
	
	public function block($id){
		$temp = explode(",", $id);
		$count = count($temp);
		if($count == 0){
			return response()->json(['error' => ["msg"=>["Please choose atleast one product."]]], 406);
		}
		$currUser = Auth::User();
		$blockedCount = $currUser->ebProducts()->whereIn('product_id', $temp)->where(function ($query) {
			$query->where('block', '=', 1)->orWhere('status', '!=', 'Ready to Import');
				})->count();
		if($blockedCount > 0){
			$errMsg = "The selected products could not be blocked.";
			if($count == 1){
				$errMsg = "The selected product could not be blocked.";
			}
			return response()->json(['error' => ["msg"=>[$errMsg]]], 406);
		}
		$currUser->ebProducts()->whereIn('product_id', $temp)->update(['block' => 1]);
		$currUser->ebProductvariants()->whereIn('product_id', $temp)->update(['block' => 1]);
        return response()->json(['success'], 200);
	}

	public function unblock($id){
		$temp = explode(",", $id);
		$count = count($temp);
		if($count == 0){
			return response()->json(['error' => ["msg"=>["Please choose atleast one product."]]], 406);
		}
		$currUser = Auth::User();
		$currUser->ebProducts()->whereIn('product_id', $temp)->update(['block' => 0]);
		$currUser->ebProductvariants()->whereIn('product_id', $temp)->update(['block' => 0]);
        return response()->json(['success'], 200);
	}

	public function push($id){
		if(!$this->validateMembership()){
			return response()->json(['error' => ["msg"=>["Your membership has been expired. Please activate the subscription to import more products."]]], 406);
		}
		$temp = explode(",", $id);
		$count = count($temp);
		if($count == 0){
			return response()->json(['error' => ["msg"=>["Please choose atleast one product."]]], 406);
		}
		$currUser = Auth::User();
		$count = $currUser->ebProducts()->whereIn('product_id', $temp)->where('status', '!=', 'Ready to Import')->count();
		if($count > 0){
			return response()->json(['error' => ["msg"=>['The selected products could not push to shopify.']]], 406);
		} else {
			$skulimit = $currUser->skulimit;
			$skuconsumed = $currUser->skuconsumed;
			$vcount = $currUser->ebProductvariants()->whereIn('product_id', $temp)->where('block', 0)->where('duplicate', 0)->where('status', '=', 'Ready to Import')->count();
			if($skulimit < ($skuconsumed + $vcount)){
				return response()->json(['error' => ["msg"=>['The number of SKUs you want to import is more than your allowed limit. Please upgrade your plan.']]], 406);				
			} else {
				$currUser->ebProducts()->whereIn('product_id', $temp)->where('block', 0)->where('duplicate', 0)->where('status', '=', 'Ready to Import')->update(['status' => 'Import in Progress']);
				$currUser->skuconsumed = $skuconsumed + $vcount;
				$currUser->save();
				return response()->json(['skuconsumed' => $currUser->skuconsumed], 200);
			}
		}
	}

	public function pushall(){	
		if(!$this->validateMembership()){
			return response()->json(['error' => ["msg"=>["Your membership has been expired. Please activate the subscription to import more products."]]], 406);
		}
		$currUser = Auth::User();
		$skulimit = $currUser->skulimit;
		$skuconsumed = $currUser->skuconsumed;
		/*$products = $currUser->products()->where('status', 'Ready to Import')->where('block', 0)->with('variantsCount')->get();
		$vcount = 0;
		foreach($products as $product){			
			$vcount  = $vcount + $product->variantsCount()->first()->no_of_variants;
		}*/
		$vcount = $currUser->ebProductvariants()->where('block', 0)->where('duplicate', 0)->where('status', '=', 'Ready to Import')->count();
		if($skulimit < ($skuconsumed + $vcount)){
			return response()->json(['error' => ["msg"=>['The number of SKUs you want to import is more than your allowed limit. Please upgrade your plan.']]], 406);			
		} else {
			$currUser->ebProducts()->where('status', 'Ready to Import')->where('block', 0)->where('duplicate', 0)->update(['status' => 'Import in Progress']);
			$currUser->skuconsumed = $skuconsumed + $vcount;
			$currUser->save();
			return response()->json(['skuconsumed' => $currUser->skuconsumed], 200);
		}		
	}
	
	private function validateMembership(){
		$currUser = Auth::User();
		$paid_at = $currUser->paid_at;
		$created_at = $currUser->created_at;
		$fromtime = new Carbon($paid_at);
		if(strtotime($paid_at) < 1){
			$fromtime = new Carbon($created_at);
		}		
		$now = Carbon::now();
		$difference = $fromtime->diffInDays($now);
		//Log::info("validateMembership : difference - ".$currUser->id." - ".$difference);
		if($difference > 30 && $currUser->sync == 0) {
			//Log::info("validateMembership : difference - ".$currUser->id." - ".$difference);
			return false;
		} else {
			return true;
		}
	}	
}