<?php

namespace App\Http\Controllers;

use App\Product;
use App\ProductVariant;
use App\AmzFeed;
use App\Task;
use App\ImgReimportRequests;
use Illuminate\Http\Request;

use App\Http\Requests;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\App;
use Illuminate\Support\Facades\Auth;
use Symfony\Component\Translation\Tests\Dumper\IniFileDumperTest;
use Validator;
use File;
use Illuminate\Support\Facades\Log;
use Carbon\Carbon;
use Maatwebsite\Excel\Facades\Excel;

class ProductController extends Controller
{
    public function __construct()
    {
        // Apply the jwt.auth middleware to all methods in this controller
        // except for the authenticate method. We don't want to prevent
        // the user from retrieving their token if they don't already have it
        $this->middleware('jwt.auth', ['except' => ['authenticate']]);
    }

   /* public function search(Request $request)
    {
        $per_page = \Request::get('per_page') ?: 10;
        ### search
        if ($request['query']) {
            $Product = Product::search($request['query'], null, false)->with('variants')->with('variantsCount')->get();
            $page = $Product->has('page') ? $Product->page - 1 : 0;
            $total = $Product->count();
            $Product = $Product->slice($page * $per_page, $per_page);
            $Product = new \Illuminate\Pagination\LengthAwarePaginator($Product, $total, $per_page);
            return $Product;
        }
        return 'not found';
    }*/

	public function search(Request $request)
    {
        $per_page = \Request::get('per_page') ?: 20;
		$currUser = Auth::User();
        ### search
        if ($request['query']) {
			if($currUser->id == '1768' || $currUser->id == '4879'){				
				$products = $currUser->products()->where('title','like','%'.$request['query'].'%')->with('variants')->with('variantsCount')->latest();
				return $products->paginate($per_page);
			} else if($currUser->id == '1872' || $currUser->id == '12533'){
				$query = $request['query'];
				$per_page = \Request::get('per_page') ?: 100;
				$products = $currUser->products()->where(function($q) use($query) {
								$q->where('title','like','%'.$query.'%')->orWhere('searchstring','like','%'.$query.'%')->orWhere('status', '=', $query)->orWhere('fulfillment', '=', $query);
							})->with('variants')->with('variantsCount')->orderBy('searchstring', 'asc');
				return $products->paginate($per_page);				
			} else if($currUser->id == '8554' || $currUser->id == '9732' || $currUser->id == '2008' || $currUser->id == '1618' || $currUser->id == '1737' || $currUser->id == '3732' || $currUser->id == '6373' || $currUser->id == '7702'){
				$query = $request['query'];
				$products = $currUser->products()->where(function($q) use ($query) {
									$q->where('title','like','%'.$query.'%')->orWhere('searchstring','like','%'.$query.'%');
							})->with('variants')->with('variantsCount')->orderBy('searchstring', 'asc');
				//$products = $currUser->products()->where('title','like','%'.$request['query'].'%')->orWhere('searchstring','like','%'.$request['query'].'%')->with('variants')->with('variantsCount')->orderBy('searchstring', 'asc');
				return $products->paginate($per_page);
			} else if($currUser->id == '1828'){				
				$query = $request['query'];
				$queryArr = explode(" ", $query);
				$statusCondition = '';
				foreach($queryArr as $val){
					if($val == 'notimported'){
						$statusCondition = 'Ready to Import';
						break;
					} else if($val == 'imported'){
						$statusCondition = 'Imported';
						break;
					}
				}
				$products = $currUser->products();
				if($statusCondition != ''){
					$products = $products->where("status", '=', $statusCondition);
				}
				$products = $products->where(function($q) use ($queryArr, $query) {
									$q->where('searchstring','like','%'.$query.'%')->orWhere(function($q1) use ($queryArr) {
										foreach($queryArr as $query1){
											if($query1 != 'notimported' && $query1 != 'imported'){
												$q1->where('title','like','%'.trim($query1).'%');
											}											
										}
									});		
							})->with('dupProduct')->with('variants')->with('variantsCount')->orderBy('searchstring', 'asc');	
/*				$products = $currUser->products()->where(function($q) use ($query) {
									$q->where('title','like','%'.$query.'%')->orWhere('searchstring','like','%'.$query.'%');
							})->with('dupProduct')->with('variants')->with('variantsCount')->orderBy('searchstring', 'asc');				*/
				return $products->paginate($per_page);
			} else if($currUser->id == '2805'){				
				$query = $request['query'];
				$queryArr = explode(" ", $query);
				$statusCondition = '';
				foreach($queryArr as $val){
					if($val == 'notimported'){
						$statusCondition = 'Ready to Import';
						break;
					} else if($val == 'imported'){
						$statusCondition = 'Imported';
						break;
					}
				}
				$products = $currUser->products();
				if($statusCondition != ''){
					$products = $products->where("status", '=', $statusCondition);
				}
				$products = $products->where(function($q1) use ($queryArr) {									
										foreach($queryArr as $query1){
											if($query1 != 'notimported' && $query1 != 'imported'){
												$q1->where('title','like','%'.trim($query1).'%');
											}											
										}
							})->with('dupProduct')->with('variants')->with('variantsCount');
				return $products->paginate($per_page);
			} else if($currUser->id == '2815'){
				$products = $currUser->products()->where('title','like','%'.$request['query'].'%')->with('variants')->with('variantsCount')->orderBy('status', 'asc');
				return $products->paginate($per_page);
			} else if($currUser->id == '4940'){
				$products = $currUser->products()->where('title','like','%'.$request['query'].'%')->with('variants')->with('variantsCount')->orderBy('product_id', 'desc');
				return $products->paginate($per_page);
			} else if($currUser->id == '4906'){
				$products = $currUser->products()->where('title','like','%'.$request['query'].'%')->where("status", '!=', "Already Exist")->with('variants')->with('variantsCount')->orderBy('product_id', 'desc');
				return $products->paginate($per_page);
			} else if($currUser->id == '7702'){
				$products = $currUser->products()->where('title','like','%'.$request['query'].'%')->where("status", '!=', "Imported")->where("block", '!=', "1")->with('variants')->with('variantsCount')->orderBy('product_id', 'desc');
				return $products->paginate($per_page);
			} else if($currUser->id == '3701'){
				$products = $currUser->products()->where('title','like','%'.$request['query'].'%')->where("searchstring", '!=', "OUTOFSTOCK")->with('variants')->with('variantsCount');
				return $products->paginate($per_page);
			} else if($currUser->id == '8552'){
			    $products = $currUser->products()->where('title','like','%'.$request['query'].'%')->where('deleted', '=', 0)->with('variants')->with('variantsCount');
				
				return $products->paginate($per_page);
			} else {
				$products = $currUser->products()->where('title','like','%'.$request['query'].'%')->with('variants')->with('variantsCount');
				return $products->paginate($per_page);
			}			
        } else {
			return $this->index();
		}
    }

    public function index()
    {
        $per_page = \Request::get('per_page') ?: 20;
	    $currUser = Auth::User();
		if($currUser->id == '1768' || $currUser->id == '4879'){
			$products = $currUser->products()->with('variants')->with('variantsCount')->latest()->paginate($per_page);
			return $products;
		} else if($currUser->id == '1872'){
			$per_page = \Request::get('per_page') ?: 100;
			$products = $currUser->products()->with('variants')->with('variantsCount')->orderBy('searchstring', 'asc')->paginate($per_page);
			return $products;
		} else if($currUser->id == '1828'){
			$products = $currUser->products()->with('dupProduct')->with('variants')->with('variantsCount')->paginate($per_page);
			return $products;
		} else if($currUser->id == '2815'){
			$products = $currUser->products()->with('variants')->with('variantsCount')->orderBy('status', 'asc')->paginate($per_page);
			return $products;
		} else if($currUser->id == '4940' || $currUser->id == '15002145' ){
			$products = $currUser->products()->with('variants')->with('variantsCount')->orderBy('product_id', 'desc')->paginate($per_page);
			return $products;
		} else if($currUser->id == '4906'){
			$products = $currUser->products()->where("status", '!=', "Already Exist")->with('variants')->with('variantsCount')->orderBy('product_id', 'desc')->paginate($per_page);
			return $products;
		} else if($currUser->id == '7702'){
			$products = $currUser->products()->where("status", '!=', "Imported")->where("block", '!=', "1")->with('variants')->with('variantsCount')->orderBy('product_id', 'desc')->paginate($per_page);
			return $products;			
		} else if($currUser->id == '3701'){
			$products = $currUser->products()->where("searchstring", '!=', "OUTOFSTOCK")->with('variants')->with('variantsCount')->paginate($per_page);
			return $products;			
		} else if($currUser->id == '8552'){
		    $products = $currUser->products()->where('deleted', '=', 0)->with('variants')->with('variantsCount')->paginate($per_page);
			return $products;
		} else {
			$products = $currUser->products()->with('variants')->with('variantsCount')->paginate($per_page);
			return $products;
		}		
	}    
	
	public function remove($ids){
		if(!$this->validateMembership()){
			return response()->json(['error' => ["msg"=>["Your membership has been expired. Please activate the subscription."]]], 406);
		}
		$temp = explode(",", $ids);
		$count = count($temp);
		if($count == 0){
			return response()->json(['error' => ["msg"=>["Please choose atleast one product."]]], 406);
		}
		$currUser = Auth::User();
		$token = $currUser->token;
		$shopurl = $currUser->shopurl;
		$user_id = $currUser->id;
		foreach($temp as $id){
			$productObj = $currUser->products()->find($id);
			if($productObj){
				$shopifyproductid = $productObj['shopifyproductid'];
				if(strlen($shopifyproductid) > 0){
					$this->deleteShopifyProduct($user_id, $token, $shopurl, $shopifyproductid);
				/*	\DB::delete("DELETE from product_variants WHERE user_id = ? and product_id = ?", [$user_id, $id]);
				    \DB::delete("DELETE from products WHERE user_id = ? and product_id = ?", [$user_id, $id]);
				//	$productObj->variants()->delete();
    		     //   $productObj->delete();*/
				} else {//\DB::delete('DELETE from users WHERE id = ?', ['2']);
				    /*\DB::delete("DELETE from product_variants WHERE user_id = ? and product_id = ?", [$user_id, $id]);
				    \DB::delete("DELETE from products WHERE user_id = ? and product_id = ?", [$user_id, $id]);
				   // $productObj->variants()->delete();
    		      //  $productObj->delete();*/
				}
				$currUser->products()->where('product_id', "=", $id)->update(['deleted' => 1]);
			}
		}
		return response()->json(['success'], 200);
	}

	public function block($id){
		$temp = explode(",", $id);
		$count = count($temp);
		if($count == 0){
			return response()->json(['error' => ["msg"=>["Please choose atleast one product."]]], 406);
		}
		$currUser = Auth::User();
		$blockedCount = $currUser->products()->whereIn('product_id', $temp)->where(function ($query) {
			$query->where('block', '=', 1)->orWhere('status', '!=', 'Ready to Import');
				})->count();
		if($blockedCount > 0){
			$errMsg = "The selected products could not be blocked.";
			if($count == 1){
				$errMsg = "The selected product could not be blocked.";
			}
			return response()->json(['error' => ["msg"=>[$errMsg]]], 406);
		}
		$currUser->products()->whereIn('product_id', $temp)->update(['block' => 1]);
		$currUser->productvariants()->whereIn('product_id', $temp)->update(['block' => 1]);
        return response()->json(['success'], 200);
	}

	public function unblock($id){
		$temp = explode(",", $id);
		$count = count($temp);
		if($count == 0){
			return response()->json(['error' => ["msg"=>["Please choose atleast one product."]]], 406);
		}
		$currUser = Auth::User();
		$currUser->products()->whereIn('product_id', $temp)->update(['block' => 0]);
		$currUser->productvariants()->whereIn('product_id', $temp)->update(['block' => 0]);
        return response()->json(['success'], 200);
	}

	public function push($id){
		if(!$this->validateMembership()){
			return response()->json(['error' => ["msg"=>["Your membership has been expired. Please activate the subscription to import more products."]]], 406);
		}
		$temp = explode(",", $id);
		$count = count($temp);
		if($count == 0){
			return response()->json(['error' => ["msg"=>["Please choose atleast one product."]]], 406);
		}
		$currUser = Auth::User();
		$count = $currUser->products()->whereIn('product_id', $temp)->where('status', '!=', 'Ready to Import')->count();
		if($count > 0){
			return response()->json(['error' => ["msg"=>['The selected products could not push to shopify.']]], 406);
		} else {
			$skulimit = $currUser->skulimit;
			$skuconsumed = $currUser->skuconsumed;
			$vcount = $currUser->productvariants()->whereIn('product_id', $temp)->where('block', 0)->where('duplicate', 0)->where('status', '=', 'Ready to Import')->count();
			if($skulimit < ($skuconsumed + $vcount)){
				return response()->json(['error' => ["msg"=>['The number of SKUs you want to import is more than your allowed limit. Please upgrade your plan.']]], 406);				
			} else {
				$currUser->products()->whereIn('product_id', $temp)->where('block', 0)->where('duplicate', 0)->where('status', '=', 'Ready to Import')->update(['status' => 'Import in Progress']);
				$currUser->skuconsumed = $skuconsumed + $vcount;
				$currUser->save();
				return response()->json(['skuconsumed' => $currUser->skuconsumed], 200);
			}
		}
	}

	public function pushall(){	
		if(!$this->validateMembership()){
			return response()->json(['error' => ["msg"=>["Your membership has been expired. Please activate the subscription to import more products."]]], 406);
		}
		$currUser = Auth::User();
		$skulimit = $currUser->skulimit;
		$skuconsumed = $currUser->skuconsumed;
		/*$products = $currUser->products()->where('status', 'Ready to Import')->where('block', 0)->with('variantsCount')->get();
		$vcount = 0;
		foreach($products as $product){			
			$vcount  = $vcount + $product->variantsCount()->first()->no_of_variants;
		}*/
		$vcount = $currUser->productvariants()->where('block', 0)->where('duplicate', 0)->where('status', '=', 'Ready to Import')->count();
		if($skulimit < ($skuconsumed + $vcount)){
			return response()->json(['error' => ["msg"=>['The number of SKUs you want to import is more than your allowed limit. Please upgrade your plan.']]], 406);			
		} else {
			$currUser->products()->where('status', 'Ready to Import')->where('block', 0)->where('duplicate', 0)->update(['status' => 'Import in Progress']);
			$currUser->skuconsumed = $skuconsumed + $vcount;
			$currUser->save();
			return response()->json(['skuconsumed' => $currUser->skuconsumed], 200);
		}		
	}
	
	public function pushEB($id){
		if(!$this->validateMembership()){
			return response()->json(['error' => ["msg"=>["Your membership has been expired. Please activate the subscription to import more products."]]], 406);
		}
		$temp = explode(",", $id);
		$count1 = count($temp);
		if($count1 == 0){
			return response()->json(['error' => ["msg"=>["Please choose atleast one product."]]], 406);
		}
		$currUser = Auth::User();
		$count = $currUser->products()->whereIn('product_id', $temp)->where('eb_status', '!=', 'Ready to Import')->count();
		if($currUser->id != '1828' && $count > 0){
			return response()->json(['error' => ["msg"=>['The selected products could not push to eBay.']]], 406);
		} else {
			if($currUser->id == '2820') {
				$catCount = $currUser->ebCategoryMappings()->whereIn('product_id', $temp)->count();
				if($catCount < $count1){
					return response()->json(['error' => ["msg"=>['Please define eBay category.']]], 406);
				}
				
			}
			$skulimit = $currUser->skulimit;
			$skuconsumed = $currUser->skuconsumed;
			$currUser->products()->whereIn('product_id', $temp)->where('block', 0)->where('duplicate', 0)->update(['eb_status' => 'Import in Progress']);
			return response()->json(['skuconsumed' => $currUser->skuconsumed], 200);
		}
	}

	public function pushWM($id){
		if(!$this->validateMembership()){
			return response()->json(['error' => ["msg"=>["Your membership has been expired. Please activate the subscription to import more products."]]], 406);
		}
		$temp = explode(",", $id);
		$count = count($temp);
		if($count == 0){
			return response()->json(['error' => ["msg"=>["Please choose atleast one product."]]], 406);
		}
		$currUser = Auth::User();
		$count = $currUser->products()->whereIn('product_id', $temp)->where('wm_status', '!=', 'Ready to Import')->count();
		if($count > 0){
			return response()->json(['error' => ["msg"=>['The selected products could not push to Walmart.']]], 406);
		} else {
			$skulimit = $currUser->skulimit;
			$skuconsumed = $currUser->skuconsumed;
			$currUser->products()->whereIn('product_id', $temp)->where('block', 0)->where('duplicate', 0)->where('wm_status', '=', 'Ready to Import')->update(['wm_status' => 'Import in Progress']);
			return response()->json(['skuconsumed' => $currUser->skuconsumed], 200);
		}
	}
	
	public function pushDupAmz($id){
		if(!$this->validateMembership()){
			return response()->json(['error' => ["msg"=>["Your membership has been expired. Please activate the subscription to import more products."]]], 406);
		}
		$temp = explode(",", $id);
		$count = count($temp);
		if($count == 0){
			return response()->json(['error' => ["msg"=>["Please choose atleast one product."]]], 406);
		}
		$currUser = Auth::User();
		$count = $currUser->dupProducts()->whereIn('orig_product_id', $temp)->where('status', '!=', 'Ready to Import')->count();
		if($currUser->id != '1828' && $count > 0){
			return response()->json(['error' => ["msg"=>['The selected products could not push to eBay.']]], 406);
		} else {
			$skulimit = $currUser->skulimit;
			$skuconsumed = $currUser->skuconsumed;
			$currUser->dupProducts()->whereIn('orig_product_id', $temp)->update(['status' => 'Import in Progress']);

			$feedObject = AmzFeed::create(array("products" => $id, "status" => "readyforproduct"));
			$currUser->amzFeeds()->save($feedObject);
			return response()->json(['skuconsumed' => $currUser->skuconsumed], 200);
		}
	}
	
	public function requestImgRefresh($id){
		if(!$this->validateMembership()){
			return response()->json(['error' => ["msg"=>["Your membership has been expired. Please activate the subscription to continue."]]], 406);
		}
		$temp = explode(",", $id);
		$count = count($temp);
		if($count == 0){
			return response()->json(['error' => ["msg"=>["Please choose atleast one product."]]], 406);
		}
		$currUser = Auth::User();
		$count = $currUser->imgReimportRequests()->whereIn('product_id', $temp)->where('status', '=', 0)->count();
		if($count > 0){
			return response()->json(['error' => ["msg"=>['Request already in progress.']]], 406);
		} else {
			foreach($temp as $product_id){
				$imgObject = ImgReimportRequests::create(array("product_id" => $product_id, "status" => "0"));
				$currUser->imgReimportRequests()->save($imgObject);
			}
			return response()->json([], 200);
		}
	}

	public function updateUPC(Request $request) {
		$currUser = Auth::User();
		$validator = Validator::make($request->all(), [
								'variant_id' => 'required',
								'upc' => 'required|min:10'
							]);
		if ($validator->fails()) {
			return response()->json(['error' => $validator->errors()], 406);
		} else {			
			$variant_id = $request->input('variant_id');
			$upc = $request->input('upc');
			$existingCount = $currUser->productVariants()->where("productid", "=", $upc)->count();
			if($existingCount > 0){
				return response()->json(['error' => ["msg"=>['This UPC code is already attached with other SKU.']]], 406);
			}
			$productVariantObj = ProductVariant::find($variant_id);
			if($productVariantObj){
				$productVariantObj->update(array("productid" => $upc, "productidtype" => 3));
				return response()->json(['success'], 200);
			} else {
				return response()->json(['error' => ["msg"=>['No valid product variant exists for the given variant_id.']]], 406);
			}
		}
	}
	
	public function suggestedPlan(){
		$currUser = Auth::User();
		$count = $currUser->productvariants()->count();//->where('quantity', '>', 0)
		$suggestedPlanType = 1;
		$suggestedPlanName = "BRONZE";
		if($count > 5000){
			$suggestedPlanType = 4;
			$suggestedPlanName = "CUSTOM";
		} else if($count > 2000){
			$suggestedPlanType = 3;
			$suggestedPlanName = "GOLD";
		} else if($count > 500) {
			$suggestedPlanType = 2;
			$suggestedPlanName = "SILVER";
		}
		if($currUser->id == '2614') {
			$suggestedPlanType = 2;
			$suggestedPlanName = "SILVER";
		}
		if($currUser->id == '3779') {
			$suggestedPlanType = 1;
			$suggestedPlanName = "BRONZE";
		}
		if($currUser->id == '4879') {
			$suggestedPlanType = 1;
			$suggestedPlanName = "BRONZE";
		}
		if($currUser->id == '4940') {
			$suggestedPlanType = 1;
			$suggestedPlanName = "BRONZE";
		}
		if($currUser->id == '1667') {
			$suggestedPlanType = 2;
			$suggestedPlanName = "SILVER";
		}
		if($currUser->id == '5458') {
			$suggestedPlanType = 1;
			$suggestedPlanName = "BRONZE";
		}
		if($currUser->id == '6890') {
			$suggestedPlanType = 3;
			$suggestedPlanName = "GOLD";
		}
		if($currUser->id == '10817' || $currUser->id == '4957' || $currUser->id == '3044' || $currUser->id == '6373' || $currUser->id == '9025' || $currUser->id == '10183') {
			$suggestedPlanType = 2;
			$suggestedPlanName = "SILVER";
		}
		if($currUser->id == '5054' || $currUser->id == '10393' || $currUser->id == '9794' || $currUser->id == '1667' || $currUser->id == '5508' || $currUser->id == '3732' || $currUser->id == '6088' || $currUser->id == '5756') {
			$suggestedPlanType = 1;
			$suggestedPlanName = "BRONZE";
		}
		return response()->json(['count' => $count, 'suggestedPlanType' => $suggestedPlanType, 'suggestedPlanName' => $suggestedPlanName], 200);
	}

	private function validateMembership(){
		$currUser = Auth::User();
		$review = $currUser->review;
		$paid_at = $currUser->paid_at;
		$created_at = $currUser->created_at;
		$fromtime = new Carbon($paid_at);
		if(strtotime($paid_at) < 1){
			$fromtime = new Carbon($created_at);
		}		
		$now = Carbon::now();
		$difference = $fromtime->diffInDays($now);
		if($difference > 30 && $currUser->sync == 0 && $currUser->review == 0) {
			return false;
		} else if($difference > 60 && $currUser->sync == 0 && $currUser->review == 1) {
			return false;
		} else {
			return true;
		}		
	}

	public function exportFile(Request $request) {
		ini_set('memory_limit', '-1');
		$currUser = Auth::User();
		if($currUser->id != '1828'){
			return response()->json(['error' => ["msg" => ['You are not authorized to access this resource.']]], 406);
		}		
		$products = $currUser->productvariants()->where("ebayitemid", "!=", "")->get(['sku','ebayitemid']);

		Excel::create('user', function($excel) use ($products) {
			$excel->sheet('Sheet 1', function ($sheet) use ($products) {
				$sheet->fromArray($products);
			});
		})->store("xlsx", public_path()."/reports/");
		return response()->json(['success'], 200);
    }

	public function exportFile1(Request $request) {
		ini_set('memory_limit', '-1');
		$currUser = Auth::User();
		if($currUser->id != '1828'){
			return response()->json(['error' => ["msg" => ['You are not authorized to access this resource.']]], 406);
		}		
		$products = $currUser->dupProductvariants()->where("new_asin", "!=", "")->get(['old_sku','new_sku','new_asin']);

		Excel::create('dupamz', function($excel) use ($products) {
			$excel->sheet('Sheet 1', function ($sheet) use ($products) {
				$sheet->fromArray($products);
			});
		})->store("xlsx", public_path()."/reports/");
		return response()->json(['success'], 200);
    }

    public function resync(){	
		if(!$this->validateMembership()){
			return response()->json(['error' => ["msg"=>["Your membership has been expired. Please activate."]]], 406);
		}
		
		$currUser = Auth::User();		
		$existingRequests = $currUser->tasks()->where('status', '!=', 'completed')->first();
		if($existingRequests){
			return response()->json(['error' => ["msg"=>['A request is already in progress.']]], 406);			
		}
		if($currUser->id == '9251'){
			$Request = Task::create(array("taskname" => 'inventoryreport', "status" => "pending"));
			$currUser->tasks()->save($Request);			
		} else {
			$Request = Task::create(array("taskname" => 'resynctitlebullets', "status" => "pending"));
			$currUser->tasks()->save($Request);			
		}
		return response()->json(['success'], 200);		
	}

	function deleteShopifyProduct($user_id, $token, $shopurl, $product_id){
		return response()->json(['success'], 200);
	}
}