<?php

namespace App;

use Illuminate\Auth\Authenticatable;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Auth\Passwords\CanResetPassword;
use Illuminate\Foundation\Auth\Access\Authorizable;
use Illuminate\Contracts\Auth\Authenticatable as AuthenticatableContract;
use Illuminate\Contracts\Auth\Access\Authorizable as AuthorizableContract;
use Illuminate\Contracts\Auth\CanResetPassword as CanResetPasswordContract;
use Nicolaslopezj\Searchable\SearchableTrait;
use PhpSoft\Users\Models\UserTrait;

class User extends Model implements AuthenticatableContract,
                                    //AuthorizableContract,
                                    CanResetPasswordContract
{
	
    use Authenticatable, CanResetPassword,UserTrait;

    /**
     * The database table used by the model.
     *
     * @var string
     */
    protected $table = 'users';


    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'ownername', 'email', 'password'
    ];

    /**
     * The attributes excluded from the model's JSON form.
     *
     * @var array
     */
    protected $hidden = ['password', 'remember_token'];

    public function products() {
		return $this->hasMany('App\Product', 'user_id', 'id');
	}
	
	public function productvariants() {
		return $this->hasMany('App\ProductVariant', 'user_id', 'id');
	}
	
	public function dupProducts() {
		return $this->hasMany('App\DupProduct', 'user_id', 'id');
	}
	
	public function dupProductvariants() {
		return $this->hasMany('App\DupProductVariant', 'user_id', 'id');
	}

	public function amzKey(){
		return $this->hasOne('App\AmzKey', 'user_id', 'id')->select('id','merchant_id','marketplace_id','access_key_id','secret_access_key','mws_token','lastdatafetched','valid');
	}
	
	public function amzRequests(){
		return $this->hasMany('App\AmzRequest', 'user_id', 'id');
	}

	public function settings() {
		return $this->hasOne('App\Setting', 'user_id', 'id');
	}

	public function ebCategoryMappings(){
		return $this->hasMany('App\EbCategoryMapping', 'user_id', 'id');
	}

	public function amzFeeds(){
		return $this->hasMany('App\AmzFeed', 'user_id', 'id');
	}

	public function ebProducts() {
		return $this->hasMany('App\EbProduct', 'user_id', 'id');
	}
	
	public function ebProductvariants() {
		return $this->hasMany('App\EbProductVariant', 'user_id', 'id');
	}

	public function tasks() {
		return $this->hasMany('App\Task', 'user_id', 'id');
	}

	public function imgReimportRequests() {
		return $this->hasMany('App\ImgReimportRequests', 'user_id', 'id');
	}
}